@extends('layouts.app')
@section('title', config('app.name').' - '.$title)
@section('description', $description)
@section('content')
<div id="header-cta">
    <div class="container">
        <div class="row pb-1">
            <div class="col-lg-12 col-md-12">
                <div class="left_side text-center">
                    <h1>{{$homepage_ctaTitle}}</h1>
                    <p>{{$homepage_ctaParagraphHtml}}</p>
                    <div class="buttons_cta">
                        @if ( App\Models\Config::whereName('trial_allowed')->first()->value == 1 )
                        <a class="home_cta green" target="_blank" href="{{route('wtsp').'?text=Please I Wanna Try The Server Before I Buy'}}">
                            Try Before You Buy
                            <i class="fa fa-arrow-right"></i>
                        </a>
                        @endif
                        <a class="home_cta" href="#subscribe">
                            Our Subscriptions
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <!-- <img class="img-responsive main_header" width="500" height="429" src="{{asset('images/main_header2.webp')}}" alt=""> -->
                    <img class="img-responsive main_header" width="500" height="316" src="{{asset('images/main.webp')}}" alt="">
                </div>
            </div>
            <div class="col-lg-6">
                <div class="text-center">
                    
                </div>
            </div>
        </div>
    </div>
    <!-- <div class="divider"><span></span></div> -->
    <div id="bottom-header" class="text-center">
        <h2>{{$homepage_mainTitle}}</h2>
        {!! $homepage_mainParagraphHtml !!}
        @if(true)
        <img class="bigMainImg" width="900" height="506" src="{{asset('images/epg.webp')}}" alt="">
        @else
        @mobile
        <img class="bigMainImg" width="900" height="497" src="{{asset('images/main.png')}}" alt="">
        @elsemobile
        <iframe id="myIframe" width="100%" height="100%" src="https://player.vimeo.com/video/836267005?autoplay=1&playsinline=1&color&autopause=0&loop=1&muted=1&title=0&portrait=0&byline=0#t=" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen title="best iptv server provider in 2024"></iframe>
        <script src="https://player.vimeo.com/api/player.js"></script>
        @endmobile
        @endif
    </div>
</div>
@if ( \App\Models\Config::whereName('homepage_showTargetedCountry')->first()->value == 1 )
<div class="post-section text-center">
    <div class="col-md-10">
        <div class="content">
            <h2>Watch All <span class="colored">Canadian</span> & <span class="colored">American</span> IPTV Channels Without <span class="colored">Tv Cable</span></h2>
            <p>Welcome to the future of entertainment! At {{config('app.name')}}, we're dedicated to provide you with the best IPTV service in Canada. Whether you're looking for live sports, international channels, or the latest movies and TV shows, we've got you covered.</p>
            @if ( true )
            <ul class="gallery col-md-10">
                <li><img width="75" height="25" src="{{asset('images/channels/national.webp')}}" alt="national"></li>
                <li><img width="75" height="25" src="{{asset('images/channels/discovery.webp')}}" alt="discovery"></li>
                <li><img width="75" height="25" src="{{asset('images/channels/pbs.webp')}}" alt="pbs"></li>
                <li><img width="75" height="25" src="{{asset('images/channels/cbs.webp')}}" alt="cbs"></li>
                <li><img width="60" height="60" src="{{asset('images/channels/paramount.webp')}}" alt="paramount"></li>
                <li><img width="60" height="60" src="{{asset('images/channels/abc.webp')}}" alt="abc"></li>
                <li><img width="60" height="60" src="{{asset('images/channels/hbo.webp')}}" alt="hbo"></li>
                <li><img width="75" height="25" src="{{asset('images/channels/tva.webp')}}" alt="tva"></li>
                <li><img width="76.25" height="25" src="{{asset('images/channels/cbc.webp')}}" alt="cbc"></li>
                <li><img width="49" height="25" src="{{asset('images/channels/cp24.webp')}}" alt="cp24"></li>
                <li><img width="69" height="25" src="{{asset('images/channels/astral.webp')}}" alt="astral"></li>
                <li><img width="59" height="20" src="{{asset('images/channels/tsn.webp')}}" alt="tsn"></li>
                <li><img width="47" height="25" src="{{asset('images/channels/sn.webp')}}" alt="sportsnet"></li>
                <li><img width="76" height="25" src="{{asset('images/channels/ctv.webp')}}" alt="ctv"></li>
                <li><img width="74" height="25" src="{{asset('images/channels/rds.webp')}}" alt="rds"></li>
                <li><img width="67" height="25" src="{{asset('images/channels/bnn.webp')}}" alt="bnn"></li>
            </ul>   
            @endif
            <a class="explore_channels" href="{{route('channels_list')}}">
                <i class="fa fa-bars" aria-hidden="true"></i>
                Explore Channels List
                <i class="fa fa-arrow-right" aria-hidden="true"></i>
            </a>
        </div>
    </div>
</div>
@endif
@if ( \App\Models\Config::whereName('homepage_vodEnabled')->first()->value == 1 )
<div class="post-section vod_section text-center dark_background">
    <div class="vod_container">
        <h2>Watch The Latest <span class="colored">Series</span> & <span class="colored">Movies</span> with VOD on IPTV</h2>
        <p>We have a vast list of vod ( series & movies ) updated monthly. you can watch your favorite tv shows and documentaries at any time. all of it are from multiple platforms like Prime, Hbo, Netflix, Hulo, Disney, Sling Tv, Apple Tv And More</p>
        @mobile
        <div class="vod_item"><img width="233" height="349" src="{{asset('images/vod/avatar.webp')}}" alt="avatar"></div>
        @elsemobile
        <div class="vod owl-carousel owl-theme">
        <div class="vod_item"><img width="233" height="349" src="{{asset('images/vod/1.webp')}}" alt="asteroid city"></div>
        <div class="vod_item"><img width="233" height="349" src="{{asset('images/vod/2.webp')}}" alt="asteroid city"></div>
        <div class="vod_item"><img width="233" height="349" src="{{asset('images/vod/3.webp')}}" alt="asteroid city"></div>
        <div class="vod_item"><img width="233" height="349" src="{{asset('images/vod/4.webp')}}" alt="asteroid city"></div>
        <div class="vod_item"><img width="233" height="349" src="{{asset('images/vod/5.webp')}}" alt="asteroid city"></div>
        <div class="vod_item"><img width="233" height="349" src="{{asset('images/vod/6.webp')}}" alt="asteroid city"></div>
        <div class="vod_item"><img width="233" height="349" src="{{asset('images/vod/7.webp')}}" alt="asteroid city"></div>
        <div class="vod_item"><img width="233" height="349" src="{{asset('images/vod/8.webp')}}" alt="asteroid city"></div>
        <div class="vod_item"><img width="233" height="349" src="{{asset('images/vod/9.webp')}}" alt="asteroid city"></div>
        <div class="vod_item"><img width="233" height="349" src="{{asset('images/vod/10.webp')}}" alt="asteroid city"></div>
        <div class="vod_item"><img width="233" height="349" src="{{asset('images/vod/11.webp')}}" alt="asteroid city"></div>
        <div class="vod_item"><img width="233" height="349" src="{{asset('images/vod/12.webp')}}" alt="asteroid city"></div>
        <div class="vod_item"><img width="233" height="349" src="{{asset('images/vod/13.webp')}}" alt="asteroid city"></div>
        <div class="vod_item"><img width="233" height="349" src="{{asset('images/vod/14.webp')}}" alt="asteroid city"></div>
        <div class="vod_item"><img width="233" height="349" src="{{asset('images/vod/15.webp')}}" alt="asteroid city"></div>
        <div class="vod_item"><img width="233" height="349" src="{{asset('images/vod/16.webp')}}" alt="asteroid city"></div>
        <div class="vod_item"><img width="233" height="349" src="{{asset('images/vod/17.webp')}}" alt="asteroid city"></div>
        </div>
        @endmobile
    </div>
</div>
@endif
<div class="post-section news_section text-center dark_background">
    <div class="col-md-11">
        <div class="content">
            <h2>The Best IPTV 2024 To Watch All International <span class="colored">Sports Events</span>, including ppv iptv</h2>
            <p>At our IPTV subscription service, we are proud to offer an extensive range of sports channels that cater to every sports enthusiast's needs. Our sports channels cover a vast variety of sports including football, basketball, baseball, tennis, golf, rugby, and more.</p>
            <ul class="gallery col-md-10">
                <li><img width="50" height="50" src="{{asset('images/leagues/webp/laliga.webp')}}" alt="la liga"></li>
                <li><img width="50" height="50" src="{{asset('images/leagues/webp/seriea.webp')}}" alt="serie a"></li>
                <li><img width="50" height="50" src="{{asset('images/leagues/webp/epl.webp')}}" alt="epl"></li>
                <li><img width="50" height="50" src="{{asset('images/leagues/webp/uefa-champions-league.webp')}}" alt="uefa champions league"></li>
                <li><img width="50" height="50" src="{{asset('images/leagues/webp/europa-league.webp')}}" alt="europa league"></li>
                <li><img width="50" height="50" src="{{asset('images/leagues/webp/nhl.webp')}}" alt="nhl"></li>
                <li><img width="50" height="50" src="{{asset('images/leagues/webp/nfl.webp')}}" alt="nfl"></li>
                <li><img width="50" height="50" src="{{asset('images/leagues/webp/mlb.webp')}}" alt="mlb"></li>
                <li><img width="50" height="50" src="{{asset('images/leagues/webp/mls.webp')}}" alt="mls"></li>
                <li><img width="50" height="50" src="{{asset('images/leagues/webp/nba.webp')}}" alt="nba"></li>
                <li><img width="50" height="50" src="{{asset('images/leagues/webp/f1.webp')}}" alt="f1"></li>
                <li><img width="50" height="50" src="{{asset('images/leagues/webp/bundesliga.webp')}}" alt="bundesliga"></li>
            </ul>
            <p>since we are the best iptv provider at to the top of all iptv providers in canada, you can watch IPTV sports channels, and enjoy live and on-demand coverage of all the major sports events from around the world using our best canada iptv 2024. Whether you're a fan of the English Premier League, La Liga, Eredivisie, Champions League, Europa League, the NBA, the MLB, the ATP Tour, or the Six Nations Rugby Championship, we've got you covered.</p>
            <ul class="gallery col-md-10">
                <li><img width="63" height="30" src="{{asset('images/channels/bein.webp')}}" alt="bein"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/eleven.webp')}}" alt="eleven"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/bt_sport.webp')}}" alt="bt sport"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/canal_plus.webp')}}" alt="canal plus"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/play_sports.webp')}}" alt="play sports"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/dazn.webp')}}" alt="dazn"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/nova_sport.webp')}}" alt="nova sport"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/super_sport1.webp')}}" alt="super sport"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/super_sport2.webp')}}" alt="super sport"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/sportsnet.webp')}}" alt="sportsnet"></li>
            </ul>
        </div>
    </div>
</div>
@if ( false )
<div class="post-section text-center">
    <div class="col-md-10">
        <div class="content">
            <h2>We Cover Almost <span class="colored">All Countries</span> Around The World</h2>
            <p>We offer thousands of IPTV channels covering the Ireland, Canada, USA, UK, Portugal, Albania, Germany, Italy, France, Brasil, Romania, Greece, Spain, Sweden, Finland, Ireland, Norway, Denemark, Latino countries, Arabic countries and almost all countries around the world.</p>
            <ul class="gallery col-md-10">
                <li><img width="63" height="30" src="{{asset('images/channels/abc.webp')}}" alt="bein"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/bein.webp')}}" alt="bein"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/cnn.webp')}}" alt="cnn"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/disney.webp')}}" alt="disney"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/espn.webp')}}" alt="espn"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/fox.webp')}}" alt="fox"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/hbo.webp')}}" alt="hbo"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/nbc.webp')}}" alt="nbc"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/amc.webp')}}" alt="amc"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/nba.webp')}}" alt="nba"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/eleven.webp')}}" alt="eleven"></li>
            </ul>
            <a class="explore_channels" href="{{route('channels_list')}}">
                <i class="fa fa-bars" aria-hidden="true"></i>
                Explore Channels List
                <i class="fa fa-arrow-right" aria-hidden="true"></i>
            </a>
        </div>
    </div>
</div>
@endif
<div id="choose_us" class="text-center dark_background">
    <div class="container">
        <h2>why <span class="colored">{{config('app.name')}}</span> is the right IPTV option and the best ?</h2>
        <div class="divider"><span></span></div>
        <div class="row mt-4">
            <div class="col-md-4">
                <div class="choose_us_itm">
                    <i class="fa fa-ticket"></i>
                    <h3>24/7 Customer Support</h3>
                    <p><span>We do offer multiple support options live by whatsapp, By live chat button and through email.</span></p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="choose_us_itm">
                    <i class="fa fa-refresh"></i>
                    <h3>Anti Freeze™ 8.0</h3>
                    <p><span>Using Anti-Freeze Technology, You do not need to worry about the server stability.</span></p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="choose_us_itm">
                    <i class="fa fa-laptop"></i>
                    <h3>Watch On Any Device</h3>
                    <p><span>Our IPTV service works on any device such as TVs, Smartphones, FireStick, MAG, Android Boxes etc…</span></p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4">
                <div class="choose_us_itm">
                    <i class="fa fa-thumbs-up"></i>
                    <h3>Best IPTV Quality</h3>
                    <p><span>We do provide all our channels in different qualities depending on your network, SD/HD/FHD/2K/4K.</span></p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="choose_us_itm">
                    <i class="fa fa-list-ol"></i>
                    <h3>18,700 Channels</h3>
                    <p><span>18,700 channels & 118K VOD (Movies & Series) Worldwide. <span class="colored">The Best bouquet in the market</span></span></p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="choose_us_itm">
                    <i class="fa fa-clock-o"></i>
                    <h3>CATCH UP</h3>
                    <p><span>Our Server offers 72H Catchup for the channels that are offering Catchup from the source.</span></p>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="how_to_pay">
    <h2>How To Buy IPTV On Our Website ?</h2>
    <p>we have simplified the steps to be easy for you with a simple interface to order your IPTV subscription quite fast.</p>
    <div class="container text-center">
        <div class="row">
            <div class="col-md-3">
                <div class="item">
                    <i class="fa fa-check-circle-o"></i>
                    <h3>1. select connections</h3>
                    <p>look at the pricing table down bellow, select connections number tab</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="item">
                    <i class="fa fa-cart-plus"></i>
                    <h3>2. select subscription</h3>
                    <p>see what period do you want, then click order now</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="item">
                    <i class="fa fa-pencil-square-o"></i>
                    <h3>3. enter your details</h3>
                    <p>provide us with relevant information to get started with your order</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="item">
                    <i class="fa fa-credit-card-alt"></i>
                    <h3>4. checkout</h3>
                    <p>pay the service charges through PayPal Or Credit Card.</p>
                </div>
            </div>
        </div>
    </div>
</div>
@if( $standardCnumbers )
<div id="subscribe">
    <h2>Get the Best IPTV Canada Subscription Plans at Affordable Prices</h2>
    <p>
        Looking for reliable and affordable IPTV subscription plans? Look no further! Our website offers a wide range of IPTV plans with same features and different prices to suit your needs. Whether you're a sports enthusiast or a movie buff, we have the perfect plan for you. <br>
        Plus, with our competitive pricing, you can enjoy the best IPTV services without breaking the bank. Try us out today and see for yourself!
    </p>
    <div class="container">
        <p class="note">* if you wanna watch on multiple devices in the same time, choose the number of devices do you have. </p>
        <p class="note">* You will get separated accounts, each device with its connection details.</p>
        <nav>
            <div class="nav nav-tabs" id="nav-tab" role="tablist">
               @foreach ($standardCnumbers as $standardCnumber)
               <button class="nav-link {{$standardCnumber->id == $standardCnumbers[0]->id ? 'active' : '' }}" id="{{$standardCnumber->id}}-tab" data-bs-toggle="tab" data-bs-target="#nav-{{$standardCnumber->id}}" type="button" role="tab" aria-controls="nav-{{$standardCnumber->id}}" aria-selected="true">{{$standardCnumber->name}}</button>
               @endforeach
            </div>
         </nav>
        <div class="tab-content" id="nav-tabContent">
           @foreach ($standardCnumbers as $standardCnumber)
           <div class="tab-pane {{ $standardCnumbers[0]->id == $standardCnumber->id ? 'show active' : '' }}" id="nav-{{$standardCnumber->id}}" role="tabpanel" aria-labelledby="nav-one-tab">
               <div class="row d-flex justify-content-center text-center">
                  @foreach ($standardCnumber->products as $product)
                  <div class="col-lg-3 col-md-4 col-sm-6">
                     <div class="product-item {{$product->hot == 1 ? 'product_hot' : ''}} animate__animated animate__fadeIn">
                        @if($product->hot == 1)<span class="hot">🔥 POPULAR 🔥</span>@endif
                        <h2 class="period">{{$product->period}}</h2>
                        @if( $premiumCnumbers )<h2 class="server_type">{{$product->cnumber->category->name}}</h2>@endif
                        <div class="product_price">
                           <span class="price">{{$product->price}}</span>
                           <span class="currency">{{$currency->code}}</span>
                           <span class="old_price">{{number_format($product->price*100/60, 2).''.$currency->symbol}}</span>
                        </div>
                        <ul class="server_infos">
                           <li class="conn_number"><i class="fa fa-check-circle-o"></i>{{$standardCnumber->name}}</li>
                           @if( $product->monthly )
                           <li><i class="fa fa-check"></i>Only <span class="monthly">{{ $product->monthly.$currency->symbol }}</span> a Month</li>
                           @else
                           <li><i class="fa fa-check"></i>No Activation Fees</li>
                           @endif
                           <li><i class="fa fa-check"></i>+17.7k Channels</li>
                           <li><i class="fa fa-check"></i>Up to 14k Series</li>
                           <li><i class="fa fa-check"></i>Up to 44k Movies</li>
                           <li><i class="fa fa-check"></i>CATCH UP | EPG</li>
                           <li><i class="fa fa-check"></i>8k, 4K, Ultra HD and HQ</li>
                           <li><i class="fa fa-check"></i>Anti Freeze System</li>
                           <li><i class="fa fa-check"></i>MAG & Firestick</li>
                           <li><i class="fa fa-check"></i>Smarter & Tvmate APP</li>
                           <li><i class="fa fa-check"></i>Free Support 24/7</li>
                        </ul>
                        <form action="{{route('cart.store')}}" method="POST">
                           @csrf
                           <input type="hidden" name="id" value="{{$product->id}}">
                           @if( $product->in_stock == 1 )
                           <button type="submit" class="order_now_product" href="#">Order Now</button>
                            @else
                            <button disabled class="order_now_product btn btn-disabled" href="#">Not Available</button>
                            @endif
                        </form>
                     </div>
                  </div>
                  @endforeach
               </div>
            </div>
           @endforeach
           @if( true )
           <div class="more_than4">
            <h2>You want more than 5 connections ?</h2>
            <a class="reach_us" target="_blank" href="{{route('wtsp').'?text=Hi, I am interesting in more than 5 connections plans.'}}">
                <i class="fa fa-whatsapp"></i>
                Send WhatsApp MESSAGE
            </a>
            </div>
            @endif
        </div>
    </div>
</div>
@endif
@if( $premiumCnumbers)
<div id="subscribe" class="dark_background">
    <h2>PREMIUM SERVER</h2>
    <p>
        Interesting in a service with top notch quality with real 4k picture, you are in the right place, this server comes up with more series and movies in real 4k quality of picture
    </p>
    <div class="container">
        <p class="note">* if you wanna watch on multiple devices in the same time, choose the number of devices do you have. </p>
        <p class="note">* You will get separated accounts, each device with its connection details.</p>
        <nav>
            <div class="nav nav-tabs" id="nav-tab" role="tablist">
               @foreach ($premiumCnumbers as $premiumCnumber)
               <button class="nav-link {{$premiumCnumber->id == $premiumCnumbers[0]->id ? 'active' : '' }}" id="{{$premiumCnumber->id}}-tab" data-bs-toggle="tab" data-bs-target="#nav-{{$premiumCnumber->id}}" type="button" role="tab" aria-controls="nav-{{$premiumCnumber->id}}" aria-selected="true">{{$premiumCnumber->name}}</button>
               @endforeach
            </div>
         </nav>
        <div class="tab-content" id="nav-tabContent">
           @foreach ($premiumCnumbers as $premiumCnumber)
           <div class="tab-pane {{ $premiumCnumbers[0]->id == $premiumCnumber->id ? 'show active' : '' }}" id="nav-{{$premiumCnumber->id}}" role="tabpanel" aria-labelledby="nav-one-tab">
               <div class="row d-flex justify-content-center text-center">
                  @foreach ($premiumCnumber->products as $product)
                  <div class="col-lg-3 col-md-4 col-sm-6">
                     <div class="product-item {{$product->hot == 1 ? 'product_hot' : ''}} animate__animated animate__fadeIn">
                        @if($product->hot == 1)<span class="hot">POPULAR</span>@endif
                        <h2 class="period">{{$product->period}}</h2>
                        @if( $standardCnumbers )<h2 class="server_type">{{$product->cnumber->category->name}}</h2>@endif
                        <div class="product_price">
                           <span class="price">{{$product->price}}</span>
                           <span class="currency">{{$currency->code}}</span>
                           <span class="old_price">{{number_format($product->price*100/60, 2).''.$currency->symbol}}</span>
                        </div>
                        <ul class="server_infos">
                           <li class="conn_number"><i class="fa fa-check-circle-o"></i>{{$premiumCnumber->name}}</li>
                           @if( $product->monthly )
                           <li><i class="fa fa-check"></i>Only <span class="monthly">{{ $product->monthly.$currency->symbol }}</span> a Month</li>
                           @else
                           <li><i class="fa fa-check"></i>No Activation Fees</li>
                           @endif
                           <li><i class="fa fa-check"></i>+22.4k Channels</li>
                           <li><i class="fa fa-check"></i>+125k Movies <br><span style="color: #edf905">( ~ 23k English Movies )</span></li>
                           <li><i class="fa fa-check"></i>+24k Series <br><span style="color: #edf905">( ~ 6k English Series )</span></li>
                           <li><i class="fa fa-check"></i>CATCH UP | EPG</li>
                           <li><i class="fa fa-check"></i>8k, 4K, Ultra HD and HQ</li>
                           <li><i class="fa fa-check"></i>Anti Freeze System</li>
                           <li><i class="fa fa-check"></i>MAG & Firestick</li>
                           <li><i class="fa fa-check"></i>Smarter & Tvmate APP</li>
                           <li><i class="fa fa-check"></i>Free Support 24/7</li>
                        </ul>
                        <form action="{{route('cart.store')}}" method="POST">
                           @csrf
                           <input type="hidden" name="id" value="{{$product->id}}">
                           @if( $product->in_stock == 1 )
                           <button type="submit" class="order_now_product" href="#">Order Now</button>
                            @else
                            <button disabled class="order_now_product btn btn-disabled" href="#">Not Available</button>
                            @endif
                        </form>
                     </div>
                  </div>
                  @endforeach
               </div>
            </div>
           @endforeach
           <div class="more_than4">
            <h2>You want more than {{$lastPremiumCnumber}} connections ?</h2>
            <a class="reach_us" target="_blank" href="{{route('wtsp').'?text=Hi, I am interesting in more than '.$lastPremiumCnumber.' connections plans  [ Premium Server ].'}}">
                <i class="fa fa-whatsapp"></i>
                Send WhatsApp MESSAGE
            </a>
        </div>
        </div>
    </div>
</div>
@endif


@if( \App\Models\Config::whereName('reseller')->first()->value == 1 )
<div id="reseller" class="dark_background text-center">
    <h2>Start Your Business Now & Unlock More Features</h2>
    <h3>What will i get as a reseller ?</h3>
    <ul>
        <li><i class="fa fa-check-circle"></i> A Secure Panel With Username && Password.</li>
        <li><i class="fa fa-check-circle"></i> Credits To Generate Your Clients' Subscriptions</li>
        <li><i class="fa fa-check-circle"></i> CHAT SUPPORT ( 24/24 )</li>
    </ul>
    <a class="reach_us" target="_blank" href="{{route('wtsp')}}?text=Hi, I would like to be a reseller, more infos please.">
        <i class="fa fa-whatsapp"></i>
        Get Your Reselling Plan Now
    </a>
</div>
@endif


@if ( \App\Models\Config::whereName('homepage_testimonialsEnabled')->first()->value == 1 )
<div id="testimonials">
    <h2>our clients <i class="fa fa-heart"></i></h2>
    <p></p>
    <div class="container">
        <div class="wtsp_screens owl-carousel owl-theme">
            <div class="item"><img width="290" height="569" alt="testimonials whatsapp screenshot" src="{{asset('images/wtsp/1.webp')}}"></div>
            <div class="item"><img width="290" height="569" alt="testimonials whatsapp screenshot" src="{{asset('images/wtsp/2.webp')}}"></div>
            <div class="item"><img width="290" height="569" alt="testimonials whatsapp screenshot" src="{{asset('images/wtsp/4.webp')}}"></div>
            <div class="item"><img width="290" height="569" alt="testimonials whatsapp screenshot" src="{{asset('images/wtsp/5.webp')}}"></div>
            <div class="item"><img width="290" height="569" alt="testimonials whatsapp screenshot" src="{{asset('images/wtsp/6.webp')}}"></div>
            <div class="item"><img width="290" height="569" alt="testimonials whatsapp screenshot" src="{{asset('images/wtsp/8.webp')}}"></div>
        </div>
    </div>
</div>
@endif
<div class="faq_home">
    <h2>You Have More Questions ?</h2>
    <a href="{{route('faq')}}"><i class="fa fa-question-circle-o"></i> Check Our FAQ Page</a>
</div>
@if ( \App\Models\Config::whereName('homepage_newsEnabled')->first()->value == 1 )
<div class="post-section news_section text-center dark_background">
    <div class="col-md-12">
        <div class="content">
            <h2>Stay Ahead of the Game with IPTV's Top<span class="colored"> News Channels</span></h2>
            <p class="col-md-10">Never miss a beat with IPTV's collection of the most popular news channels. Stay informed on the latest developments with 24/7 access to top networks, including CNN, Fox News, and BBC News. With a range of local and international news sources, you can stay up-to-date on the stories that matter most to you. Stay ahead of the game with IPTV's top news channels.</p>
            <ul class="gallery col-md-10">
                <li><img width="63" height="30" src="{{asset('images/channels/cnn.webp')}}" alt="cnn"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/espn.webp')}}" alt="espn"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/fox.webp')}}" alt="fox"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/abc.webp')}}" alt="abc"></li>
                <li><img width="63" height="30" src="{{asset('images/channels/nbc.webp')}}" alt="nbc"></li>
            </ul>
        </div>
    </div>
</div>
@endif
@if ( \App\Models\Config::whereName('homepage_showDevices')->first()->value == 1 )
<div id="devices_list">
    <h2>our iptv working on all devices and apps</h2>
    <ul class="devices col-md-11">
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/duplex.webp')}}" alt="duplex player iptv">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/room_iptv.webp')}}" alt="room iptv">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/ibo_player.webp')}}" alt="ibo player iptv">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/smarters.webp')}}" alt="iptv smarters pro">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/gse_smart_iptv.webp')}}" alt="gse smart iptv app">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/smart_one.webp')}}" alt="smartone iptv">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/net_iptv.webp')}}" alt="net iptv">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/set_iptv.webp')}}" alt="set iptv">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/IPTV_Extreme_Pro.webp')}}" alt="IPTV Extreme Pro iptv">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/mi_box.webp')}}" alt="mi box iptv">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/tivimate.webp')}}" alt="tivimate app iptv">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/android_white.webp')}}" alt="android iptv">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/dreambox_white.webp')}}" alt="dreambox iptv">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/dreamlink_white.webp')}}" alt="dreamlink iptv">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/enigma2_white.webp')}}" alt="enigma2 iptv">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/firestick_white.webp')}}" alt="firestick iptv">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/formuler_z8_white.webp')}}" alt="formuler z8 iptv">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/mac_os_white.webp')}}" alt="mac os iptv">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/magbox_white.webp')}}" alt="magbox iptv">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/smart_stb_white.webp')}}" alt="smart stb iptv">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/smart_tv_white.webp')}}" alt="smart tv iptv">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/windows_white.webp')}}" alt="windows iptv">
        </li>
        <li class="item">
            <img width="171" height="53" src="{{asset('images/devices/webp/smart_iptv_white.webp')}}" alt="smart iptv">
        </li>
    </ul>
</div>
@endif
@endsection
@section('extra_css')
<style>
.owl-carousel .owl-item img {
    height: auto!important;
}
</style>
@endsection