@extends('layouts.app')
@section('title', config('app.name').' - '.$title)
@section('description', $description)
@section('content')
<h1 class="blogg_title">{{$title}}</h1>
<div id="blogg">
    <div class="container">
    
        @if(count($posts) > 0)

        <div class="row">
            @foreach ($posts as $post)
            <div class="col-md-3 col-xs-6">
                <div class="blogg_post-item">
                    <a href="{{route('post', $post->slug)}}">
                        <img alt="{{$post->title}}" width="347" height="222" class="poster" src="{{asset('storage/'.$post->poster)}}" />
                    </a>
                    <h2><a href="{{route('post', $post->slug)}}">{{$post->title}}</a></h2>
                </div>
            </div>
            @endforeach
            {{ $posts->links() }}
        </div>
        
        @else
            <h1>No Posts.</h1>
        @endif
    </div>
</div>

@endsection
@section('extra_css')
<style>
h1.blogg_title {
    text-align: center;
    color: white;
    font-weight: 800;
    font-size: 42px;
    padding: 37px 18px;
}

div#blogg .blogg_post-item {
    background: #00000021;
    border-radius: 4px;
    padding: 0;
    margin: 16px 0;
    overflow: hidden;
}

div#blogg .blogg_post-item a img.poster {
    width: 100%;
    height: auto;
}

div#blogg .blogg_post-item h2 {
    display: inline-block;
    padding: 11px 14px;
    color: #ffffff !important;
    font-weight: 700;
    line-height: normal;
    font-size: 15px;
}

div#blogg .blogg_post-item h2 a {
    color: inherit
}

div#blogg .blogg_post-item h2:hover a {
    color: #ffc600!important;
    transition: 0.5s;
}
div#blogg .blogg_post-item a.read_more {
    background: #e91e63;
    color: white;
    font-weight: 600;
    font-size: 14px;
    padding: 4px 9px;
    display: inline-block;
    border-radius: 9px;
}

div#blogg .blogg_post-item a.read_more:hover {
    background: #c00041;
    transition: 0.3s;
}

div#blogg nav.mypagination {
    text-align: center;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 45px 0;
}

div#blogg nav.mypagination ul li.page-item a:hover {
    color: #fff000;
    transition: 0.3s;
}

div#blogg nav.mypagination .pagination {
    display: flex;
    align-items: center;
    justify-content: center;
}

div#blogg nav.mypagination ul li.page-item a {
    background: none;
    color: white;
    border: none;
    font-size: 16px;
    font-weight: 600;
    text-transform: capitalize;
    outline: none;
    box-shadow: none;
}

div#blogg nav.mypagination ul li.page-item.active span {
    background: #ffffff24;
    border-radius: 50%;
    width: 29px;
    border: none;
    height: 29px;
    padding: 2px 0;
    font-weight: 600;
    color: white;
    font-size: 16px;
}

div#blogg nav.mypagination ul li.page-item.disabled span, div#blogg nav.mypagination ul li.page-item a[rel="prev"], div#blogg nav.mypagination ul li.page-item a[rel="next"] {

}

li.page-item.disabled {
    display: none;
}


div#blogg nav.mypagination ul li.page-item a[rel="prev"], div#blogg nav.mypagination ul li.page-item a[rel="next"] {
    font-size: 16px
}



@media (max-width: 992px) {

    h1.blogg_title {
        font-size: 30px;
    }

    div#blogg .blogg_post-item h2 a {
        font-size: 16px;
    }
}




</style>
@endsection
@section('extra_js')
<script>

</script>
@endsection