@extends('layouts.adminapp')
@section('title', 'PayPal')
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
    <a href="{{route('admin.paypal_insert')}}" class="goback btn btn-danger"><i class="fa fa-plus"></i>Insert Paypal</a>
</div>
<div class="card card-default color-palette-box">
    <div class="card-body">
        <a href="{{route('admin.paypal_shuffled', $is_shuffled)}}" class="shuffled btn btn-{{ $is_shuffled == 1 ? 'success' : 'dark' }}">Shuffled</a>
        @if( $paypals->count() > 0 )
        <form action="{{ route('admin.paypal_update') }}" method="POST">
            @csrf
            @foreach ($paypals as $paypal)
            <div class="row">
                <input type="hidden" name="ids[]" value="{{$paypal->id}}">
                <div class="col-md-4 form-group">
                    <input type="text" class="form-control" id="email" name="emails[]" value="{{$paypal['email']}}" placeholder="Email">
                </div>
                <div class="col-md-6 form-group">
                    <input type="text" class="form-control" id="client_id" name="client_ids[]" value="{{$paypal['client_id']}}" placeholder="Client Id">
                </div>
                <div class="col-md-2">
                    <div class="actions-pay">
                        <a href="{{route('admin.paypal_status', $paypal->id)}}" class="badge bg-{{$paypal['active'] == 1 ? 'success' : 'dark'}}">
                            {{$paypal['active'] == 1 ? 'Active' : 'Not Active'}}
                        </a>
                        <a href="{{route('admin.paypal_delete', $paypal->id)}}" class="badge bg-danger"><i class="fa fa-trash"></i></a>
                    </div>
                </div>
            </div>
            @endforeach
            <button type="submit" class="btn btn-primary">UPDATE</button>
        </form>
        @else
        <h4>You Have No Paypal Accounts</h4>
        @endif
   </div>
 </div>
@endsection
@section('extra_css')
<style>
    button.btn.btn-primary {
        padding: 5px 14px;
    }

    span.badge {
        margin: 15px 0s
    }

    a.badge.bg-danger {
        color: white;
    }

    span.badge.bg-success, a.badge.bg-success {
        margin: 13px 0;
    }

    div.actions-pay a.badge.bg-success {
    padding: 2px 6px;
}
</style>
@endsection
@section('extra_js')

@endsection
