@extends('layouts.adminapp')
@section('title', 'Blog Categories')
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
  <a href="{{route('admin.blog_category_insert')}}" class="goback btn btn-danger"><i class="fa fa-plus"></i>Insert Blog Category</a>
</div>
<div class="card card-default color-palette-box">
    @if( session()->has('success') )
    <span class="badge bg-success"> {{session()->get('success')}} </span>
    @endif
    <div class="card-body">
        @if (count($blog_categories) > 0)
        <form method="POST" action="{{route('admin.blog_categories_update')}}">
            @csrf
            <table class="table">
                <thead>
                    <tr>
                        <th scope="col"></th>
                        <th scope="col">Name</th>
                        <th scope="col">slug</th>
                        <th scope="col"></th>
                    </tr>
                </thead>
                <tbody>
                @foreach($blog_categories as $category)
                <tr class="product-table">
                    <td>#{{$category->id}}<input type="hidden" name="id[]" value="{{$category->id}}"></td>
                    <td><input class="form-control" type="text" name="name[]" value="{{$category->name}}"></td>
                    <td><input class="form-control" type="text" name="slug[]" value="{{$category->slug}}"></td>
                </tr>
                @endforeach
                </tbody>
            </table>
            <button class="btn btn-primary">Update</button>
        <form>
        @else
       <h3>No Blog Categories</h3>
       @endif
    </div>
 </div>
@endsection
@section('extra_js')
<script>
  $(document).ready(() => {
      $('span.badge.bg-success').delay(3000).fadeOut()
  })
</script>
@endsection
@section('extra_css')
    <style>
  
    </style>
@endsection