<?php

namespace Database\Seeders;

use App\Models\Canal;
use App\Models\Category;
use App\Models\Country;
use Illuminate\Database\Seeder;

class TrexSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $myCatId = Category::where('name', 'LIKE', '%premium%')->first()->id;
        $apiUrl = "http://137.184.170.22:3000/trex/";
        $json = file_get_contents($apiUrl.'categories');
        $categories = json_decode($json);
        foreach($categories as $category) {
            $isCountryExists = Country::whereName($category->name)->whereCategoryId($myCatId)->first();
            if( !$isCountryExists ) {
                $country = Country::create([ 'name' => $category->name, 'category_id' => $myCatId ]);
                $apiCategory = file_get_contents($apiUrl.'category/'.base64_encode($category->url));
                $jsonCategory = json_decode($apiCategory);
                foreach($jsonCategory as $channel) {
                    Canal::create([
                        'country_id' => $country->id,
                        'name' => $channel
                    ]);
                }
            }else {
                if( $isCountryExists->channels->count() == 0 ) {
                    $apiCategory = file_get_contents($apiUrl.'category/'.base64_encode($category->url));
                    $jsonCategory = json_decode($apiCategory);
                    foreach($jsonCategory as $channel) {
                        Canal::create([
                            'country_id' => $isCountryExists->id,
                            'name' => $channel
                        ]);
                    }
                }
            }
        }
    }
}
