<?php

namespace Database\Seeders;

use App\Models\Product;
use Illuminate\Database\Seeder;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         ***************************************************************************************
         * STANDARD SERVER *
         ***************************************************************************************
        */
        /**
         * FOR 1 CONNECTION;
        */
        Product::create([
            'cnumber_id' => 1,
            'title' => 'IPTV 1 Month Subscription',
            'short_title' => 'IPTV 1 Month',
            'period' => '1 Month',
            'price' => 11.99,
            'old_price' => 18.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 1,
            'title' => 'IPTV 3 Months Subscription',
            'short_title' => 'IPTV 3 Months',
            'period' => '3 Months',
            'price' => 19.99,
            'old_price' => 28.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 1,
            'title' => 'IPTV 6 Months Subscription',
            'short_title' => 'IPTV 6 Months',
            'period' => '6 Months',
            'price' => 32.99,
            'old_price' => 41.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 1,
            'title' => 'IPTV 12 Months ( 1 YEAR ) Subscription',
            'short_title' => 'IPTV 12 Months',
            'period' => '12 Months',
            'price' => 49.99,
            'old_price' => 60.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => true,
        ]);
        Product::create([
            'cnumber_id' => 1,
            'title' => 'IPTV 24 Months ( 2 YEARS ) Subscription',
            'short_title' => 'IPTV 24 Months',
            'period' => '24 Months',
            'price' => 89.99,
            'old_price' => 105.99,
            'visibility' => false,
            'in_stock' => true,
            'hot' => false,
        ]);
        /**
         * FOR 2 CONNECTIONS;
        */
        Product::create([
            'cnumber_id' => 2,
            'title' => 'IPTV 1 Month Subscription [ 2 connections ]',
            'short_title' => 'IPTV 1 Month [ 2 connections ]',
            'period' => '1 Month',
            'price' => 19.99,
            'old_price' => 21.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 2,
            'title' => 'IPTV 3 Months Subscription [ 2 connections ]',
            'short_title' => 'IPTV 3 Months [ 2 connections ]',
            'period' => '3 Months',
            'price' => 33.99,
            'old_price' => 41.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 2,
            'title' => 'IPTV 6 Months Subscription [ 2 connections ]',
            'short_title' => 'IPTV 6 Months [ 2 connections ]',
            'period' => '6 Months',
            'price' => 55.99,
            'old_price' => 63.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 2,
            'title' => 'IPTV 12 Months Subscription [ 2 connections ]',
            'short_title' => 'IPTV 12 Months [ 2 connections ]',
            'period' => '12 Months',
            'price' => 84.99,
            'old_price' => 95.99,
            'visibility' => false,
            'in_stock' => true,
            'hot' => true,
        ]);
        Product::create([
            'cnumber_id' => 2,
            'title' => 'IPTV 24 Months Subscription [ 2 connections ]',
            'short_title' => 'IPTV 24 Months [ 2 connections ]',
            'period' => '12 Months',
            'price' => 169.99,
            'old_price' => 199.96,
            'visibility' => false,
            'in_stock' => true,
            'hot' => false,
        ]);
        /**
         * FOR 3 CONNECTIONS;
        */
        Product::create([
            'cnumber_id' => 3,
            'title' => 'IPTV 1 Month Subscription [ 3 connections ]',
            'short_title' => 'IPTV 1 Month [ 3 connections ]',
            'period' => '1 Month',
            'price' => 30.99,
            'old_price' => 32.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 3,
            'title' => 'IPTV 3 Months Subscription [ 3 connections ]',
            'short_title' => 'IPTV 3 Months [ 3 connections ]',
            'period' => '3 Months',
            'price' => 52.99,
            'old_price' => 59.99,
            'visibility' => false,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 3,
            'title' => 'IPTV 6 Months Subscription [ 3 connections ]',
            'short_title' => 'IPTV 6 Months [ 3 connections ]',
            'period' => '6 Months',
            'price' => 84.99,
            'old_price' => 93.99,
            'visibility' => false,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 3,
            'title' => 'IPTV 12 Months Subscription [ 3 connections ]',
            'short_title' => 'IPTV 12 Months [ 3 connections ]',
            'period' => '12 Months',
            'price' => 127.99,
            'old_price' => 134.99,
            'visibility' => false,
            'in_stock' => true,
            'hot' => true,
        ]);
        Product::create([
            'cnumber_id' => 3,
            'title' => 'IPTV 24 Months Subscription [ 3 connections ]',
            'short_title' => 'IPTV 24 Months [ 3 connections ]',
            'period' => '24 Months',
            'price' => 240.99,
            'old_price' => 260.99,
            'visibility' => false,
            'in_stock' => true,
            'hot' => false,
        ]);
        /**
         * FOR 4 CONNECTIONS;
        */
        Product::create([
            'cnumber_id' => 4,
            'title' => 'IPTV 1 Month Subscription [ 4 Connections ]',
            'short_title' => 'IPTV 1 Month [ 4 Connections ]',
            'period' => '1 Month',
            'price' => 40.99,
            'old_price' => 41.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 4,
            'title' => 'IPTV 3 Months Subscription [ 4 Connections ]',
            'short_title' => 'IPTV 3 Months [ 4 Connections ]',
            'period' => '3 Months',
            'price' => 67.99,
            'old_price' => 76.56,
            'visibility' => false,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 4,
            'title' => 'IPTV 6 Months Subscription [ 4 Connections ]',
            'short_title' => 'IPTV 6 Months [ 4 Connections ]',
            'period' => '6 Months',
            'price' => 111.99,
            'old_price' => 121.99,
            'visibility' => false,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 4,
            'title' => 'IPTV 12 Months Subscription [ 4 Connections ]',
            'short_title' => 'IPTV 12 Months [ 4 Connections ]',
            'period' => '12 Months',
            'price' => 169.99,
            'old_price' => 178.99,
            'visibility' => false,
            'in_stock' => true,
            'hot' => true,
        ]);
        Product::create([
            'cnumber_id' => 4,
            'title' => 'IPTV 24 Months Subscription [ 4 Connections ]',
            'short_title' => 'IPTV 24 Months [ 4 Connections ]',
            'period' => '24 Months',
            'price' => 329.98,
            'old_price' => 349.99,
            'visibility' => false,
            'in_stock' => true,
            'hot' => false,
        ]);
        /**
         * FOR 5 CONNECTIONS;
        */
        Product::create([
            'cnumber_id' => 5,
            'title' => 'IPTV 1 Month Subscription [ 5 Connections ]',
            'short_title' => 'IPTV 1 Month [ 5 Connections ]',
            'period' => '1 Month',
            'price' => 55.99,
            'old_price' => 61.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 5,
            'title' => 'IPTV 3 Months Subscription [ 5 Connections ]',
            'short_title' => 'IPTV 3 Months [ 5 Connections ]',
            'period' => '3 Months',
            'price' =>  84.99,
            'old_price' => 94.99,
            'visibility' => false,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 5,
            'title' => 'IPTV 6 Months Subscription [ 5 Connections ]',
            'short_title' => 'IPTV 6 Months [ 5 Connections ]',
            'period' => '6 Months',
            'price' => 140.99,
            'old_price' => 149.99,
            'visibility' => false,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 5,
            'title' => 'IPTV 12 Months Subscription [ 5 Connections ]',
            'short_title' => 'IPTV 12 Months [ 5 Connections ]',
            'period' => '12 Months',
            'price' => 212.99,
            'old_price' => 223.99,
            'visibility' => false,
            'in_stock' => true,
            'hot' => true,
        ]);
        Product::create([
            'cnumber_id' => 5,
            'title' => 'IPTV 24 Months Subscription [ 5 Connections ]',
            'short_title' => 'IPTV 24 Months [ 5 Connections ]',
            'period' => '24 Months',
            'price' => 415.99,
            'old_price' => 223.99,
            'visibility' => false,
            'in_stock' => true,
            'hot' => false,
        ]);

        /**
         ***************************************************************************************
         * PREMIUM SERVER *
         ***************************************************************************************
        */
        /**
         * FOR 1 CONNECTION ( PREMIUM );
        */
        Product::create([
            'cnumber_id' => 6,
            'title' => 'IPTV Premium Quality 1 Month Subscription',
            'short_title' => 'IPTV Premium 1 Month',
            'period' => '1 Month',
            'price' => 17.99,
            'old_price' => 28.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 6,
            'title' => 'IPTV Premium Quality 3 Months Subscription',
            'short_title' => 'IPTV Premium 3 Months Premium',
            'period' => '3 Months',
            'price' => 26.99,
            'old_price' => 37.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 6,
            'title' => 'IPTV Premium Quality 6 Months Subscription',
            'short_title' => 'IPTV Premium 6 Months',
            'period' => '6 Months',
            'price' => 41.99,
            'old_price' => 52.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 6,
            'title' => 'IPTV Premium Quality 12 Months ( 1 YEAR ) Subscription',
            'short_title' => 'IPTV Premium 12 Months',
            'period' => '12 Months',
            'price' => 65.99,
            'old_price' => 76.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => true,
        ]);
        /**
         * FOR 2 CONNECTIONS ( PREMIUM );
        */
        Product::create([
            'cnumber_id' => 7,
            'title' => 'IPTV Premium Quality 1 Month Subscription',
            'short_title' => 'IPTV Premium 1 Month [ 2 connections ]',
            'period' => '1 Month',
            'price' => 30.99,
            'old_price' => 41.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 7,
            'title' => 'IPTV Premium Quality 3 Months Subscription',
            'short_title' => 'IPTV Premium 3 Months Premium [ 2 connections ]',
            'period' => '3 Months',
            'price' => 45.99,
            'old_price' => 56.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 7,
            'title' => 'IPTV Premium Quality 6 Months Subscription',
            'short_title' => 'IPTV Premium 6 Months [ 2 connections ]',
            'period' => '6 Months',
            'price' => 71.99,
            'old_price' => 82.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 7,
            'title' => 'IPTV Premium Quality 12 Months ( 1 YEAR ) Subscription',
            'short_title' => 'IPTV Premium 12 Months [ 2 connections ]',
            'period' => '12 Months',
            'price' => 112.18,
            'old_price' => 123.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => true,
        ]);
        /**
         * FOR 3 CONNECTIONS ( PREMIUM );
        */
        Product::create([
            'cnumber_id' => 8,
            'title' => 'IPTV Premium Quality 1 Month Subscription',
            'short_title' => 'IPTV Premium 1 Month [ 3 connections ]',
            'period' => '1 Month',
            'price' => 45.99,
            'old_price' => 56.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 8,
            'title' => 'IPTV Premium Quality 3 Months Subscription',
            'short_title' => 'IPTV Premium 3 Months Premium [ 3 connections ]',
            'period' => '3 Months',
            'price' => 68.99,
            'old_price' => 79.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 8,
            'title' => 'IPTV Premium Quality 6 Months Subscription',
            'short_title' => 'IPTV Premium 6 Months [ 3 connections ]',
            'period' => '6 Months',
            'price' => 107.99,
            'old_price' => 118.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 8,
            'title' => 'IPTV Premium Quality 12 Months ( 1 YEAR ) Subscription',
            'short_title' => 'IPTV Premium 12 Months [ 3 connections ]',
            'period' => '12 Months',
            'price' => 168.18,
            'old_price' => 179.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => true,
        ]);

        /**
         * FOR 4 CONNECTIONS ( PREMIUM );
        */
        Product::create([
            'cnumber_id' => 9,
            'title' => 'IPTV Premium Quality 1 Month Subscription',
            'short_title' => 'IPTV Premium 1 Month [ 4 Connections ]',
            'period' => '1 Month',
            'price' => 61.99,
            'old_price' => 72.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 9,
            'title' => 'IPTV Premium Quality 3 Months Subscription',
            'short_title' => 'IPTV Premium 3 Months Premium [ 4 Connections ]',
            'period' => '3 Months',
            'price' => 91.99,
            'old_price' => 102.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 9,
            'title' => 'IPTV Premium Quality 6 Months Subscription',
            'short_title' => 'IPTV Premium 6 Months [ 4 Connections ]',
            'period' => '6 Months',
            'price' => 142.99,
            'old_price' => 153.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);
        Product::create([
            'cnumber_id' => 9,
            'title' => 'IPTV Premium Quality 12 Months ( 1 YEAR ) Subscription',
            'short_title' => 'IPTV Premium 12 Months [ 4 Connections ]',
            'period' => '12 Months',
            'price' => 224.99,
            'old_price' => 235.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => true,
        ]);


    }
}
