<?php

namespace Database\Seeders;

use App\Models\Order;
use Carbon\Carbon;
use Faker\Factory;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class OrderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('orders')->truncate();
        $faker = Factory::create();

        for( $i = 0; $i < 34; $i++ ) {
            Order::create([
                'uuid' => uniqid(),
                'product_id' => rand(1, 4),
                'customer_id' => $faker->swiftBicNumber,
                'transaction_id' => $faker->creditCardNumber,
                'billing_email' => $faker->email,
                'billing_name' => $faker->name,
                'ppl_email' => $faker->email,
                'total' => rand(11, 200),
                'subtotal' => rand(11, 200),
                'paid' => true,
                'payment_date' => Carbon::now(),
                // 'activation_date' => Carbon::now()->subMinutes(20),
                // 'updated_at' => Carbon::now()->subMinutes(20),
            ]);
        }

    }
}
