<?php

namespace Database\Seeders;

use App\Models\Canal;
use App\Models\Category;
use App\Models\Country;
use Illuminate\Database\Seeder;

class DinoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $myCatId = Category::where('name', 'LIKE', '%standard%')->first()->id;
        $apiUrl = "http://localhost:3000/dino/";
        $json = file_get_contents($apiUrl.'categories_channels');
        $categories = json_decode($json);
        foreach($categories as $category) {
            $this->command->info("".$category->category_name." --> Created");
            $isCountryExists = Country::whereName($category->category_name)->whereCategoryId($myCatId)->first();
            if( !$isCountryExists ) {
                $country = Country::create([ 'name' => $category->category_name, 'category_id' => $myCatId ]);
                $apiCategory = file_get_contents($apiUrl.'category_channel/'.$category->category_id);
                $jsonCategory = json_decode($apiCategory);
                foreach($jsonCategory as $channel) {
                    Canal::create([
                        'country_id' => $country->id,
                        'name' => $channel
                    ]);
                }
            }else {
                if( $isCountryExists->channels->count() == 0 ) {
                    $apiCategory = file_get_contents($apiUrl.'category_channel/'.$category->category_id);
                    $jsonCategory = json_decode($apiCategory);
                    foreach($jsonCategory as $channel) {
                        Canal::create([
                            'country_id' => $isCountryExists->id,
                            'name' => $channel
                        ]);
                    }
                }
            }
        }
    }
}
