<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string('uuid')->unique();
            $table->integer('currency_id');
            $table->integer('product_id');
            $table->string('customer_id')->nullable();
            $table->string('transaction_id')->nullable();
            $table->string('ppl_firstName')->nullable();
            $table->string('ppl_lastName')->nullable();
            $table->string('ppl_email')->nullable();
            $table->string('ppl_country')->nullable();
            $table->string('ppl_account')->nullable();
            $table->string('billing_email');
            $table->string('billing_name');
            $table->string('gateway')->nullable();
            $table->string('total');
            $table->string('subtotal');            
            $table->text('notes')->nullable();

            $table->boolean('renewing')->default(0);

            $table->text('phone_number')->nullable();
            $table->text('countries')->nullable();
            $table->text('languages')->nullable();

            $table->text('extra_header')->nullable();
            $table->text('extra_footer')->nullable();
            $table->boolean('vod')->default(false);
            $table->float('vod_price')->default(0);
            $table->boolean('adult')->default(false);
            $table->float('adult_price')->default(0);
            $table->boolean('fastdelivery')->default(false);
            $table->float('fastdelivery_price')->default(0);
            $table->boolean('paid');
            $table->boolean('sent')->default(false);
            $table->boolean('refunded')->default(false);
            $table->timestamp('payment_date')->nullable();
            $table->timestamps();
        });
    }    
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
