<?php

namespace App\Jobs;

use App\Models\Config;
use App\Models\Currency;
use App\Models\Order;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Http;

class NewInvoiceJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */

    protected $order_id;

    public function __construct($order_id)
    {
	$this->order_id = $order_id;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $order = Order::whereId($this->order_id)->first();
        $currency_id = Config::whereName('currency')->first()->value;
        $currency = Currency::whereId($currency_id)->first();
        $app_notifications = Config::whereName('app_notifications')->first()->value;
        if($app_notifications) {
            Http::withoutVerifying()
            ->withHeaders([
                'Authorization' => 'Key '.Config::whereName('oneSignalRestApiKey')->first()->value,
                'Content-Type'  => 'application/json',
	        'accept'        => 'application/json'
            ])->post('https://api.onesignal.com/notifications?c=push', [
                "app_id" => Config::whereName('oneSignalAppId')->first()->value,
                "contents" => [
                    "en" => "[".config('app.name')."]::New_Invoice"
                ],
                "headings"=> [
                    "en" => $order->total.' '.$currency->code
                ],
                "included_segments" => ["Total Subscriptions"],
                'android_channel_id' => 'a9247a65-f37a-4eb3-bc19-59658a79881d'
            ]);
        }
    }
}
