<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Config;
use App\Models\Currency;
use App\Models\Product;
use App\Models\Subtype;
use Illuminate\Http\Request;
use Gloudemans\Shoppingcart\Facades\Cart;

class CartController extends Controller
{
    public function show(Request $request) {
        // Add To Cart;
        if( $request->id ) {
            Cart::destroy();
            $product = Product::whereId($request->id)->firstOrFail();
            Cart::add($product->id, $product->period, 1, $product->price)->associate($product);
            // return redirect()->route('cart')->with('success', 'Added To Cart Successfully!');
        }
        if (count(Cart::content()) == 0) return redirect()->route('subscriptions');
        $items = Cart::content();
        foreach ( $items as $item ) {
            $stored_name = $item->options->name;
            $stored_email = $item->options->email;
            $stored_renewing = $item->options->renewing;
            $stored_phone_number = $item->options->phone_number;
            $stored_countries = $item->options->countries;
            $stored_languages = $item->options->languages;
            $stored_connections = $item->options->connections;
            $stored_vod = $item->options->vod;
            $stored_adult = $item->options->adult;
            $stored_fastdelivery = $item->options->fastdelivery;
            $stored_notes = $item->options->notes;
            
        }
        
        $subtypes = Subtype::select(['id', 'title'])->get();
        $vod_enabled = Config::whereName('vod_enabled')->first()->value;
        $vod_price = Config::whereName('vod_price')->first()->value;
        $adult_enabled = Config::whereName('adult_enabled')->first()->value;
        $adult_price = Config::whereName('adult_price')->first()->value;
        $fastdelivery_enabled = Config::whereName('fastdelivery_enabled')->first()->value;
        $fastdelivery_price = Config::whereName('fastdelivery_price')->first()->value;
        $currency_id = Config::whereName('currency')->first()->value;
        $currency = Currency::whereId($currency_id)->first();

        $isStandardActive = Category::where('name', 'standard')->first()->active;
        $isPremiumActive = Category::where('name', 'premium')->first()->active;
        $showCategory = $isPremiumActive & $isStandardActive ;

        return view('configure')->with(compact(
            'items',
            'subtypes',
            'vod_enabled', 'vod_price',
            'adult_enabled', 'adult_price',
            'fastdelivery_enabled', 'fastdelivery_price',
            'showCategory',
            'stored_name', 'stored_email', 'stored_renewing', 'stored_phone_number', 'stored_countries', 'stored_languages', 'stored_connections', 'stored_vod', 'stored_adult', 'stored_fastdelivery', 'stored_notes', 'currency'
        ));
    }

    public function store(Request $request) {
        Cart::destroy();
        $product = Product::whereId($request->id)->firstOrFail();
        Cart::add($product->id, $product->period, 1, $product->price)->associate($product);
        return redirect()->route('cart')->with('success', 'Added To Cart Successfully!');
    }

    public function destroy() {
        Cart::destroy();
        return view('cart')->with('products', []);
    }
}