<?php $__env->startSection('title', 'Edit Post'); ?>
<?php $__env->startSection('extra_css'); ?>
<link href="https://cdn.jsdelivr.net/npm/summernote@0.9.0/dist/summernote.min.css" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
    <a href="<?php echo e(route('admin.posts')); ?>" class="goback btn btn-danger"><i class="fa fa-arrow-left"></i>Go Back</a>
 </div>
<div class="card card-default color-palette-box admin_product">
    <div class="card-body">
        <form action="<?php echo e(route('admin.post_update')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="id" value="<?php echo e($post->id); ?>">
            <div class="row">
                <div class="mb-3 col-md-12">
                    <label for="title" class="form-label">Title</label>
                    <input type="text" name="title" class="form-control" placeholder="Title" id="title" value="<?php echo e($post->title); ?>">
                </div>
                <div class="mb-3 col-md-12">
                    <label for="slug" class="form-label">Slug</label>
                    <input type="text" name="slug" class="form-control" placeholder="slug" id="slug" value="<?php echo e($post->slug); ?>">
                </div>
            </div>
            <div class="row">
                <div class="mb-3 col-md-6">
                    <label for="shorttitle" class="form-label">Short Title</label>
                    <input type="text" name="shorttitle" class="form-control" placeholder="shorttitle" id="shorttitle" value="<?php echo e($post->shorttitle); ?>">
                </div>
                <div class="col-md-3 select">
                    <label for="howto" class="form-label">How to ?</label>
                    <select name="howto">
                        <option value="1" <?php echo e($post->howto == '1' ? 'selected' : ''); ?>>YES</option>
                        <option value="0" <?php echo e($post->howto == '0' ? 'selected' : ''); ?>>NO</option>
                    </select>
                </div>
                <div class="col-md-3 select">
                    <label for="visibility" class="form-label">Visible</label>
                    <select name="visibility">
                        <option value="1" <?php echo e($post->visibility == '1' ? 'selected' : ''); ?>>YES</option>
                        <option value="0" <?php echo e($post->visibility == '0' ? 'selected' : ''); ?>>NO</option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3 mb-3">
                    <label for="icon" class="form-label">Icon</label>
                    <input type="file" class="form-file-input form-control" name="icon" id="icon">
                </div>
                <div class="col-md-3 mb-3">
                    <label for="poster" class="form-label">Poster</label>
                    <input type="file" class="form-file-input form-control" name="poster" id="poster">
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <textarea rows="60" class="ckeditor form-control" name="content"><?php echo e($post->content); ?></textarea>
                </div>
            </div>
            <div class="mb-3">
                <button class="btn btn-primary" type="submit">UPDATE</button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.9.0/dist/summernote.min.js"></script>
<script type="text/javascript">
    $(document).ready(function () {
        $('.ckeditor').summernote({
            height: 900
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.adminapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/ipsubtv.com/resources/views/admin/post_edit.blade.php ENDPATH**/ ?>