<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" xmlns="http://www.w3.org/1999/xhtml" itemscope itemtype="http://schema.org/WebPage">
    <head>
        <link rel="shortcut icon" href="<?php echo e(asset('storage/'.\App\Models\Config::whereName('favicon')->first()->value)); ?>">
        <?php echo $__env->make('partials.meta', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        



        <?php
        $host = parse_url(env('APP_URL'))['host'];
        $logo = asset('storage/'.\App\Models\Config::whereName('white_logo')->first()->value);
        ?>
        
        <style>
           <?php if( env('APP_ENV') == 'production' ): ?>
           <?php echo $__env->make('layouts.inc.css.app_min', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
           <?php else: ?>
           <?php echo $__env->make('layouts.inc.css.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
           <?php endif; ?>
            body {
                background: #00229e;
                background: radial-gradient(circle, rgba(0, 34, 158, 1) 0%, rgba(5, 42, 153, 1) 50%, rgba(0, 21, 92, 1) 100%);
                background-attachment: fixed;
            }
        </style>
        <?php echo $__env->yieldContent('extra_css'); ?>
        <?php if( \App\Models\Config::whereName('gads_tracking_enabled')->first()->value == 1 ): ?>            
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(\App\Models\Config::whereName('gads_tracking_tag')->first()->value); ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            gtag('config', "<?php echo e(\App\Models\Config::whereName('gads_tracking_tag')->first()->value); ?>");
        </script>
        <?php endif; ?>

        <?php echo $__env->make('partials.seo-schema', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </head>
    <body>
        <noscript>You must have JavaScript enabled in order to use this order form. Please enable JavaScript and then reload this page in order to continue. </noscript>
        <span id="toTop">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#ffffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-arrow-up-icon lucide-arrow-up"><path d="m5 12 7-7 7 7"/><path d="M12 19V5"/></svg>    
        </span>
        <a id="whatsapp_button" href="<?php echo e(route('wtsp')); ?>" target="_blank">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="#ffffff" d="M19.05 4.91A9.82 9.82 0 0 0 12.04 2c-5.46 0-9.91 4.45-9.91 9.91c0 1.75.46 3.45 1.32 4.95L2.05 22l5.25-1.38c1.45.79 3.08 1.21 4.74 1.21c5.46 0 9.91-4.45 9.91-9.91c0-2.65-1.03-5.14-2.9-7.01m-7.01 15.24c-1.48 0-2.93-.4-4.2-1.15l-.3-.18l-3.12.82l.83-3.04l-.2-.31a8.26 8.26 0 0 1-1.26-4.38c0-4.54 3.7-8.24 8.24-8.24c2.2 0 4.27.86 5.82 2.42a8.18 8.18 0 0 1 2.41 5.83c.02 4.54-3.68 8.23-8.22 8.23m4.52-6.16c-.25-.12-1.47-.72-1.69-.81c-.23-.08-.39-.12-.56.12c-.17.25-.64.81-.78.97c-.14.17-.29.19-.54.06c-.25-.12-1.05-.39-1.99-1.23c-.74-.66-1.23-1.47-1.38-1.72c-.14-.25-.02-.38.11-.51c.11-.11.25-.29.37-.43s.17-.25.25-.41c.08-.17.04-.31-.02-.43s-.56-1.34-.76-1.84c-.2-.48-.41-.42-.56-.43h-.48c-.17 0-.43.06-.66.31c-.22.25-.86.85-.86 2.07s.89 2.4 1.01 2.56c.12.17 1.75 2.67 4.23 3.74c.59.26 1.05.41 1.41.52c.59.19 1.13.16 1.56.1c.48-.07 1.47-.6 1.67-1.18c.21-.58.21-1.07.14-1.18s-.22-.16-.47-.28"/></svg>
            <span> Chat With Us </span></a>
        <div id="header">
            <?php if( App\Models\Config::whereName('top_message_allowed')->first()->value == 1 ): ?>
            <div class="top-banner">
                <?php echo e(App\Models\Config::whereName('top_message')->first()->value); ?>

            </div>
            <?php endif; ?>
            <nav class="navbar navbar-expand-lg">
                <div class="container">
                    <a id="logo" class="nav-brand" href="<?php echo e(route('home')); ?>">
                        <img width="110" height="39" alt="<?php echo e(config('app.name').' - '.\App\Models\Config::whereName('website_description')->first()->value); ?>" src="<?php echo e($logo); ?>">
                    </a>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#ffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-menu-icon lucide-menu"><path d="M4 5h16"/><path d="M4 12h16"/><path d="M4 19h16"/></svg>
                    </span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav top-menu me-auto mb-2 mb-lg-0">
                            <?php
                            $current_route = Route::currentRouteName();
                            ?>
                            <li class="<?php echo e($current_route == 'subscriptions' ? 'active': ''); ?>">
                                <a class="nav-item hvr-underline-from-center" href="<?php echo e(route('subscriptions')); ?>">
                                    subscriptions
                                </a>
                            </li>
                            <li class="<?php echo e($current_route == 'blog' ? 'active': ''); ?>">
                                <a class="nav-item hvr-underline-from-center" href="<?php echo e(route('blog')); ?>">Blog</a>
                            </li>
                            <li><a class="nav-item hvr-underline-from-center" href="<?php echo e(route('blog_category', 'how-to-install')); ?>">how to install</a></li>
                            <li class="<?php echo e($current_route == 'channels_list' ? 'active': ''); ?>">
                                <a class="nav-item hvr-underline-from-center" href="<?php echo e(route('channels_list')); ?>">Channels List</a>
                            </li>
                            <li class="<?php echo e($current_route == 'faq' ? 'active': ''); ?>">
                                <a class="nav-item hvr-underline-from-center" href="<?php echo e(route('faq')); ?>">FAQ</a>
                            </li>
                            <li class="<?php echo e($current_route == 'contactus' ? 'active': ''); ?>"><a class="nav-item hvr-underline-from-center" href="<?php echo e(route('contactus')); ?>">Contact Us</a></li>
                            <?php
                            $reseller = \App\Models\Config::whereName('reseller')->first()->value
                            ?>
                            <?php if( $reseller == 1 ): ?>
                            <li><a class="nav-item hvr-underline-from-center" href="#reseller">RESELLER</a></li>
                            <?php endif; ?>
                        </ul>
                        <div class="top-right-menu">
                            <ul>
                                <?php if( App\Models\Config::whereName('trial_allowed')->first()->value == 1 ): ?>
                                <li>
                                    <div class="cta_btn">
                                        <a class="order_now_cta" href="<?php echo e(route('wtsp').'?text=Please I Wanna Try The Server Before I Buy For '.config('app.url')); ?>">FREE TRIAL</a>
                                     </div>
                                </li>
                                <?php else: ?>
                                <li>
                                    <div class="cta_btn">
                                        <a class="order_now_cta" href="<?php echo e(Route::currentRouteName() == 'home' ? '#subscribe' : route('subscriptions')); ?>"> Order Now </a>
                                     </div>
                                </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </nav>
        </div>
        <?php echo $__env->yieldContent('content'); ?>
        <footer>
            <div class="container">
                <div class="row top_s">
                    <div class="about_us col-md-4">
                        <a href="<?php echo e(route('home')); ?>">
                            <img width="90" height="39" alt="<?php echo e(\App\Models\Config::whereName('about_us')->first()->value); ?>" 
                            src="<?php echo e(asset('storage/'.\App\Models\Config::whereName('white_logo')->first()->value)); ?>">
                        </a>
                        <p><?php echo e(\App\Models\Config::whereName('about_us')->first()->value); ?></p>
                    </div>
                    <div class="col-md-4">
                        <div class="links">
                            <h3>Blog / Resources</h3>
                            <a href="<?php echo e(route('channels_list')); ?>" class="<?php echo e($current_route == 'channels_list' ? 'active': ''); ?>">channels list</a>
                            <a href="<?php echo e(route('subscriptions')); ?>" class="<?php echo e($current_route == 'subscriptions' ? 'active': ''); ?>">subscriptions</a>
                            <a href="<?php echo e(route('faq')); ?>" class="<?php echo e($current_route == 'faq' ? 'active': ''); ?>">Frequently Asked Questions</a>
                            <a href="<?php echo e(route('blog')); ?>" class="<?php echo e($current_route == 'blog' ? 'active': ''); ?>">blog</a>
                            <a href="<?php echo e(route('blog_category', 'how-to-install')); ?>">how to install</a>
                            <?php if( $reseller == 1 ): ?>
                            <a class="nav-item hvr-underline-from-center" href="#reseller">RESELLER</a>
                            <?php endif; ?>
                            <a href="<?php echo e(route('contactus')); ?>" class="<?php echo e($current_route == 'contactus' ? 'active': ''); ?>">contact us</a>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="links">
                            <h3>pages</h3>
                            <?php $__currentLoopData = \App\Models\LegalPage::whereVisibility(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('page', $page->slug)); ?>"><?php echo e($page->title); ?></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="_footer">
                <span>
                    All Rights Are Reserved To <span class="colored"><?php echo e(config('app.name')); ?></span> <i class="fa fa-copyright" aria-hidden="true"></i> <?php echo e(\Carbon\Carbon::now()->year); ?>

                </span>
                <img width="200" height="33" src="<?php echo e(asset('images/cards.webp')); ?>" alt="payment gateways">
            </div>
        </footer>
        <?php if( \App\Models\Config::whereName('gtag')->first()->value ): ?>
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(\App\Models\Config::whereName('gtag')->first()->value); ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());
            gtag('config', "<?php echo e(\App\Models\Config::whereName('gtag')->first()->value); ?>");
        </script>
        <?php endif; ?>
        <script>
        <?php if( env('APP_ENV') == 'production'): ?>
        <?php echo $__env->make('layouts.inc.js.app_min', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php else: ?>
        <?php echo $__env->make('layouts.inc.js.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        </script>
        <?php echo $__env->yieldContent('extra_js'); ?>
        
    </body>
</html><?php /**PATH /var/www/getsubtv.com/resources/views/layouts/app.blade.php ENDPATH**/ ?>