<?php if(Request::is('/')): ?>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Organization",
  "name": "<?php echo e(config('app.name')); ?>",
  "url": "<?php echo e(url('/')); ?>",
  "logo": "<?php echo e($logo); ?>",
  "sameAs": ["https://facebook.com/<?php echo e(config('app.name')); ?>", "https://x.com/<?php echo e(config('app.name')); ?>"]
}
</script>

<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "WebSite",
  "url": "<?php echo e(url('/')); ?>",
  "name": "<?php echo e(config('app.name')); ?> IPTV Service",
  "potentialAction": {
    "@type": "SearchAction",
    "target": "<?php echo e(url('/search?q={search_term_string}')); ?>",
    "query-input": "required name=search_term_string"
  }
}
</script>
<?php endif; ?>

<?php if(Request::is('plans') || Request::is('configure')): ?>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Service",
  "name": "<?php echo e(config('app.name')); ?> IPTV Plans",
  "serviceType": "IPTV Subscription",
  "areaServed": ["CA", "US"],
  "provider": {
    "@type": "Organization",
    "name": "<?php echo e(config('app.name')); ?>",
    "url": "<?php echo e(url('/')); ?>"
  },
  "offers": {
    "@type": "Offer",
    "priceCurrency": "USD",
    "price": "14.99",
    "url": "<?php echo e(url()->current()); ?>"
  }
}
</script>
<?php endif; ?>

<?php if(Request::is('blog/*')): ?>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BlogPosting",
  "headline": "<?php echo e($post->title ?? 'Blog Post'); ?>",
  "image": "<?php echo e(asset('storage/'.$post->poster) ?? asset('default-post-iptv.webp')); ?>",
  "author": {
    "@type": "Person",
    "name": "<?php echo e(config('app.name')); ?> Team"
  },
  "publisher": {
    "@type": "Organization",
    "name": "<?php echo e(config('app.name')); ?>",
    "logo": {
      "@type": "ImageObject",
      "url": "<?php echo e($logo); ?>"
    }
  },
  "datePublished": "<?php echo e($post->created_at ?? now()->toDateString()); ?>",
  "mainEntityOfPage": "<?php echo e(url()->current()); ?>"
}
</script>
<?php endif; ?><?php /**PATH /var/www/getsubtv.com/resources/views/partials/seo-schema.blade.php ENDPATH**/ ?>