<?php $__env->startSection('title', 'Blog Categories'); ?>
<?php $__env->startSection('content'); ?>
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
  <a href="<?php echo e(route('admin.blog_category_insert')); ?>" class="goback btn btn-danger"><i class="fa fa-plus"></i>Insert Blog Category</a>
</div>
<div class="card card-default color-palette-box">
    <?php if( session()->has('success') ): ?>
    <span class="badge bg-success"> <?php echo e(session()->get('success')); ?> </span>
    <?php endif; ?>
    <div class="card-body">
        <?php if(count($blog_categories) > 0): ?>
        <form method="POST" action="<?php echo e(route('admin.blog_categories_update')); ?>">
            <?php echo csrf_field(); ?>
            <table class="table">
                <thead>
                    <tr>
                        <th scope="col"></th>
                        <th scope="col">Name</th>
                        <th scope="col">slug</th>
                        <th scope="col"></th>
                    </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $blog_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="product-table">
                    <td>#<?php echo e($category->id); ?><input type="hidden" name="id[]" value="<?php echo e($category->id); ?>"></td>
                    <td><input class="form-control" type="text" name="name[]" value="<?php echo e($category->name); ?>"></td>
                    <td><input class="form-control" type="text" name="slug[]" value="<?php echo e($category->slug); ?>"></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <button class="btn btn-primary">Update</button>
        <form>
        <?php else: ?>
       <h3>No Blog Categories</h3>
       <?php endif; ?>
    </div>
 </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<script>
  $(document).ready(() => {
      $('span.badge.bg-success').delay(3000).fadeOut()
  })
</script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_css'); ?>
    <style>
  
    </style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.adminapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\ipsubtv.com\resources\views/admin/blog_categories.blade.php ENDPATH**/ ?>