<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\HomeController;
use App\Http\Middleware\VerifyCsrfToken;
use App\Models\Config;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

use Spatie\Sitemap\Sitemap;
use Spatie\Sitemap\Tags\Url;


/**
 * SITEMAP;
*/
Route::get('/sitemap.xml', function () {
    $sitemap = Sitemap::create();

    // Add static pages
    $sitemap->add(Url::create('/')->setPriority(1.0));
    $sitemap->add(Url::create('/subscriptions')->setPriority(0.9));
    $sitemap->add(Url::create('/contact-us')->setPriority(0.7));

    // Add blog posts dynamically
    $posts = \App\Models\Post::all();
    foreach ($posts as $post) {
        $sitemap->add(
            Url::create("/blog/{$post->slug}")
                ->setLastModificationDate($post->updated_at)
                ->setChangeFrequency('weekly')
                ->setPriority(0.8)
        );
    }

    return $sitemap->toResponse(request());
});


/**
 * CHANNELS LIST;
*/
Route::get('/channels-list', [ HomeController::class, 'channels_list' ])->name('channels_list');
Route::get('/getChannels/{id}', [ HomeController::class, 'getChannels' ])->name('getChannels');
Route::get('/changeCategory/{id}', [ HomeController::class, 'changeCategory' ])->name('changeCategory');
Route::get('/search/{keyword}', [ HomeController::class, 'search' ])->name('search');

Route::get('wtsp', function(Request $request) {
    $wtsp_link = Config::whereName('whatsapp_link')->first()->value;
    $wtsp_link = isset($request->text) ? $wtsp_link.'?text='.$request->text : $wtsp_link;
    return redirect()->to($wtsp_link);
})->name('wtsp');

Route::post('/stripe_webhook', [ CheckoutController::class, 'stripe_webhook' ])->withoutMiddleware(VerifyCsrfToken::class);

/**
 * BLOG
*/
Route::get('/blog', [ HomeController::class, 'blog' ])->name('blog');
// Route::get('/blog/page/{page}', [HomeController::class, 'blog'])->where('page', '[0-9]+'); // To Change Pagination Structure.
Route::get('/blog/category/{slug}', [ HomeController::class, 'blog_category' ])->name('blog_category');
Route::redirect('/how-to-install', '/blog/category/how-to-install', 301);


/**
 * CUSTOMER AREA
*/
Route::get('/getPostData/{id}', [ HomeController::class, 'getPostData' ])->name('getPostData');

Auth::routes([ 'register' => false, 'login' => false, 'reset' => false ]);
Route::get('/amlog', [ LoginController::class, 'showLoginForm' ]);
Route::post('/amlog', [ LoginController::class, 'login' ])->name('login');


Route::get('/', [ HomeController::class, 'home' ])->name('home');
// Route::get('/product/{slug}', [ HomeController::class, 'product' ])->name('product');
Route::get('/category/{id}', [ HomeController::class, 'category' ])->name('category');

Route::get('/configure', [ CartController::class, 'show' ])->name('cart');
Route::post('/configure', [ CartController::class, 'store' ])->name('cart.store');

Route::get('/checkout', [ CheckoutController::class, 'show' ])->name('checkout');
Route::post('/checkout_bridge', [ CheckoutController::class, 'checkout_bridge' ])->name('checkout_bridge');
Route::get('/complete_ref_payment/{id}', [ CheckoutController::class, 'complete_ref_payment' ])->name('complete_ref_payment');
Route::post('/payment/ok', [ CheckoutController::class, 'payment_ok' ])->name('payment.ok');
Route::get('/order_received', [ CheckoutController::class, 'order_received' ])->name('order_received');
Route::post('/payment_regular', [ CheckoutController::class, 'payment_regular' ])->name('payment.regular');

Route::get('/contact-us', [ HomeController::class, 'contactus' ])->name('contactus');
Route::post('/contact-us', [ HomeController::class, 'contactus_send' ])->name('contactus.send');

Route::get('/faq', [ HomeController::class, 'faq' ])->name('faq');

Route::get('/subscriptions', [ HomeController::class, 'subscriptions' ])->name('subscriptions');

Route::get('/blog/{slug}', [HomeController::class, 'post'])->name('post');

Route::get('/{slug}', [HomeController::class, 'page'])->name('page');

Route::get('pay_invoice/{data}', [CheckoutController::class, 'pay_invoice'])->name('pay_invoice');




/**
 * ADMIN SECTION;
*/
Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => ['auth', 'admin']], function() {
    Route::get('dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard');
    Route::get('orders', [AdminController::class, 'orders'])->name('admin.orders');
    Route::post('orders_filter', [AdminController::class, 'orders_filter'])->name('admin.orders_filter');
    Route::get('invoices', [AdminController::class, 'invoices'])->name('admin.invoices');
    Route::get('invoice/{id}', [AdminController::class, 'invoice'])->name('admin.invoice');
    Route::post('send_invoice_link', [AdminController::class, 'send_invoice_link'])->name('admin.send_invoice_link');
    Route::get('order_delete/{id}', [AdminController::class, 'order_delete'])->name('admin.order_delete');
    Route::get('order/{id}', [AdminController::class, 'order'])->name('admin.order');
    Route::post('send_order', [AdminController::class, 'send_order'])->name('admin.send_order');
    Route::post('update_order', [AdminController::class, 'update_order'])->name('admin.update_order');
    Route::post('connection', [AdminController::class, 'update_connection'])->name('admin.update_connection');
    Route::get('sent/{id}', [AdminController::class, 'set_sent'])->name('admin.set_sent');
    Route::get('refunded/{id}', [AdminController::class, 'set_refunded'])->name('admin.set_refunded');
    Route::get('paid/{id}', [AdminController::class, 'set_paid'])->name('admin.set_paid');
    /**
     * SETTINGS
    */
    Route::get('settings', [AdminController::class, 'settings'])->name('admin.settings');
    Route::post('/settings_save', [AdminController::class, 'settings_save'])->name('settings.save');
    Route::get('homepage_settings', [AdminController::class, 'homepage_settings'])->name('admin.homepage_settings');
    /**
     * PRODUCTS
    */
    Route::get('products', [AdminController::class, 'products'])->name('admin.products');
    Route::get('product/{id}', [AdminController::class, 'product_edit'])->name('admin.product_edit');
    Route::post('product', [AdminController::class, 'product_update'])->name('admin.product_update');
    Route::get('product_insert', [AdminController::class, 'product_insert'])->name('admin.product_insert');
    Route::post('product_save', [AdminController::class, 'product_save'])->name('admin.product_save');
    Route::get('product_delete/{id}', [AdminController::class, 'product_delete'])->name('admin.product_delete');
    /**
     * TESTIMONIALS
    */
    Route::get('testimonials', [AdminController::class, 'testimonials'])->name('admin.testimonials');
    Route::get('testimonial_insert', [AdminController::class, 'testimonial_insert'])->name('admin.testimonial_insert');
    Route::get('testimonial_delete/{id}', [AdminController::class, 'testimonial_delete'])->name('admin.testimonial_delete');
    Route::post('testimonials', [AdminController::class, 'testimonial_save'])->name('admin.testimonial_save');
    Route::get('testimonial/{id}', [AdminController::class, 'testimonial_edit'])->name('admin.testimonial_edit');
    Route::post('testimonial', [AdminController::class, 'testimonial_update'])->name('admin.testimonial_update');
    /**
     * SUBSCRIPTION TYPE;
    */
    Route::get('subtypes', [AdminController::class, 'subtypes'])->name('admin.subtypes');
    Route::post('subtypes', [AdminController::class, 'subtypes_update'])->name('admin.subtypes_update');
    Route::get('subtype_insert', [AdminController::class, 'subtype_insert'])->name('admin.subtype_insert');
    Route::post('subtype_insert', [AdminController::class, 'subtype_save'])->name('admin.subtype_save');
    /**
     * SERVERS;
    */
    Route::get('servers', [AdminController::class, 'servers'])->name('admin.servers');
    Route::post('servers', [AdminController::class, 'servers_update'])->name('admin.servers_update');
    Route::get('server_delete/{id}', [AdminController::class, 'server_delete'])->name('admin.server_delete');
    Route::get('server_insert', [AdminController::class, 'server_insert'])->name('admin.server_insert');
    Route::post('server_insert', [AdminController::class, 'server_save'])->name('admin.server_save');
    /**
     * PAYPAL
    */
    Route::get('paypal', [AdminController::class, 'paypal'])->name('admin.paypal');
    Route::get('paypal_insert', [AdminController::class, 'paypal_insert'])->name('admin.paypal_insert');
    Route::post('paypal_save', [AdminController::class, 'paypal_save'])->name('admin.paypal_save');
    Route::get('paypal_delete/{id}', [AdminController::class, 'paypal_delete'])->name('admin.paypal_delete');
    Route::post('paypal_update', [AdminController::class, 'paypal_update'])->name('admin.paypal_update');
    Route::get('paypal_shuffled/{status}', [AdminController::class, 'paypal_shuffled'])->name('admin.paypal_shuffled');
    Route::get('paypal_status/{status}', [AdminController::class, 'paypal_status'])->name('admin.paypal_status');
    /**
     * CATEGORIES
    */
    Route::get('categories', [AdminController::class, 'categories'])->name('admin.categories');
    Route::post('categories', [AdminController::class, 'categories_update'])->name('admin.categories_update');
    Route::get('category_insert', [AdminController::class, 'category_insert'])->name('admin.category_insert');
    Route::post('category_save', [AdminController::class, 'category_save'])->name('admin.category_save');
    Route::get('category_delete/{id}', [AdminController::class, 'category_delete'])->name('admin.category_delete');
    /**
     * Cnumbers
    */
    Route::get('cnumbers', [AdminController::class, 'cnumbers'])->name('admin.cnumbers');
    Route::post('cnumbers_update', [AdminController::class, 'cnumbers_update'])->name('admin.cnumbers_update');
    Route::get('cnumber_insert', [AdminController::class, 'cnumber_insert'])->name('admin.cnumber_insert');
    Route::post('cnumber_save', [AdminController::class, 'cnumber_save'])->name('admin.cnumber_save');
    Route::get('cnumber_delete/{id}', [AdminController::class, 'cnumber_delete'])->name('admin.cnumber_delete');
    /**
     * FAQ
    */
    Route::get('questions', [AdminController::class, 'questions'])->name('admin.questions');
    Route::get('questions_insert', [AdminController::class, 'questions_insert'])->name('admin.questions_insert');
    Route::post('questions_save', [AdminController::class, 'questions_save'])->name('admin.questions_save');
    Route::get('questions_edit/{id}', [AdminController::class, 'questions_edit'])->name('admin.questions_edit');
    Route::post('questions_update', [AdminController::class, 'questions_update'])->name('admin.questions_update');
    Route::get('questions_delete/{id}', [AdminController::class, 'questions_delete'])->name('admin.questions_delete');
    /**
     * BLOG CATEGORIES.
    */
    Route::get('blog_categories', [AdminController::class, 'blog_categories'])->name('admin.blog_categories');
    Route::post('blog_categories', [AdminController::class, 'blog_categories_update'])->name('admin.blog_categories_update');
    Route::get('blog_category_insert', [AdminController::class, 'blog_category_insert'])->name('admin.blog_category_insert');
    Route::post('blog_category_save', [AdminController::class, 'blog_category_save'])->name('admin.blog_category_save');
    /**
     * POSTS
    */
    Route::get('posts', [AdminController::class, 'posts'])->name('admin.posts');
    Route::get('post_insert', [AdminController::class, 'post_insert'])->name('admin.post_insert');
    Route::post('post_save', [AdminController::class, 'post_save'])->name('admin.post_save');
    Route::get('post_delete/{id}', [AdminController::class, 'post_delete'])->name('admin.post_delete');
    Route::get('post_edit/{id}', [AdminController::class, 'post_edit'])->name('admin.post_edit');
    Route::post('post_update', [AdminController::class, 'post_update'])->name('admin.post_update');
    /**
     * Legal Pages.
    */
    Route::get('legal_pages', [AdminController::class, 'legal_pages'])->name('admin.legal_pages');
    Route::get('legal_pages_insert', [AdminController::class, 'legal_pages_insert'])->name('admin.legal_pages_insert');
    Route::post('legal_pages_save', [AdminController::class, 'legal_pages_save'])->name('admin.legal_pages_save');
    Route::get('legal_pages_delete/{slug}', [AdminController::class, 'legal_pages_delete'])->name('admin.legal_pages_delete');
    Route::get('legal_pages_edit/{id}', [AdminController::class, 'legal_pages_edit'])->name('admin.legal_pages_edit');
    Route::post('legal_pages_update', [AdminController::class, 'legal_pages_update'])->name('admin.legal_pages_update');
    /**
     * MEDIA.
    */
    Route::get('media', [AdminController::class, 'media'])->name('admin.media');
    Route::get('media_insert', [AdminController::class, 'media_insert'])->name('admin.media_insert');
    Route::post('media_save', [AdminController::class, 'media_save'])->name('admin.media_save');
});