@if (Request::is('/'))
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Organization",
  "name": "{{config('app.name')}}",
  "url": "{{ url('/') }}",
  "logo": "{{ $logo }}",
  "sameAs": ["https://facebook.com/{{config('app.name')}}", "https://x.com/{{config('app.name')}}"]
}
</script>

<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "WebSite",
  "url": "{{ url('/') }}",
  "name": "{{config('app.name')}} IPTV Service",
  "potentialAction": {
    "@type": "SearchAction",
    "target": "{{ url('/search?q={search_term_string}') }}",
    "query-input": "required name=search_term_string"
  }
}
</script>
@endif

@if (Request::is('plans') || Request::is('configure'))
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Service",
  "name": "{{config('app.name')}} IPTV Plans",
  "serviceType": "IPTV Subscription",
  "areaServed": ["CA", "US"],
  "provider": {
    "@type": "Organization",
    "name": "{{config('app.name')}}",
    "url": "{{ url('/') }}"
  },
  "offers": {
    "@type": "Offer",
    "priceCurrency": "USD",
    "price": "14.99",
    "url": "{{ url()->current() }}"
  }
}
</script>
@endif

@if (Request::is('blog/*'))
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BlogPosting",
  "headline": "{{ $post->title ?? 'Blog Post' }}",
  "image": "{{ asset('storage/'.$post->poster) ?? asset('default-post-iptv.webp') }}",
  "author": {
    "@type": "Person",
    "name": "{{config('app.name')}} Team"
  },
  "publisher": {
    "@type": "Organization",
    "name": "{{config('app.name')}}",
    "logo": {
      "@type": "ImageObject",
      "url": "{{ $logo }}"
    }
  },
  "datePublished": "{{ $post->created_at ?? now()->toDateString() }}",
  "mainEntityOfPage": "{{ url()->current() }}"
}
</script>
@endif