@extends('layouts.app')
@section('title', config('app.name').' - '.$title)
@section('description', $description)
@section('content')
<div id="header-cta">
    <div class="container">
        <div class="row pb-1">
            <div class="col-lg-12 col-md-12">
                <div class="left_side text-center">
                    <h1>{{$homepage_ctaTitle}}</h1>
                    <p>{{$homepage_ctaParagraphHtml}}</p>
                    <div class="buttons_cta">
                        @if ( App\Models\Config::whereName('trial_allowed')->first()->value == 1 )
                        <a class="home_cta green" target="_blank" href="{{route('wtsp').'?text=Please I Wanna Try The Server Before I Buy'}}">
                            Try Before You Buy</a>
                        @endif
                        <a class="home_cta" href="#subscriptions">Our Subscriptions</a>
                    </div>
                    <img class="img-responsive main_header" width="500" height="316" src="{{asset('images/main.webp')}}" alt="">
                </div>
            </div>
        </div>
    </div>
</div>
<section class="regions-section dark_background" id=iptv-regions>
   <div class=container>
      <h2>IPTV Service for USA & Canada</h2>
      <p class=section-intro>Choose the best IPTV subscription optimized for your region — stream your favorite channels in HD, FHD and 4K with zero buffering and no contracts.
      <div class="region-grid row">
         <div class="region-card usa col-md-6 ">
            <h3>Best IPTV Service in the USA</h3>
            <p>Enjoy 10,000+ live American channels, premium sports, and on-demand movies with the fastest IPTV servers in the United States.
            <ul class=features>
               <li>🇺🇸 Local US servers for stability
               <li>All major sports and movie networks
               <li>Compatible with Firestick, Smart TVs, and Android
            </ul>
            <a class="home_cta" href="#subscriptions">View Canada Plans (USD)</a>
         </div>
         <div class="region-card canada col-md-6 ">
            <h3>Best IPTV Service in Canada</h3>
            <p>Stream Canadian and international channels in HD, FHD and 4k quality with our reliable IPTV plans — no contracts, no hidden fees.
            <ul class=features>
               <li>🇨🇦 Exclusive Canadian TV channels
               <li>Support for all major devices
               <li>Fast, secure Canadian servers
            </ul>
            <a class="home_cta" href="#subscriptions">View USA Plans (USD)</a>
         </div>
      </div>
   </div>
</section>
<div class="post-section channels_list_section text-center">
    <div class="col-md-11">
        <div class="content">
            <h2>watch the channels you love</h2>
            <p>From national sports networks to premium entertainment, {{config('app.name')}} brings together every channel North Americans love — all in one IPTV subscription.</p>
            <div class="us-content box">
                <h3>popular US channels</h3>
                <p>All your favorite American sports, news, and entertainment networks — stream live without cable.</p>
                <ul class="channels-list us-channels">
                    <li>
                        <svg width="100" height="40"><use xlink:href="#svg-espn" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="100" height="40"><use xlink:href="#svg-nbc" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="100" height="40"><use xlink:href="#svg-cbs" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="100" height="40"><use xlink:href="#svg-fox-sports-1" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="90" height="60"><use xlink:href="#svg-nfl-network" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="100" height="40"><use xlink:href="#svg-nba-tv" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="100" height="40"><use xlink:href="#svg-hbo" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="100" height="40"><use xlink:href="#svg-showtime" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="100" height="40"><use xlink:href="#svg-cnn" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="100" height="40"><use xlink:href="#svg-discovery" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                </ul>
            </div>
            <div class="ca-content box">
                <h3>canadian favorites</h3>
                <p>Stay connected to local Canadian content: live sports, national news, and bilingual programming from coast to coast.</p>
                <ul class="channels-list ca-channels">
                    <li>
                        <svg width="70" height="40"><use xlink:href="#svg-global-tv" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>    
                    <li>
                        <svg width="80" height="40"><use xlink:href="#svg-tsn" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="140" height="40"><use xlink:href="#svg-sportsnet" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="100" height="40"><use xlink:href="#svg-cbc" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="80" height="40"><use xlink:href="#svg-ctv" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="100" height="40"><use xlink:href="#svg-cp24" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="100" height="40"><use xlink:href="#svg-super-channel" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="100" height="40"><use xlink:href="#svg-rds" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="80" height="60"><use xlink:href="#svg-lcn" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                </ul>
            </div>
            <div class="international-content box">
                <h3>international channels</h3>
                <p>Enjoy top channels from the UK, Europe, Asia, and beyond — perfect for multicultural families and expats.</p>
                <ul class="channels-list ca-channels">
                    <li>
                        <svg width="70" height="40"><use xlink:href="#svg-bbc" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="60" height="40"><use xlink:href="#svg-itv" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="100" height="40"><use xlink:href="#svg-sky-sports" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="100" height="40"><use xlink:href="#svg-canal-plus" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="100" height="40"><use xlink:href="#svg-mbc" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="100" height="40"><use xlink:href="#svg-telemundo" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="80" height="40"><use xlink:href="#svg-zee-tv" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                    <li>
                        <svg width="100" height="40"><use xlink:href="#svg-jio-star" xmlns:xlink="http://www.w3.org/1999/xlink"></use></svg>
                    </li>
                </ul>
            </div>
            <div class="full-channels-list box">
                <p>One subscription, every channel — entertainment without limits.</p>
                <a class="cta_channels" href="{{route('channels_list')}}">view full channels list</a>
            </div>
        </div>
    </div>
</div>
<div id="choose_us" class="text-center dark_background">
    <div class="container">
        <h2>why <span class="colored">{{config('app.name')}}</span> is the right IPTV option and the best ?</h2>
        <div class="row mt-4">
            <div class="col-md-4">
                <div class="choose_us_itm">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#ffffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-hand-fist-icon lucide-hand-fist"><path d="M12.035 17.012a3 3 0 0 0-3-3l-.311-.002a.72.72 0 0 1-.505-1.229l1.195-1.195A2 2 0 0 1 10.828 11H12a2 2 0 0 0 0-4H9.243a3 3 0 0 0-2.122.879l-2.707 2.707A4.83 4.83 0 0 0 3 14a8 8 0 0 0 8 8h2a8 8 0 0 0 8-8V7a2 2 0 1 0-4 0v2a2 2 0 1 0 4 0"/><path d="M13.888 9.662A2 2 0 0 0 17 8V5A2 2 0 1 0 13 5"/><path d="M9 5A2 2 0 1 0 5 5V10"/><path d="M9 7V4A2 2 0 1 1 13 4V7.268"/></svg>
                    <h3>24/7 Customer Support</h3>
                    <p><span>We do offer multiple support options live by whatsapp, By live chat button and through email.</span></p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="choose_us_itm">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-refresh-ccw-icon lucide-refresh-ccw"><path d="M21 12a9 9 0 0 0-9-9 9.75 9.75 0 0 0-6.74 2.74L3 8"/><path d="M3 3v5h5"/><path d="M3 12a9 9 0 0 0 9 9 9.75 9.75 0 0 0 6.74-2.74L21 16"/><path d="M16 16h5v5"/></svg>
                    <h3>Anti Freeze™ 8.0</h3>
                    <p><span>Using Anti-Freeze Technology, You do not need to worry about the server stability.</span></p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="choose_us_itm">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#ffffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-monitor-check-icon lucide-monitor-check"><path d="m9 10 2 2 4-4"/><rect width="20" height="14" x="2" y="3" rx="2"/><path d="M12 17v4"/><path d="M8 21h8"/></svg>
                    <h3>Watch On Any Device</h3>
                    <p><span>Our IPTV service works on any device such as TVs, Smartphones, FireStick, MAG, Android Boxes etc…</span></p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4">
                <div class="choose_us_itm">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#ffffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-thumbs-up-icon lucide-thumbs-up"><path d="M7 10v12"/><path d="M15 5.88 14 10h5.83a2 2 0 0 1 1.92 2.56l-2.33 8A2 2 0 0 1 17.5 22H4a2 2 0 0 1-2-2v-8a2 2 0 0 1 2-2h2.76a2 2 0 0 0 1.79-1.11L12 2a3.13 3.13 0 0 1 3 3.88Z"/></svg>
                    <h3>Best IPTV Quality</h3>
                    <p><span>We do provide all our channels in different qualities depending on your network, SD/HD/FHD/2K/4K.</span></p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="choose_us_itm">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#ffffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-tv-icon lucide-tv"><path d="m17 2-5 5-5-5"/><rect width="20" height="15" x="2" y="7" rx="2"/></svg>
                    <h3>18,700 Channels</h3>
                    <p><span>18,700 channels & 118K VOD (Movies & Series) Worldwide. <span class="colored">The Best bouquet in the market</span></span></p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="choose_us_itm">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#ffffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-timer-icon lucide-timer"><line x1="10" x2="14" y1="2" y2="2"/><line x1="12" x2="15" y1="14" y2="11"/><circle cx="12" cy="14" r="8"/></svg>
                    <h3>CATCH UP</h3>
                    <p><span>Our Server offers 72H Catchup for the channels that are offering Catchup from the source.</span></p>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="how_to_pay">
    <h2>How To Buy IPTV On Our Website ?</h2>
    <p>we have simplified the steps to be easy for you with a simple interface to order your IPTV subscription quite fast.</p>
    <div class="container text-center">
        <div class="row">
            <div class="col-md-3">
                <div class="item">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#ffffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-badge-check-icon lucide-badge-check"><path d="M3.85 8.62a4 4 0 0 1 4.78-4.77 4 4 0 0 1 6.74 0 4 4 0 0 1 4.78 4.78 4 4 0 0 1 0 6.74 4 4 0 0 1-4.77 4.78 4 4 0 0 1-6.75 0 4 4 0 0 1-4.78-4.77 4 4 0 0 1 0-6.76Z"/><path d="m9 12 2 2 4-4"/></svg>
                    <h3>1. select connections</h3>
                    <p>look at the pricing table down bellow, select connections number tab</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="item">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#ffffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-shopping-cart-icon lucide-shopping-cart"><circle cx="8" cy="21" r="1"/><circle cx="19" cy="21" r="1"/><path d="M2.05 2.05h2l2.66 12.42a2 2 0 0 0 2 1.58h9.78a2 2 0 0 0 1.95-1.57l1.65-7.43H5.12"/></svg>
                    <h3>2. select subscription</h3>
                    <p>see what period do you want, then click order now</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="item">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#ffffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-pencil-icon lucide-pencil"><path d="M21.174 6.812a1 1 0 0 0-3.986-3.987L3.842 16.174a2 2 0 0 0-.5.83l-1.321 4.352a.5.5 0 0 0 .623.622l4.353-1.32a2 2 0 0 0 .83-.497z"/><path d="m15 5 4 4"/></svg>
                    <h3>3. enter your details</h3>
                    <p>provide us with relevant information to get started with your order</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="item">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#ffffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-credit-card-icon lucide-credit-card"><rect width="20" height="14" x="2" y="5" rx="2"/><line x1="2" x2="22" y1="10" y2="10"/></svg>
                    <h3>4. checkout</h3>
                    <p>pay the service charges through PayPal Or Credit Card.</p>
                </div>
            </div>
        </div>
    </div>
</div>
@if( $standardCnumbers )
<section id="subscriptions" class="dark_background">
    <h2>choose your IPTV plan at affordable pricing</h2>
    <p>
        Looking for reliable and affordable IPTV subscription plans? Look no further! Our website offers a wide range of IPTV plans with same features and different prices to suit your needs. Whether you're a sports enthusiast or a movie buff, we have the perfect plan for you. <br>
        Plus, with our competitive pricing, you can enjoy the best IPTV services without breaking the bank. Try us out today and see for yourself!
    </p>
    <div class="container">
        <p class="note">* if you wanna watch on multiple devices in the same time, choose the number of devices do you have. </p>
        <p class="note">* You will get separated accounts, each device with its connection details.</p>
        <nav>
            <div class="nav nav-tabs" id="nav-tab" role="tablist">
               @foreach ($standardCnumbers as $standardCnumber)
               <button class="nav-link {{$standardCnumber->id == $standardCnumbers[0]->id ? 'active' : '' }}" id="{{$standardCnumber->id}}-tab" data-bs-toggle="tab" data-bs-target="#nav-{{$standardCnumber->id}}" type="button" role="tab" aria-controls="nav-{{$standardCnumber->id}}" aria-selected="true">{{$standardCnumber->name}}</button>
               @endforeach
            </div>
         </nav>
        <div class="tab-content" id="nav-tabContent">
           @foreach ($standardCnumbers as $standardCnumber)
           <div class="tab-pane {{ $standardCnumbers[0]->id == $standardCnumber->id ? 'show active' : '' }}" id="nav-{{$standardCnumber->id}}" role="tabpanel" aria-labelledby="nav-one-tab">
               <div class="row d-flex justify-content-center text-center">
                  @foreach ($standardCnumber->products as $product)
                  <div class="col-lg-3 col-md-4 col-sm-6">
                     <article class="plan-card {{$product->hot == 1 ? 'product_hot' : ''}}">
                        @if($product->hot == 1)<span class="hot">🔥 POPULAR 🔥</span>@endif
                        <h3 class="period">{{$product->period}}</h3>
                        @if( $premiumCnumbers )<h2 class="server_type">{{$product->cnumber->category->name}}</h2>@endif
                        <div class="product_price">
                           <span class="price">{{$product->price}}</span>
                           <span class="currency">{{$currency->code}}</span>
                           <span class="old_price">{{number_format($product->price*100/60, 2).''.$currency->symbol}}</span>
                        </div>
                        <ul class="server_infos">
                           <li class="conn_number">{{$standardCnumber->name}}</li>
                           @if( $product->monthly )
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> Only <span class="monthly">{{ $product->monthly.$currency->symbol }}</span> a Month</li>
                           @else
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> No Activation Fees</li>
                           @endif
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> +17.7k Channels</li>
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> Up to 14k Series</li>
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> Up to 44k Movies</li>
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> CATCH UP | EPG</li>
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> 8k, 4K, Ultra HD and HQ</li>
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> Anti Freeze System</li>
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> MAG & Firestick</li>
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> Smarter & Tvmate APP</li>
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> Free Support 24/7</li>
                        </ul>
                        <form action="{{route('cart.store')}}" method="POST">
                           @csrf
                           <input type="hidden" name="id" value="{{$product->id}}">
                           @if( $product->in_stock == 1 )
                           <button type="submit" class="order_now_product" href="#">Order Now</button>
                            @else
                            <button disabled class="order_now_product btn btn-disabled" href="#">Not Available</button>
                            @endif
                        </form>
                     </article>
                  </div>
                  @endforeach
                  <p class="currency-note"> 💳 All prices are in <strong>USD</strong>. Canadian customers can pay securely using any major credit card or PayPal. </p>
               </div>
            </div>
           @endforeach
           @if( true )
           <div class="more_than4">
            <h2>You want more than 5 connections ?</h2>
            <a class="reach_us" target="_blank" href="{{route('wtsp').'?text=Hi, I am interesting in more than 5 connections plans.'}}">
                <i class="fa fa-whatsapp"></i>
                Send WhatsApp MESSAGE
            </a>
            </div>
            @endif
        </div>
    </div>
</section>
@endif
@if( $premiumCnumbers)
<section id="subscriptions" class="dark_background">
    <h2>PREMIUM SERVER</h2>
    <p>
        Interesting in a service with top notch quality with real 4k picture, you are in the right place, this server comes up with more series and movies in real 4k quality of picture
    </p>
    <div class="container">
        <p class="note">* if you wanna watch on multiple devices in the same time, choose the number of devices do you have. </p>
        <p class="note">* You will get separated accounts, each device with its connection details.</p>
        <nav>
            <div class="nav nav-tabs" id="nav-tab" role="tablist">
               @foreach ($premiumCnumbers as $premiumCnumber)
               <button class="nav-link {{$premiumCnumber->id == $premiumCnumbers[0]->id ? 'active' : '' }}" id="{{$premiumCnumber->id}}-tab" data-bs-toggle="tab" data-bs-target="#nav-{{$premiumCnumber->id}}" type="button" role="tab" aria-controls="nav-{{$premiumCnumber->id}}" aria-selected="true">{{$premiumCnumber->name}}</button>
               @endforeach
            </div>
         </nav>
        <div class="tab-content" id="nav-tabContent">
           @foreach ($premiumCnumbers as $premiumCnumber)
           <div class="tab-pane {{ $premiumCnumbers[0]->id == $premiumCnumber->id ? 'show active' : '' }}" id="nav-{{$premiumCnumber->id}}" role="tabpanel" aria-labelledby="nav-one-tab">
               <div class="row d-flex justify-content-center text-center">
                  @foreach ($premiumCnumber->products as $product)
                  <div class="col-lg-3 col-md-4 col-sm-6">
                     <div class="plan-card {{$product->hot == 1 ? 'product_hot' : ''}}">
                        @if($product->hot == 1)<span class="hot">POPULAR</span>@endif
                        <h3 class="period">{{$product->period}}</h3>
                        @if( $standardCnumbers )<h2 class="server_type">{{$product->cnumber->category->name}}</h2>@endif
                        <div class="product_price">
                           <span class="price">{{$product->price}}</span>
                           <span class="currency">{{$currency->code}}</span>
                           <span class="old_price">{{number_format($product->price*100/60, 2).''.$currency->symbol}}</span>
                        </div>
                        <ul class="server_infos">
                           <li class="conn_number"><i class="fa fa-check-circle-o"></i>{{$premiumCnumber->name}}</li>
                           @if( $product->monthly )
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> Only <span class="monthly">{{ $product->monthly.$currency->symbol }}</span> a Month</li>
                           @else
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> No Activation Fees</li>
                           @endif
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> +22.4k Channels</li>
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> +125k Movies <br><span style="color: #edf905">( ~ 23k English Movies )</span></li>
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> +24k Series <br><span style="color: #edf905">( ~ 6k English Series )</span></li>
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> CATCH UP | EPG</li>
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> 8k, 4K, Ultra HD and HQ</li>
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> Anti Freeze System</li>
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> MAG & Firestick</li>
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> Smarter & Tvmate APP</li>
                           <li><svg class="icon" aria-hidden="true" width="18" height="18"><use href="#icon-check"></use></svg> Free Support 24/7</li>
                        </ul>
                        <form action="{{route('cart.store')}}" method="POST">
                           @csrf
                           <input type="hidden" name="id" value="{{$product->id}}">
                           @if( $product->in_stock == 1 )
                           <button type="submit" class="order_now_product" href="#">Order Now</button>
                            @else
                            <button disabled class="order_now_product btn btn-disabled" href="#">Not Available</button>
                            @endif
                        </form>
                     </div>
                  </div>
                  @endforeach
               </div>
            </div>
           @endforeach
           <div class="more_than4">
            <h2>You want more than {{$lastPremiumCnumber}} connections ?</h2>
            <a class="reach_us" target="_blank" href="{{route('wtsp').'?text=Hi, I am interesting in more than '.$lastPremiumCnumber.' connections plans  [ Premium Server ].'}}">
                <i class="fa fa-whatsapp"></i>
                Send WhatsApp MESSAGE
            </a>
        </div>
        </div>
    </div>
</section>
@endif

@if( \App\Models\Config::whereName('reseller')->first()->value == 1 )
<div id="reseller" class="dark_background text-center">
    <h2>Start Your Business Now & Unlock More Features</h2>
    <h3>What will i get as a reseller ?</h3>
    <ul>
        <li><i class="fa fa-check-circle"></i> A Secure Panel With Username && Password.</li>
        <li><i class="fa fa-check-circle"></i> Credits To Generate Your Clients' Subscriptions</li>
        <li><i class="fa fa-check-circle"></i> CHAT SUPPORT ( 24/24 )</li>
    </ul>
    <a class="reach_us" target="_blank" href="{{route('wtsp')}}?text=Hi, I would like to be a reseller, more infos please.">
        <i class="fa fa-whatsapp"></i>
        Get Your Reselling Plan Now
    </a>
</div>
@endif


@if ( \App\Models\Config::whereName('homepage_testimonialsEnabled')->first()->value == 1 )
<div id="testimonials">
    <h2>our clients <i class="fa fa-heart"></i></h2>
    <p></p>
    <div class="container">
        <div class="wtsp_screens owl-carousel owl-theme">
            <div class="item"><img width="290" height="569" alt="testimonials whatsapp screenshot" src="{{asset('images/wtsp/1.webp')}}"></div>
            <div class="item"><img width="290" height="569" alt="testimonials whatsapp screenshot" src="{{asset('images/wtsp/2.webp')}}"></div>
            <div class="item"><img width="290" height="569" alt="testimonials whatsapp screenshot" src="{{asset('images/wtsp/4.webp')}}"></div>
            <div class="item"><img width="290" height="569" alt="testimonials whatsapp screenshot" src="{{asset('images/wtsp/5.webp')}}"></div>
            <div class="item"><img width="290" height="569" alt="testimonials whatsapp screenshot" src="{{asset('images/wtsp/6.webp')}}"></div>
            <div class="item"><img width="290" height="569" alt="testimonials whatsapp screenshot" src="{{asset('images/wtsp/8.webp')}}"></div>
        </div>
    </div>
</div>
@endif

<div class="container my-5">
    <div class="row">
        <div class="col-md-6">
            <section id="faq" >
                <h2>Frequently Asked Questions</h2>
                @foreach(App\Models\Question::whereVisibility(true)->take(5)->get() as $faq)
                <details>
                    <summary>
                        {{$faq->question}}
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M12 5v14M5 12h14" />
                        </svg>
                    </summary>
                    <p>
                        {!!$faq->answer!!}
                    </p>
                </details>
                @endforeach
                <p style="margin-top:1rem;">
                    <a class="faq_cta" href="{{route('faq')}}">View All FAQ Questions →</a>
                </p>
            </section>
        </div>
        <div class="col-md-6">
        <section id="cta-box">
            <h2>Ready to Start Streaming?</h2>
            <p>Buy your IPTV subscription today and get instant access.</p>
            <a class="home_cta" href="#subscriptions">Buy IPTV Now</a>
            @if ( App\Models\Config::whereName('trial_allowed')->first()->value == 1 )
            <a class="home_cta green" target="_blank" href="{{route('wtsp').'?text=Please I Wanna Try The Server Before I Buy'}}">
            Try Before You Buy</a>
            @endif
        </section>
        </div>
    </div>
</div>

@endsection
@section('extra_css')
@include('partials.icons')
<style>
.owl-carousel .owl-item img {
    height: auto!important;
}
</style>
@endsection