@extends('layouts.adminapp')
@section('extra_css')
<link href="/vd/sweetalert2/dist/sweetalert2.min.css" rel="stylesheet" type="text/css" />
<script src="/vd/sweetalert2/dist/sweetalert2.min.js" type="text/javascript"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/mdbassit/Coloris@latest/dist/coloris.min.css"/>
<script src="https://cdn.jsdelivr.net/gh/mdbassit/Coloris@latest/dist/coloris.min.js"></script>
<style>
    div.swal2-select {
        display: none !important;
    }
    label {
        display: block
    }

    .clr-field button {
        border-radius: 0 11px 11px 0;
    }
</style>
@endsection
@section('title', 'Settings')
@section('content')
<div class="card card-default color-palette-box">
    <div class="card-body">
        @if ( session('success') )
        @verbatim <script>
            $(function() {
                Swal("Saved Successfully !!", "", "success")
            });
        </script> @endverbatim
        @endif
        <form action="{{ route('settings.save') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="row">
                <div class="col-md-3 form-group">
                    <label for="background_color">Background Color</label>
                    <input id="background_color" name="background_color" value="{{$configs['background_color']}}" class="form-control" type="text" data-coloris>
                </div>

                <div class="col-md-3 form-group">
                    <label for="cta_color">Call To Action Color</label>
                    <input id="cta_color" name="cta_color" value="{{$configs['cta_color']}}" class="form-control" type="text" data-coloris>
                </div>

                <div class="col-md-3 form-group">
                    <label for="cl_defaultCategory">Def. Chan. Lst Category</label>
                    <select name="cl_defaultCategory">
                        @foreach (App\Models\Category::whereActive(true)->get() as $category)                            
                        <option value='{{$category->id}}' {{ $configs['cl_defaultCategory'] == $category->id ? 'selected' : '' }}>{{$category->name}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3 form-group">
                    <label for="cl_defaultStandardCountryId">Def. Country Chan. Lst Standard</label>
                    <select name="cl_defaultStandardCountryId">
                        @foreach (App\Models\Category::where('name', 'LIKE', '%standard%')->first()->countries as $country)                            
                        <option value='{{$country->id}}' {{ $configs['cl_defaultStandardCountryId'] == $country->id ? 'selected' : '' }}>{{$country->name}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3 form-group">
                    <label for="cl_defaultPremiumCountryId">Def. Country Chan. Lst Premium</label>
                    <select name="cl_defaultPremiumCountryId">
                        @foreach (App\Models\Category::where('name', 'LIKE', '%premium%')->first()->countries as $country)                            
                        <option value='{{$country->id}}' {{ $configs['cl_defaultPremiumCountryId'] == $country->id ? 'selected' : '' }}>{{$country->name}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    <label for="white_logo" class="form-label">White Logo</label>
                    <input type="file" class="form-file-input form-control" name="white_logo" id="white_logo">
                </div>
                <div class="col-md-3 mb-3">
                    <label for="black_logo" class="form-label">Black Logo</label>
                    <input type="file" class="form-file-input form-control" name="black_logo" id="black_logo">
                </div>
                <div class="col-md-3 mb-3">
                    <label for="favicon" class="form-label">Facicon</label>
                    <input type="file" class="form-file-input form-control" name="favicon" id="favicon">
                </div>
                <div class="col-md-3 form-group">
                    <label for="redirection_seconds">Redirection Seconds</label>
                    <input type="text" class="form-control" id="redirection_seconds" name="redirection_seconds" value="{{$configs['redirection_seconds']}}" placeholder="Redirection Seconds">
                </div>
            </div>
            <div class="row">
                <div class="col-md-3 form-group">
                    <label for="redirection_allowed">Redirection Allowed</label>
                    <select name="redirection_allowed">
                        <option value='1' {{ $configs['redirection_allowed'] == 1 ? 'selected' : '' }}>YES</option>
                        <option value='0' {{ $configs['redirection_allowed'] == 0 ? 'selected' : '' }}>NO</option>
                    </select>
                </div>
                <div class="col-md-3 form-group">
                    <label for="trial_allowed">Trial Allowed</label>
                    <select name="trial_allowed">
                        <option value='1' {{ $configs['trial_allowed'] == 1 ? 'selected' : '' }}>YES</option>
                        <option value='0' {{ $configs['trial_allowed'] == 0 ? 'selected' : '' }}>NO</option>
                    </select>
                </div>
                <div class="col-md-3 form-group">
                    <label for="top_message_allowed">Top Message Allowed</label>
                    <select name="top_message_allowed">
                        <option value='1' {{ $configs['top_message_allowed'] == 1 ? 'selected' : '' }}>YES</option>
                        <option value='0' {{ $configs['top_message_allowed'] == 0 ? 'selected' : '' }}>NO</option>
                    </select>
                </div>
                <div class="col-md-3 form-group">
                    <label for="legal_website">Legal Website</label>
                    <input type="text" class="form-control" id="legal_website" name="legal_website" value="{{$configs['legal_website']}}" placeholder="Legal Website">
                </div>
            </div>
            <div class="row">
                <div class="col-md-3 form-group">
                    <label for="disable_tools">Disable Tools</label>
                    <select id="disable_tools" name="disable_tools">
                        <option value='1' {{ $configs['disable_tools'] == 1 ? 'selected' : '' }}>YES</option>
                        <option value='0' {{ $configs['disable_tools'] == 0 ? 'selected' : '' }}>NO</option>
                    </select>
                </div>
                <div class="col-md-4 form-group">
                    <label for="gtag">Analytics Tag</label>
                    <input type="text" class="form-control" id="gtag" name="gtag" value="{{$configs['gtag']}}" placeholder="Analytics Google Tag">
                </div>
                <div class="col-md-4 form-group">
                    <label for="top_message">Top Message</label>
                    <input type="text" class="form-control" id="top_message" name="top_message" value="{{$configs['top_message']}}" placeholder="Top Message">
                </div>
            </div>
            <div class="row">
                <div class="col-md-3 form-group">
                    <label for="website_title">Website Title</label>
                    <input type="text" class="form-control" id="website_title" name="website_title" value="{{$configs['website_title']}}" placeholder="Website Title">
                </div>
                <div class="col-md-8 form-group">
                    <label for="seo_title">Seo Title</label>
                    <input type="text" class="form-control" id="seo_title" name="seo_title" value="{{$configs['seo_title']}}" placeholder="Seo Title">
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 form-group">
                    <label for="seo_description">Seo Description</label>
                    <input type="text" class="form-control" id="seo_description" name="seo_description" value="{{$configs['seo_description']}}" placeholder="Seo Description">
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 form-group">
                    <label for="seo_keywords">Seo Keywords</label>
                    <input type="text" class="form-control" id="seo_keywords" name="seo_keywords" value="{{$configs['seo_keywords']}}" placeholder="Seo Keywords">
                </div>
                <div class="col-md-12 form-group">
                    <label for="about_us">About Us</label>
                    <input type="text" class="form-control" id="about_us" name="about_us" value="{{$configs['about_us']}}" placeholder="About US">
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 form-group">
                    <label for="whatsapp_link">Whatsapp Link</label>
                    <input type="text" class="form-control" id="whatsapp_link" name="whatsapp_link" value="{{$configs['whatsapp_link']}}" placeholder="Whatsapp Link">
                </div>

                <div class="col-md-4">
                    <label for="default_iptvServer" class="form-label">Default Iptv Server</label>
                    <select name="default_iptvServer">
                        @foreach (\App\Models\Server::all() as $server)
                        <option value="{{$server->id}}" {{ $configs['default_iptvServer'] == $server->id ? 'selected' : '' }}>{{$server->name}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 form-group">
                    <label for="oneSignalRestApiKey">OneSignal Rest Api Key</label>
                    <input type="text" class="form-control" id="oneSignalRestApiKey" name="oneSignalRestApiKey" value="{{$configs['oneSignalRestApiKey']}}" placeholder="OneSignal Api Key">
                </div>
                <div class="col-md-6 form-group">
                    <label for="oneSignalAppId">OneSignal App ID</label>
                    <input type="text" class="form-control" id="oneSignalAppId" name="oneSignalAppId" value="{{$configs['oneSignalAppId']}}" placeholder="OneSignal App ID">
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    <label for="currency" class="form-label">Currency</label>
                    <select name="currency" name="currency">
                        @foreach (\App\Models\Currency::all() as $currency)
                        <option value='{{$currency->id}}' {{ $configs['currency'] == $currency->id ? 'selected' : '' }}>{{$currency->name}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="app_notifications" class="form-label">App Notifications</label>
                    <select name="app_notifications">
                        <option value='1' {{ $configs['app_notifications'] == 1 ? 'selected' : '' }}>YES</option>
                        <option value='0' {{ $configs['app_notifications'] == 0 ? 'selected' : '' }}>NO</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="client_notifications" class="form-label">Client Notifications</label>
                    <select name="client_notifications">
                        <option value='1' {{ $configs['client_notifications'] == 1 ? 'selected' : '' }}>YES</option>
                        <option value='0' {{ $configs['client_notifications'] == 0 ? 'selected' : '' }}>NO</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="reseller" class="form-label">Show Reseller</label>
                    <select name="reseller">
                        <option value='1' {{ $configs['reseller'] == 1 ? 'selected' : '' }}>YES</option>
                        <option value='0' {{ $configs['reseller'] == 0 ? 'selected' : '' }}>NO</option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4 form-group">
                    <label for="vod_enabled">VOD Content Addon ( STATUS )</label>
                    <select name="vod_enabled" style="width: 100%">
                        <option value='1' {{ $configs['vod_enabled'] == 1 ? 'selected' : '' }}>YES</option>
                        <option value='0' {{ $configs['vod_enabled'] == 0 ? 'selected' : '' }}>NO</option>
                    </select>
                </div>
                <div class="col-md-4 form-group">
                    <label for="vod_price">VOD Content Addon ( Price )</label>
                    <input type="text" class="form-control" id="vod_price" name="vod_price" value="{{$configs['vod_price']}}" placeholder="VOD Content Price">
                </div>
            </div>
            <div class="row">
                <div class="col-md-4 form-group">
                    <label for="adult_enabled">Adult Content Addon ( STATUS )</label>
                    <select name="adult_enabled" style="width: 100%">
                        <option value='1' {{ $configs['adult_enabled'] == 1 ? 'selected' : '' }}>YES</option>
                        <option value='0' {{ $configs['adult_enabled'] == 0 ? 'selected' : '' }}>NO</option>
                    </select>
                </div>
                <div class="col-md-4 form-group">
                    <label for="adult_price">Adult Content Addon ( Price )</label>
                    <input type="text" class="form-control" id="adult_price" name="adult_price" value="{{$configs['adult_price']}}" placeholder="Adult Content Price">
                </div>
            </div>
            <div class="row">
                <div class="col-md-4 form-group">
                    <label for="fastdelivery_enabled">Fast Delivery Addon ( STATUS )</label>
                    <select name="fastdelivery_enabled" style="width: 100%">
                        <option value='1' {{ $configs['fastdelivery_enabled'] == 1 ? 'selected' : '' }}>YES</option>
                        <option value='0' {{ $configs['fastdelivery_enabled'] == 0 ? 'selected' : '' }}>NO</option>
                    </select>
                </div>
                <div class="col-md-4 form-group">
                    <label for="fastdelivery_price">Prioritize Order Addon ( Price )</label>
                    <input type="text" class="form-control" id="fastdelivery_price" name="fastdelivery_price" value="{{$configs['fastdelivery_price']}}" placeholder="Fast Delivery Addon Price">
                </div>
            </div>

            <div class="row">
                <div class="col-md-4 form-group">
                    <label for="gads_tracking_enabled">Gads Tracking Enabled</label>
                    <select name="gads_tracking_enabled" style="width: 100%">
                        <option value='1' {{ $configs['gads_tracking_enabled'] == 1 ? 'selected' : '' }}>YES</option>
                        <option value='0' {{ $configs['gads_tracking_enabled'] == 0 ? 'selected' : '' }}>NO</option>
                    </select>
                </div>
                <div class="col-md-8 form-group">
                    <label for="gads_tracking_tag">Gads Tracking Tag</label>
                    <input type="text" class="form-control" id="gads_tracking_tag" name="gads_tracking_tag" value="{{$configs['gads_tracking_tag']}}" placeholder="Gads Tracking Tag">
                </div>
                <div class="col-md-8 form-group">
                    <label for="gads_conversion_id">Gads Conversion ID</label>
                    <input type="text" class="form-control" id="gads_conversion_id" name="gads_conversion_id" value="{{$configs['gads_conversion_id']}}" placeholder="Gads Conversion ID">
                </div>
            </div>
            <div class="row">
                <button type="submit" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>
</div>
@endsection
@section('extra_js')
<script src="/js/sweetalert2.min.js"></script>
@endsection
