@extends('layouts.adminapp')
@section('title', $title)
@section('extra_css')
<link href="/vd/sweetalert2/dist/sweetalert2.min.css" rel="stylesheet" type="text/css"/>
<script src="/vd/sweetalert2/dist/sweetalert2.min.js" type="text/javascript"></script>
<style>
span.badge.bg-success {
    padding: 5px 11px;
}
span.badge.bg-warning {
    padding: 3px 16px;
    font-weight: 600;
    font-size: 13px;
}
.table_td span.badge.bg-warning, .table_td span.badge.bg-success {
    border-radius: 13px!important;
    padding: 2px 9px;
    text-transform: uppercase
}
</style>
@endsection
@section('content')
<div class="card card-default color-palette-box">
    <div class="card-body table-responsive">
        @if($orders->count() > 0)
        <form action="{{route('admin.orders_filter')}}" id="filter_orders" method="POST">
            @csrf
            <div class="row">
                <div class="col-md-3">
                    @php
                        $search_type = isset($search_type) ? $search_type : '';
                        $search_input = isset($search_input) ? $search_input : '';
                    @endphp
                    <label for="search_type">TYPE</label>
                    <select name="search_type">
                        <option value="uuid" {{ $search_type == 'uuid' ? 'selected' : '' }}>uuid</option>
                        <option value="id" {{ $search_type == 'id' ? 'selected' : '' }}>Order ID</option>
                        <option value="billing_email" {{ $search_type == 'billing_email' ? 'selected' : '' }}>Email Address</option>
                        <option value="transaction_id" {{ $search_type == 'transaction_id' ? 'selected' : '' }}>Transaction ID</option>
                        <option value="customer_id" {{ $search_type == 'customer_id' ? 'selected' : '' }}>Customer ID</option>
                        <option value="ppl_email" {{ $search_type == 'ppl_email' ? 'selected' : '' }}>Paypal Email Address</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="search_input">INPUT</label>
                    <input class="form-control" type="text" name="search_input" placeholder="Search Input" value="{{$search_input}}">
                </div>
                <div class="row">
                    <button class="mt-3 btn btn-success" type="submit">Filter</button>
                </div>
            </div>
        </form>
        <table class="table">
            <thead>
                <tr>
                    <th>id</th>
                    <th>time</th>
                    <th>gateway</th>
                    <th>server</th>
                    <th>email</th>
                    <th>refunded</th>
                    <th>sent</th>
                    <th>total</th>
                    <th>actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($orders as $order)
                <tr order-id="{{$order->id}}">
                    <th>
                        <div class="table_td">
                            #{{$order->id}}
                        </div>
                    </th>
                    <th>
                        <div class="table_td vertical">
                            @php
                            $human_date = \Carbon\Carbon::parse(strtolower($title) == 'orders' ? $order->payment_date : $order->created_at);
                            @endphp
                            <span class="badge d-block mb-1 bg-dark">{{$human_date->diffForhumans()}}</span>
                            <span class="badge d-block bg-dark">{{$order->date}}</span>
                        </div>
                    </th>
                    <th class="customer">
                        <div class="table_td">
                            {{$order->gateway}}
                        </div>
                    </th>
                    <th class="customer">
                        <div class="table_td">
                            <span class="badge bg-success">
                                {{$order->product->cnumber->category->name}}
                            </span>
                        </div>
                    </th>
                    <th class="customer">
                        <div class="table_td">
                            {{$order->billing_email}}
                        </div>
                    </th>
                    <th>
                        <div class="table_td">
                            <span class="badge bg-{{ $order->refunded ? 'success' : 'warning' }}">
                            {{ $order->refunded ? 'yes' : 'No' }}
                            </span>
                        </div>
                    </th>
                    <th>
                        <div class="table_td">
                            <span class="badge bg-{{ $order->sent ? 'success' : 'warning' }}">
                                {{ $order->sent ? 'yes' : 'Not Yet' }}
                                </span>
                        </div>
                    </th>
                    <th>
                        <div class="table_td">
                            {{$order->total}} {{$order->currency->symbol}}
                        </div>
                    </th>
                    <th class="actions">
                        <div class="table_td">
                            @if ( strtolower($title) == 'orders' )
                            <a style="margin-right: 7px" href="{{ route('admin.order', $order->id) }}"><i class="fa fa-eye"></i></a>
                            @else
                            <a style="margin-right: 7px" href="{{ route('admin.invoice', $order->id) }}"><i class="fa fa-eye"></i></a>
                            @endif
                            <a class="remove_order" data-url="{{route('admin.order_delete', $order->id)}}" href="#"><i class="fa fa-trash"></i></a>
                        </div>
                    </th>
                </tr>
                @endforeach
            </tbody>
        </table>
        {!! $orders->links() !!}
        @else
        <span>You Have No {{$title}}</span>
        @endif
    </div>
 </div>
@endsection
@section('extra_js')
<script>
    $(document).ready(function() {
        $('a.remove_order').on('click', function(e) {
            e.preventDefault()
            var confirm = window.confirm('Sure ?');
            if(confirm) {
                window.location.href = $(this).data('url')
            }
        })
    })
</script>
@endsection
