@extends('layouts.adminapp')
@section('title', 'Edit Legal Page')
@section('extra_css')
<link href="https://cdn.jsdelivr.net/npm/summernote@0.9.0/dist/summernote.min.css" rel="stylesheet">
@endsection
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
    <a href="{{route('admin.legal_pages')}}" class="goback btn btn-danger"><i class="fa fa-arrow-left"></i>Go Back</a>
 </div>
<div class="card card-default color-palette-box admin_product">
    <div class="card-body">
        <form action="{{route('admin.legal_pages_update')}}" method="POST" enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="id" value="{{$page->id}}" />
            <div class="row">
                <div class="mb-3 col-md-9">
                    <label for="title" class="form-label">Title</label>
                    <input type="text" name="title" class="form-control" placeholder="Title" id="title" value="{{$page->title}}">
                </div>
                <div class="mb-3 col-md-9">
                    <label for="slug" class="form-label">Slug</label>
                    <input type="text" name="slug" class="form-control" placeholder="slug" id="slug" value="{{$page->slug}}">
                </div>
                <div class="col-md-2 select">
                    <label for="visibility" class="form-label">Visible</label>
                    <select name="visibility">
                        <option value="0" {{$page->visibility == 0 ? 'selected' : '' }}>NO</option>
                        <option value="1" {{$page->visibility == 1 ? 'selected' : '' }}>YES</option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <textarea rows="100" cols="80" class="ckeditor form-control" id="content" name="content">{{$page->content}}</textarea>
                </div>
            </div>
            <div class="mb-3">
                <button class="btn btn-primary" type="submit">UPDATE</button>
            </div>
        </form>
    </div>
</div>
@endsection
@section('extra_js')
<script src="https://cdn.jsdelivr.net/npm/summernote@0.9.0/dist/summernote.min.js"></script>
<script type="text/javascript">
    $(document).ready(function () {
        $('.ckeditor').summernote({
            height: 900
        });
    });
</script>
@endsection