@extends('layouts.adminapp')
@section('extra_css')
<link href="/vd/sweetalert2/dist/sweetalert2.min.css" rel="stylesheet" type="text/css" />
<script src="/vd/sweetalert2/dist/sweetalert2.min.js" type="text/javascript"></script>
<style>
    div.swal2-select {
        display: none !important;
    }
    label {
        display: block
    }
</style>
@endsection
@section('title', 'HomePage Settings')
@section('content')
<div class="card card-default color-palette-box">
    <div class="card-body">
        @if ( session('success') )
        @verbatim <script>
            $(function() {
                Swal("Saved Successfully !!", "", "success")
            });
        </script> @endverbatim
        @endif
        <form action="{{ route('settings.save') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="row">
                <div class="col-md-12 form-group">
                    <label for="homepage_ctaTitle">CTA Title</label>
                    <input type="text" class="form-control" id="homepage_ctaTitle" name="homepage_ctaTitle" placeholder="homepage_ctaTitle" value="{{$configs['homepage_ctaTitle']}}">
                </div>
                <div class="col-md-12 form-group">
                    <label for="homepage_ctaParagraphHtml">CTA Paragraph Html</label>
                    <textarea class="form-control" name="homepage_ctaParagraphHtml" id="" cols="30" rows="4">{{$configs['homepage_ctaParagraphHtml']}}</textarea>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3 form-group">
                    <label for="homepage_testimonialsEnabled">Testimonials Section Enabled</label>
                    <select name="homepage_testimonialsEnabled" style="width: 100%">
                        <option value='1' {{ $configs['homepage_testimonialsEnabled'] == 1 ? 'selected' : '' }}>YES</option>
                        <option value='0' {{ $configs['homepage_testimonialsEnabled'] == 0 ? 'selected' : '' }}>NO</option>
                    </select>
                </div>
                <div class="col-md-3 form-group">
                    <label for="homepage_faqEnabled">FAQ Section Enabled</label>
                    <select name="homepage_faqEnabled" style="width: 100%">
                        <option value='1' {{ $configs['homepage_faqEnabled'] == 1 ? 'selected' : '' }}>YES</option>
                        <option value='0' {{ $configs['homepage_faqEnabled'] == 0 ? 'selected' : '' }}>NO</option>
                    </select>
                </div>
            </div>

            <button type="submit" class="btn btn-primary">Submit</button>
        </form>
    </div>
</div>
@endsection
@section('extra_js')
<script src="/js/sweetalert2.min.js"></script>
@endsection
