@extends('layouts.adminapp')
@section('title', 'Conn Number')
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
  <a href="{{route('admin.cnumber_insert')}}" class="goback btn btn-danger"><i class="fa fa-plus"></i>Insert Conn Number</a>
</div>
<div class="card card-default color-palette-box">
    @if( session()->has('success') )
    <span class="badge bg-success"> {{session()->get('success')}} </span>
    @endif
    <div class="card-body">
        @if (count($cnumbers) > 0)
        <form method="POST" action="{{route('admin.cnumbers_update')}}">
            @csrf
            <table class="table">
                <thead>
                    <tr>
                        <th scope="col"></th>
                        <th scope="col">Name</th>
                        <th scope="col">Category</th>
                        <th scope="col">Number</th>
                        <th scope="col">Active</th>
                        <th scope="col"></th>
                    </tr>
                </thead>
                <tbody>
                @foreach($cnumbers as $cnumber)
                <tr class="product-table">
                    <td>{{$cnumber->id}}<input type="hidden" name="id[]" value="{{$cnumber->id}}"></td>
                    <td><input class="form-control" type="text" name="name[]" value="{{$cnumber->name}}"></td>
                    <td>
                      <select name="category[]">
                        @foreach($categories as $category)
                        <option value="{{$category->id}}" {{ $category->id == $cnumber->category_id ? 'selected' : '' }}>{{$category->name}}</option>
                        @endforeach
                      </select>
                    </td>
                    <td><input class="form-control" type="text" name="number[]" value="{{$cnumber->number}}"></td>
                    <td>
                      <select name="active[]">
                        <option value="1" {{$cnumber->active == 1 ? 'selected' : ''}}>YES</option>
                        <option value="0" {{$cnumber->active == 0 ? 'selected' : ''}}>NO</option>
                      </select>
                    </td>
                    <td class="actions">
                        <a class="remove_category" data-id="{{$cnumber->id}}" href="#"><i class="edit fa fa-trash"></i></a>
                    </td>
                </tr>
                @endforeach
                </tbody>
            </table>
            <button class="btn btn-primary">Update</button>
        <form>
        @else
       <h3>No Categories</h3>
       @endif
    </div>
 </div>
@endsection
@section('extra_js')
<script>
  $(document).ready(() => {
      $('.remove_category').on('click', function(e) {
        e.preventDefault()
        var confirmA = confirm('Delete Type ?')
        var category_id = $(this).attr('data-id')
        var link = "{{route('admin.cnumber_delete', 0)}}"
        if(confirmA) {
          window.location.href = link.replace('/0', '/'+category_id)
        }
      });
  })
</script>
@endsection
@section('extra_css')
    <style>
      td.title {
        background: #eee;
        width: 100%;
        padding: 7px;
        display: inline-block;
        color: #333;
      }
    </style>
@endsection