<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;

    protected $dates = [
        'created_at',
        'updated_at',
        'payment_date',
    ];

    protected $fillable = [
        'uuid',
        'currency_id',
        'product_id',
        'customer_id',
        'transaction_id',
        'ppl_firstName',
        'ppl_lastName',
        'ppl_email',
        'ppl_country',
        'ppl_account',
        'billing_email',
        'billing_name',
        'subtotal',
        'total',
        'gateway',
        'notes',

        'renewing',
        
        'phone_number',
        'countries',
        'languages',

        'extra_header',
        'extra_footer',
        
        'vod',
        'vod_price',
        'adult',
        'adult_price',
        'fastdelivery',
        'fastdelivery_price',
        'paid',
        'sent',
        'refunded',
        'payment_date',
	'expiredsent'
    ];

    public function connections() {
        return $this->belongsToMany(Connection::class);
    }

    public function product() {
        return $this->belongsTo(Product::class);
    }

    public function currency() {
        return $this->belongsTo(Currency::class);
    }
}
