<?php

namespace App\Jobs;

use App\Mail\SendOrderConfirmation;
use App\Models\Config;
use App\Models\Currency;
use App\Models\Order;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Http;

class NewOrderJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $email, $order_id;

    public function __construct($email, $order_id)
    {
        $this->email = $email;
        $this->order_id = $order_id;
    }
    
    public function handle()
    {
        $order = Order::whereId($this->order_id)->first();
        $currency_id = Config::whereName('currency')->first()->value;
        $currency = Currency::whereId($currency_id)->first();
        $app_notifications = Config::whereName('app_notifications')->first()->value;
        $client_notifications = Config::whereName('client_notifications')->first()->value;
        // Push New Job Notification To OneSignal Application
        if($app_notifications) {
            Http::withoutVerifying()
            ->withHeaders([
                'Authorization' => 'Key '.Config::whereName('oneSignalRestApiKey')->first()->value,
                'Content-Type'  => 'application/json',
	        'accept'        => 'application/json'
            ])->post('https://api.onesignal.com/notifications?c=push', [
                "app_id" => Config::whereName('oneSignalAppId')->first()->value,
                "contents" => [
                    "en" => "[".config('app.name')."]::New_Order"
                ],
                "headings"=> [
                    "en" => $order->total.' '.$currency->code
                ],
                "included_segments" => ["Total Subscriptions"],
                'android_channel_id' => 'e2c8abca-f076-4fae-b03a-df14f202a11c'
            ]);
        }
        // Send Email Comfirmation To The Buyer.
        if($client_notifications) Mail::to($this->email)->send(new SendOrderConfirmation($this->order_id));
    }
}
