let express = require('express')
let axios = require('axios')
let app = express()
let cors = require('cors')

const cheerio = require("cheerio")

app.use(cors())

/**
 * START DINO LIVE;
*/

app.get('/dino/categories_channels', (req, res) => {
    (async () => {
        const response = await axios.post('https://dinoip.tv/getchannels.php', {
           p_name: 'ok',
           action: 'action=get_live_categories'
        }, {
           headers: {
             'Content-Type': 'application/json',
             'Content-Type': 'application/x-www-form-urlencoded',
             'Origin': 'https://dinoip.tv/',
             'Referer': 'https://dinoip.tv/live/',
           }
       })
       return res.json(response.data)
   })()
})

app.get('/dino/category_channel/:id', (req, res) => {
    (async () => {
        const response = await axios.post('https://dinoip.tv/getchannels.php', {
           p_name: 'ok',
           action: 'action=get_live_streams&category_id='+req.params.id
        }, {
           headers: {
             'Content-Type': 'application/json',
             'Content-Type': 'application/x-www-form-urlencoded',
             'Origin': 'https://dinoip.tv/',
             'Referer': 'https://dinoip.tv/live/',
           }
       })
       return res.json(response.data.map( canal => canal.name.trim() ))
   })()
})
/**
 * END DINO LIVE CHANNELS.
 * START DINO MOVIES.
*/
app.get('/dino/categories_movies', (req, res) => {
    (async () => {
        const response = await axios.post('https://dinoip.tv/getchannels.php', {
           p_name: 'ok',
           action: 'action=get_vod_categories'
        }, {
           headers: {
             'Content-Type': 'application/json',
             'Content-Type': 'application/x-www-form-urlencoded',
             'Origin': 'https://dinoip.tv/',
             'Referer': 'https://dinoip.tv/live/',
           }
       })
       return res.json(response.data)
   })()
})

app.get('/dino/category_movie/:id', (req, res) => {
    (async () => {
        const response = await axios.post('https://dinoip.tv/getchannels.php', {
           p_name: 'ok',
           action: 'action=get_vod_streams&category_id='+req.params.id
        }, {
           headers: {
             'Content-Type': 'application/json',
             'Content-Type': 'application/x-www-form-urlencoded',
             'Origin': 'https://dinoip.tv/',
             'Referer': 'https://dinoip.tv/live/',
           }
       })
       return res.json(response.data.map( canal => canal.name.trim() ))
   })()
})
/**
 * END DINO MOVIES.
 * START DINO SERIES.
*/
app.get('/dino/categories_series', (req, res) => {
    (async () => {
        const response = await axios.post('https://dinoip.tv/getchannels.php', {
           p_name: 'ok',
           action: 'action=get_series_categories'
        }, {
           headers: {
             'Content-Type': 'application/json',
             'Content-Type': 'application/x-www-form-urlencoded',
             'Origin': 'https://dinoip.tv/',
             'Referer': 'https://dinoip.tv/live/',
           }
       })
       return res.json(response.data)
   })()
})

app.get('/dino/category_serie/:id', (req, res) => {
    (async () => {
        const response = await axios.post('https://dinoip.tv/getchannels.php', {
           p_name: 'ok',
           action: 'action=get_series&category_id='+req.params.id
        }, {
           headers: {
             'Content-Type': 'application/json',
             'Content-Type': 'application/x-www-form-urlencoded',
             'Origin': 'https://dinoip.tv/',
             'Referer': 'https://dinoip.tv/live/',
           }
       })
       return res.json(response.data.map( canal => canal.name.trim() ))
   })()
})
/**
 * END DINO MOVIES.
 * START DINO SERIES.
*/









/**
 * START TREX;
*/
app.get('/trex/categories', (req, res) => {
    (async () => {
        const response = await axios.get('https://activationpanel.tv/en/live/')
        const html = response.data
        const $ = cheerio.load(html)
        let data = []
        const els = $('div#list>div')
        for (const el of els) {
            const name = $(el).attr('name')
            const url = $(el).find('div.title-serial').find('a').attr('href')
            if( name !== undefined ) data.push({name, url})
        }
  
        return res.json(data)
    })()
})

app.get('/trex/category/:url', (req, res) => {
    let data = []
    return new Promise((resolve, reject) => {
        (async () => {
            let buff = Buffer.from(req.params.url, 'base64')
            let url = buff.toString('ascii')
            const response = await axios.get(url)
            const html = response.data
            const $ = cheerio.load(html)
            const els = $('div#list>div')
            for (const el of els) {
                const name = $(el).attr('name')
                if( name !== undefined ) data.push(name)
            }
            resolve(data)
        })()
      })
      .then(data => {
        return res.json(data)
    })
})


// START SERVER;
const port = process.env.PORT || 3000;
app.listen(port, () => {
    console.log(`Listening on ${port}`);
})