<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice</title>
    <style>
        /* Add your custom CSS styles here */
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f7f7;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 600px;
            margin: 40px auto;
            padding: 20px;
            background-color: #f1f0f0;
            border-radius: 10px;
        }

        h1 {
            color: #333;
        }

        p {
            font-size: 16px;
            line-height: 1.6;
            color: #666;
        }

        .invoice-details {
            margin-top: 5px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        table, th, td {
            border: 1px solid #eee;
        }

        th, td {
            padding: 10px;
            text-align: left;
        }

        th {
            background-color: #183D3D;
        }

        .invoice-total {
            margin-top: 20px;
            text-align: right;
        }

        .thank-you {
            text-align: center;
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 style="font-family: monospace;font-size: 15px">REMINDER</h1>
        <p style="margin: 0;font-family: monospace;color: #3b4340;font-size: 14px;font-weight: 500">Hello <b style="text-transform: uppercase"><?php echo e($order->billing_name); ?></b>.</p>
        <p style="margin: 0;font-family: monospace;color: #3b4340;font-size: 14px;font-weight: 500">We hope you've been enjoying watching tv using our service at <b><a style="color: #b12a62;text-decoration: none" href="<?php echo e(env('APP_URL')); ?>"><?php echo e(config('app.name')); ?></a></b>.</p>
        <p style="margin: 0;font-family: monospace;color: #3b4340;font-size: 14px;font-weight: 500">Your subscription bellow is about to be expired.</p>
        <p style="margin: 0;font-family: monospace;color: #3b4340;font-size: 14px;font-weight: 500">It is the time to renew it, to prevent any future suspensions.</p>
        <p style="margin: 0;font-family: monospace;color: #3b4340;font-size: 14px;font-weight: 500">* After renewing, the new subscription will start from the expiration date.</p>

        <table>
            <thead>
                <tr>
                    <th style="color: white">
                        Order N°
                    </th>
                    <th style="color: white">
                        Expiration date
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td style="color: #333; font-weight: 600;font-size: 15px">
                        #<?php echo e($order->id); ?>

                    </td>
                    <td style="color: #333; font-weight: 600;font-size: 15px">
                        <?php echo e(\Carbon\Carbon::parse($expiration_date)->format('F d, Y')); ?>

                    </td>
                </tr>
            </tbody>
        </table>

        <a style="text-decoration: none!important;font-family: monospace;font-size: 15px;font-weight: 800;color: white;background: #3b7e01;border-radius: 8px;padding: 4px 12px; margin-top: 20px; display: inline-block" href="<?php echo e(route('subscriptions')); ?>">
            RENEW NOW
        </a>

        <p style="margin: 14px 0 0 0;font-family: monospace;color: red;font-size: 14px;font-weight: 500">* In case you extend your subscription RECENTLY, please ignore this email.</p>

    </div>
</body>
</html><?php /**PATH /var/www/buysubtv.com/resources/views/mails/send_expiration.blade.php ENDPATH**/ ?>