@extends('layouts.app')
@section('title', config('app.name').' - '.$title)
@section('description', $description)
@section('content')
@if( $standardCnumbers )
<div id="subscribe">
    <h1>Get the Best IPTV Canada Subscription Plans at Affordable Prices</h1>
    <p>
        Looking for reliable and affordable IPTV subscription plans? Look no further! Our website offers a wide range of IPTV plans with same features and different prices to suit your needs. Whether you're a sports enthusiast or a movie buff, we have the perfect plan for you. <br>
        Plus, with our competitive pricing, you can enjoy the best IPTV services without breaking the bank. Try us out today and see for yourself!
    </p>
    <div class="container">
        <p class="note">* if you wanna watch on multiple devices in the same time, choose the number of devices do you have. </p>
        <p class="note">* You will get separated accounts, each device with its connection details.</p>
        <nav>
            <div class="nav nav-tabs" id="nav-tab" role="tablist">
               @foreach ($standardCnumbers as $standardCnumber)
               <button class="nav-link {{$standardCnumber->id == $standardCnumbers[0]->id ? 'active' : '' }}" id="{{$standardCnumber->id}}-tab" data-bs-toggle="tab" data-bs-target="#nav-{{$standardCnumber->id}}" type="button" role="tab" aria-controls="nav-{{$standardCnumber->id}}" aria-selected="true">{{$standardCnumber->name}}</button>
               @endforeach
            </div>
         </nav>
        <div class="tab-content" id="nav-tabContent">
           @foreach ($standardCnumbers as $standardCnumber)
           <div class="tab-pane {{ $standardCnumbers[0]->id == $standardCnumber->id ? 'show active' : '' }}" id="nav-{{$standardCnumber->id}}" role="tabpanel" aria-labelledby="nav-one-tab">
               <div class="row d-flex justify-content-center text-center">
                  @foreach ($standardCnumber->products as $product)
                  <div class="col-lg-3 col-md-4 col-sm-6">
                     <div class="product-item {{$product->hot == 1 ? 'product_hot' : ''}} animate__animated animate__fadeIn">
                        @if($product->hot == 1)<span class="hot">POPULAR</span>@endif
                        <h2 class="period">{{$product->period}}</h2>
                        @if( $premiumCnumbers )<h2 class="server_type">{{$product->cnumber->category->name}}</h2>@endif
                        <div class="product_price">
                           <span class="price">{{$product->price}}</span>
                           <span class="currency">{{$currency->code}}</span>
                           <span class="old_price">{{number_format($product->price*100/60, 2).''.$currency->symbol}}</span>
                        </div>
                        <ul class="server_infos">
                           <li class="conn_number"><i class="fa fa-check-circle-o"></i>{{$standardCnumber->name}}</li>
                           @if( $product->monthly )
                           <li><i class="fa fa-check"></i>Only <span class="monthly">{{ $product->monthly.$currency->symbol }}</span> a Month</li>
                           @else
                           <li><i class="fa fa-check"></i>No Activation Fees</li>
                           @endif
                           <li><i class="fa fa-check"></i>+17.7k Channels</li>
                           <li><i class="fa fa-check"></i>Up to 14k Series</li>
                           <li><i class="fa fa-check"></i>Up to 44k Movies</li>
                           <li><i class="fa fa-check"></i>CATCH UP | EPG</li>
                           <li><i class="fa fa-check"></i>8k, 4K, Ultra HD and HQ</li>
                           <li><i class="fa fa-check"></i>Anti Freeze System</li>
                           <li><i class="fa fa-check"></i>MAG & Firestick</li>
                           <li><i class="fa fa-check"></i>Smarter & Tvmate APP</li>
                           <li><i class="fa fa-check"></i>Free Support 24/7</li>
                        </ul>
                        <form action="{{route('cart.store')}}" method="POST">
                           @csrf
                           <input type="hidden" name="id" value="{{$product->id}}">
                           @if( $product->in_stock == 1 )
                           <button type="submit" class="order_now_product" href="#">Order Now</button>
                            @else
                            <button disabled class="order_now_product btn btn-disabled" href="#">Not Available</button>
                            @endif
                        </form>
                     </div>
                  </div>
                  @endforeach
               </div>
            </div>
           @endforeach
           <div class="more_than4">
            <h2>You want more than {{$lastStandardCnumber}} connections ?</h2>
            <a class="reach_us" target="_blank" href="{{App\Models\Config::whereName('whatsapp_link')->first()->value.'?text=Hi, I am interesting in more than '.$lastStandardCnumber.' connections plans.'}}">
                <i class="fa fa-whatsapp"></i>
                Send WhatsApp MESSAGE
            </a>
        </div>
        </div>
    </div>
</div>
@endif
@if( $premiumCnumbers)
<div id="subscribe" class="dark_background">
    <h1>PREMIUM SERVER</h1>
    <p>
        Interesting in a service with top notch quality with real 4k picture, you are in the right place, this server comes up with more series and movies in real 4k quality of picture
    </p>
    <div class="container">
        <p class="note">* if you wanna watch on multiple devices in the same time, choose the number of devices do you have. </p>
        <p class="note">* You will get separated accounts, each device with its connection details.</p>
        <nav>
            <div class="nav nav-tabs" id="nav-tab" role="tablist">
               @foreach ($premiumCnumbers as $premiumCnumber)
               <button class="nav-link {{$premiumCnumber->id == $premiumCnumbers[0]->id ? 'active' : '' }}" id="{{$premiumCnumber->id}}-tab" data-bs-toggle="tab" data-bs-target="#nav-{{$premiumCnumber->id}}" type="button" role="tab" aria-controls="nav-{{$premiumCnumber->id}}" aria-selected="true">{{$premiumCnumber->name}}</button>
               @endforeach
            </div>
         </nav>
        <div class="tab-content" id="nav-tabContent">
           @foreach ($premiumCnumbers as $premiumCnumber)
           <div class="tab-pane {{ $premiumCnumbers[0]->id == $premiumCnumber->id ? 'show active' : '' }}" id="nav-{{$premiumCnumber->id}}" role="tabpanel" aria-labelledby="nav-one-tab">
               <div class="row d-flex justify-content-center text-center">
                  @foreach ($premiumCnumber->products as $product)
                  <div class="col-lg-3 col-md-4 col-sm-6">
                     <div class="product-item {{$product->hot == 1 ? 'product_hot' : ''}} animate__animated animate__fadeIn">
                        @if($product->hot == 1)<span class="hot">POPULAR</span>@endif
                        <h2 class="period">{{$product->period}}</h2>
                        @if( $standardCnumbers )<h2 class="server_type">{{$product->cnumber->category->name}}</h2>@endif
                        <div class="product_price">
                           <span class="price">{{$product->price}}</span>
                           <span class="currency">{{$currency->code}}</span>
                           <span class="old_price">{{number_format($product->price*100/60, 2).''.$currency->symbol}}</span>
                        </div>
                        <ul class="server_infos">
                           <li class="conn_number"><i class="fa fa-check-circle-o"></i>{{$premiumCnumber->name}}</li>
                           @if( $product->monthly )
                           <li><i class="fa fa-check"></i>Only <span class="monthly">{{ $product->monthly.$currency->symbol }}</span> a Month</li>
                           @else
                           <li><i class="fa fa-check"></i>No Activation Fees</li>
                           @endif
                           <li><i class="fa fa-check"></i>+22.4k Channels</li>
                           <li><i class="fa fa-check"></i>+125k Movies <br><span style="color: #edf905">( ~ 23k English Movies )</span></li>
                           <li><i class="fa fa-check"></i>+24k Series <br><span style="color: #edf905">( ~ 6k English Series )</span></li>
                           <li><i class="fa fa-check"></i>CATCH UP | EPG</li>
                           <li><i class="fa fa-check"></i>8k, 4K, Ultra HD and HQ</li>
                           <li><i class="fa fa-check"></i>Anti Freeze System</li>
                           <li><i class="fa fa-check"></i>MAG & Firestick</li>
                           <li><i class="fa fa-check"></i>Smarter & Tvmate APP</li>
                           <li><i class="fa fa-check"></i>Free Support 24/7</li>
                        </ul>
                        <form action="{{route('cart.store')}}" method="POST">
                           @csrf
                           <input type="hidden" name="id" value="{{$product->id}}">
                           @if( $product->in_stock == 1 )
                           <button type="submit" class="order_now_product" href="#">Order Now</button>
                            @else
                            <button disabled class="order_now_product btn btn-disabled" href="#">Not Available</button>
                            @endif
                        </form>
                     </div>
                  </div>
                  @endforeach
               </div>
            </div>
           @endforeach
           <div class="more_than4">
            <h2>You want more than {{$lastPremiumCnumber}} connections ?</h2>
            <a class="reach_us" target="_blank" href="{{App\Models\Config::whereName('whatsapp_link')->first()->value.'?text=Hi, I am interesting in more than '.$lastPremiumCnumber.' connections plans [ Premium Server ].'}}">
                <i class="fa fa-whatsapp"></i>
                Send WhatsApp MESSAGE
            </a>
        </div>
        </div>
    </div>
</div>
@endif
@endsection
@section('extra_css')
<style>
</style>
@endsection
@section('extra_js')
<script></script>
@endsection