@extends('layouts.app')
@section('title', config('app.name').' - '.$title)
@section('description', $description)
@section('content')
<div class="container">
    <div id="faq">
        <h2>Frequently Asked Questions</h1>
        <div class="container">
            <div class="accordion accordion-flush" id="accordionFlushExample">
                @foreach ($questions as $key => $value)
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-heading{{$key}}">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapse{{$key}}" aria-expanded="false" aria-controls="flush-collapse{{$key}}">
                            {{$value->question}}
                        </button>
                    </h2>
                    <div id="flush-collapse{{$key}}" class="accordion-collapse collapse" aria-labelledby="flush-heading{{$key}}" data-bs-parent="#accordionFlushExample">
                        <div class="accordion-body">
                            {!!$value->answer!!}
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
@endsection