@extends('layouts.adminapp')
@section('title', 'Posts')
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
  <a href="{{route('admin.post_insert')}}" class="goback btn btn-danger"><i class="fa fa-plus"></i>Insert Post</a>
</div>
<div class="card card-default color-palette-box">
    @if( session()->has('success') )
    <span class="badge bg-success"> {{session()->get('success')}} </span>
    @endif
    <div class="card-body">
       @if (count($posts) > 0)
       <table class="table">
        <thead>
          <tr>
            <th scope="col"></th>
            <th scope="col">Title</th>
            <th scope="col">Visibility</th>
            <th scope="col">Creation Date</th>
            <th scope="col"></th>
          </tr>
        </thead>
        <tbody>
        @foreach($posts as $post)
          <tr class="product-table">
            <td>{{$post->id}}</td>
            <td class="title">{{ $post->title }}</td>
            <td>
              <span class="badge bg-{{$post->visibility == '1' ? 'success' : 'warning'}}">
                {{$post->visibility == '1' ? 'Visible' : 'Draft'}}
              </span>
            </td>
            <td>{{$post->created_at}}</td>
            <td class="actions">
              <a target="_blank" href="{{route('post', $post->slug)}}"><i class="view fa fa-eye"></i></a>
              <a href="{{route('admin.post_edit', $post->id)}}"><i class="edit fa fa-pencil"></i></a>
              <a class="remove_prod" data-id="{{$post->id}}" href="#"><i class="edit fa fa-trash"></i></a>
            </td>
          </tr>
        @endforeach
        </tbody>
      </table>
       @else
       <h3>No Posts</h3>
       @endif
    </div>
 </div>
@endsection
@section('extra_js')
<script>
  $(document).ready(() => {
    $(".card-body>.badge.bg-success").fadeTo(2000, 500).slideUp(500, function(){
          $(".card-body>.badge.bg-success").slideUp(500);
      });
      $('.remove_prod').on('click', function(e) {
        e.preventDefault()
        var confirmA = confirm('Delete The Post ?')
        var product_id = $(this).attr('data-id')
        var link = "{{route('admin.post_delete', 0)}}"
        if(confirmA) {
          window.location.href = link.replace('/0', '/'+product_id)
        }
      });
  })
</script>
@endsection

@section('extra_css')
    <style>
td.title {
  background: #eee;
  width: 100%;
  display: inline-block;
  color: #333;
  padding: 19px 20px;
}
span.badge.bg-success {
  padding: 4px 7px;
}
    </style>
@endsection