@extends('layouts.adminapp')
@section('title', 'Insert New Post')
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
    <a href="{{route('admin.posts')}}" class="goback btn btn-danger"><i class="fa fa-arrow-left"></i>Go Back</a>
 </div>
<div class="card card-default color-palette-box admin_product">
    <div class="card-body">
        <form action="{{route('admin.post_save')}}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="row">
                <div class="mb-3 col-md-6">
                    <label for="title" class="form-label">Title</label>
                    <input type="text" name="title" class="form-control" placeholder="Title" id="title">
                </div>
                <div class="col-md-3 mb-3">
                    <label for="icon" class="form-label">Icon</label>
                    <input type="file" class="form-file-input form-control" name="icon" id="icon">
                </div>
                <div class="col-md-2 select">
                    <label for="visibility" class="form-label">Visible</label>
                    <select name="visibility">
                        <option value="0" selected>NO</option>
                        <option value="1">YES</option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <textarea class="ckeditor form-control" name="content"></textarea>
                </div>
            </div>
            <div class="mb-3">
                <button class="btn btn-primary" type="submit">INSERT</button>
            </div>
        </form>
    </div>
</div>
@endsection
@section('extra_js')
<script src="https://cdn.tiny.cloud/1/1myqqd4uzxe0t2cpjbwcdsliy3uulejtffum3c0jiacmkbvx/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
<script>tinymce.init({selector:'textarea'});</script>
@endsection