@extends('layouts.adminapp')
@section('title', 'Edit Post')
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
    <a href="{{route('admin.posts')}}" class="goback btn btn-danger"><i class="fa fa-arrow-left"></i>Go Back</a>
 </div>
<div class="card card-default color-palette-box admin_product">
    <div class="card-body">
        <form action="{{route('admin.post_update')}}" method="POST" enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="id" value="{{$post->id}}">
            <div class="row">
                <div class="mb-3 col-md-9">
                    <label for="title" class="form-label">Title</label>
                    <input type="text" name="title" class="form-control" placeholder="Title" id="title" value="{{$post->title}}">
                </div>
                <div class="col-md-3 mb-3">
                    <label for="icon" class="form-label">Icon</label>
                    <input type="file" class="form-file-input form-control" name="icon" id="icon">
                </div>
                <div class="mb-3 col-md-9">
                    <label for="slug" class="form-label">Slug</label>
                    <input type="text" name="slug" class="form-control" placeholder="slug" id="slug" value="{{$post->slug}}">
                </div>
                <div class="col-md-2 select">
                    <label for="visibility" class="form-label">Visible</label>
                    <select name="visibility">
                        <option value="1" {{ $post->visibility == '1' ? 'selected' : '' }}>YES</option>
                        <option value="0" {{ $post->visibility == '0' ? 'selected' : '' }}>NO</option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <textarea rows="60" class="ckeditor form-control" name="content">{{$post->content}}</textarea>
                </div>
            </div>
            <div class="mb-3">
                <button class="btn btn-primary" type="submit">UPDATE</button>
            </div>
        </form>
    </div>
</div>
@endsection
@section('extra_css')

@endsection
@section('extra_js')
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script type="text/javascript">
    $(document).ready(function () {
        $('.ckeditor').ckeditor();
    });
</script>
@endsection