@extends('layouts.adminapp')
@section('title', 'Legal Pages')
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
  <a href="{{route('admin.legal_pages_insert')}}" class="goback btn btn-danger"><i class="fa fa-plus"></i>Insert New Legal Page</a>
</div>
<div class="card card-default color-palette-box">
    @if( session()->has('success') )
    <span class="badge bg-success"> {{session()->get('success')}} </span>
    @endif
    <div class="card-body">
       @if (count($pages) > 0)
       <table class="table">
        <thead>
          <tr>
            <th scope="col"></th>
            <th scope="col">Title</th>
            <th scope="col">Visibility</th>
            <th scope="col">Creation Date</th>
            <th scope="col"></th>
          </tr>
        </thead>
        <tbody>
        @foreach($pages as $page)
          <tr class="product-table">
            <td>#{{$page->id}}</td>
            <td class="title"><a href="{{route('admin.legal_pages_edit', $page->id)}}">{{$page->title}}</a></td>
            <td>
              <span class="badge bg-{{$page->visibility == '1' ? 'success' : 'warning'}}">
                {{$page->visibility == '1' ? 'Visible' : 'Draft'}}
              </span>
            </td>
            <td>{{$page->created_at}}</td>
            <td class="actions">
              <a target="_blank" href="{{route('page', $page->slug)}}"><i class="view fa fa-eye"></i></a>
              <a href="{{route('admin.legal_pages_edit', $page->id)}}"><i class="edit fa fa-pencil"></i></a>
              <a class="remove_page" data-id="{{$page->id}}" href="#"><i class="edit fa fa-trash"></i></a>
            </td>
          </tr>
        @endforeach
        </tbody>
      </table>
       @else
       <h3>No Pages</h3>
       @endif
    </div>
 </div>
@endsection
@section('extra_js')
<script>
  $(document).ready(() => {
    $(".card-body>.badge.bg-success").fadeTo(2000, 500).slideUp(500, function(){
          $(".card-body>.badge.bg-success").slideUp(500);
      });
      $('.remove_page').on('click', function(e) {
        e.preventDefault()
        var confirmA = confirm('Delete The Page ?')
        var product_id = $(this).attr('data-id')
        var link = "{{route('admin.legal_pages_delete', 0)}}"
        if(confirmA) {
          window.location.href = link.replace('/0', '/'+product_id)
        }
      });
  })
</script>
@endsection

@section('extra_css')
    <style>

    </style>
@endsection