<?php

namespace Database\Seeders;

use App\Models\Post;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\File;

class PostSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        File::copy(public_path('images/how_to_install/buzztv-xr-4000/icon.png'), 'storage/app/public/buzztv-xr-4000_icon.png');
        Post::create([
            'title' => 'BuzzTV XR 4000',
            'slug' => 'buzztv-xr-4000',
            'icon' => 'buzztv-xr-4000_icon.png',
            'content' => '<p>BuzzTV XR 4000 Series TV box is an android iptv cable box. It&rsquo;s compatible with both MAC address and m3u link</p><p>So it&rsquo;s a versatile tv box which is easy to use</p><p>here is the tutorial of how to setup iptv on it</p><p>1. Go to<strong>&nbsp;Live TV&nbsp;</strong>section</p><p><img alt="" src="'.asset('images/how_to_install/buzztv-xr-4000/1.webp').'" /></p><p>2. From there, you can see 2 options to activate IPTV:&nbsp;<strong>Streaming Line</strong>&nbsp;and<strong>&nbsp;M3U</strong>, you can choose one of these 2 options, but we most&nbsp;<strong>recommend using m3u</strong></p><p>3. If you choose<strong>&nbsp;Streaming line&nbsp;</strong>which requires you to provide the mac address to us, then we will activate your mac address and send you a&nbsp;<strong>portal url</strong>&nbsp;in return.</p><p><img alt="" src="'.asset('images/how_to_install/buzztv-xr-4000/2.webp').'" /></p><p><img alt="" src="'.asset('images/how_to_install/buzztv-xr-4000/3.webp').'" /></p><p>4. If you choose&nbsp;<strong>M3U&nbsp;</strong>option which is more convenient, just enter the m3u link from us</p><p><img alt="" src="'.asset('images/how_to_install/buzztv-xr-4000/4.webp').'" /></p><p><img alt="" src="'.asset('images/how_to_install/buzztv-xr-4000/5.webp').'" /></p>',
            'visibility' => 1,
        ]);

        File::copy(public_path('images/how_to_install/flix-iptv/icon.png'), 'storage/app/public/flix-iptv_icon.png');
        Post::create([
            'title' => 'Flix IPTV',
            'slug' => 'flix-iptv',
            'icon' => 'flix-iptv_icon.png',
            'content' => '<p>1. You need to buy an activation for your Flix IPTV app from its offical website https://flixiptv.eu/activation</p><p>2. Open this app, &nbsp;In the left-hand menu, navigate to&nbsp;Settings.&nbsp;</p><p><img alt="" src="'.asset('images/how_to_install/flix-iptv/1.webp').'"/></p><p>3.&nbsp;On the following menu, scroll down to User Account.</p><p><img alt="" src="'.asset('images/how_to_install/flix-iptv/2.webp').'"/></p><p>4.&nbsp;On the User Account screen, take note of the&nbsp;Mac address.</p><p><img alt="" src="'.asset('images/how_to_install/flix-iptv/3.webp').'" /></p><p>5.&nbsp;Open a web browser on your desktop or phone and navigate to the following address:&nbsp;<strong>https://flixiptv.eu/mylist</strong></p><p>This Flix page will ask you to fill in the&nbsp;<strong>Mac address</strong>&nbsp;and&nbsp;<strong>URL link</strong>&nbsp;for the IPTV service. if you subscribe to our IPTV service, we will send login details and a m3u link, please upload the m3u to on this page&nbsp;<strong>https://flixiptv.eu/mylist</strong></p><p>6.&nbsp;After adding the information, click the&nbsp;Send&nbsp;button and you are good to go.</p><p><img alt="" src="'.asset('images/how_to_install/flix-iptv/4.webp').'" /></p><p>7. Open Flix IPTV on your FireStick and you will see the connected IPTV provider in the app.</p><p><img alt="" src="'.asset('images/how_to_install/flix-iptv/5.webp').'" /></p><h2>About Parental control over app Flix IPTV</h2><p>Parental control: Block your children&rsquo;s access to adult content by setting up Parental control in the app, under Settings. The default password for parental control is 0000.</p><p><strong>( Our Server Don&#39;t Offer Adult Content BTW, but just to be informed if you are using another subscription&nbsp;)</strong></p><p><strong><img alt="" src="'.asset('images/how_to_install/flix-iptv/6.webp').'" /></strong></p>',
            'visibility' => 1,
            ]);


        File::copy(public_path('images/how_to_install/net-iptv/icon.png'), 'storage/app/public/net-iptv_icon.png');
        Post::create([
            'title' => 'NET IPTV',
            'slug' => 'net-iptv',
            'icon' => 'net-iptv_icon.png',
            'content' => '<p>1. Find Mac address. Open application and you can see the MAC address , If not , navigate to info ( by pressing RED button usually )</p><p><img alt="" src="'.asset('images/how_to_install/net-iptv/1.webp').'" /></p><p>Upload M3u link via portal- Open app upload page via browser : http://netiptv.eu/Upload</p><p>2. Enter your &nbsp;mac address &nbsp;in MAC / APP ID field under UPLOAD m3U/URL row, &nbsp;Then press Add List</p><p><img alt="" src="'.asset('images/how_to_install/net-iptv/2.webp').'" /></p><p>3. Enter m3u link and update- Enter The m3u link you received from provider in&nbsp;URL1&nbsp;field</p><p>Click&nbsp;Update List</p><p>Done</p><p>You need back to net IPTV app and press&nbsp;number 0&nbsp;on the remote control to reload the list.</p><p><img alt="" src="'.asset('images/how_to_install/net-iptv/3.webp').'" /></p>',
            'visibility' => 1,
        ]);

        File::copy(public_path('images/how_to_install/smarters/icon.png'), 'storage/app/public/smarters_icon.png');
        Post::create([
            'title' => 'IPTV SMARTERS ( ALL DEVICES )',
            'slug' => 'iptv-smarters-app',
            'icon' => 'smarters_icon.png',
            'content' => '<p>To setup <strong>IPTV Smarters pro app</strong> for :</p><p>+ android and firestick devices or any android tv box device,&nbsp;here is the official download link :&nbsp;<a target="_blank" href="https://iptvsmarters.com/smarters.apk">https://iptvsmarters.com/smarters.apk</a></p><p>+ <strong>iOS</strong><strong>&nbsp;</strong>is avaliable on app store : <a target="_blank" href="https://apps.apple.com/in/app/smarters-player-lite/id1628995509">https://apps.apple.com/in/app/smarters-player-lite/id1628995509</a></p><p>+ <strong>macBook </strong>iOs here is the download link :&nbsp;<a target="_blank" href="https://www.iptvsmarters.com/IPTVSmartersPro-1.1.1.dmg">https://www.iptvsmarters.com/IPTVSmartersPro-1.1.1.dmg</a></p><p>+ <strong>Windows </strong>:&nbsp;<a target="_blank" href="https://www.iptvsmarters.com/IPTVSmartersPro-Setup-1.1.1.exe">https://www.iptvsmarters.com/IPTVSmartersPro-Setup-1.1.1.exe</a></p><p><img alt="" src="'.asset('images/how_to_install/smarters/1.webp').'" /></p><p>all you need to do is head over to the google play store (in case of Android device) and App store (in case you are using an Apple device). Now, just follow the steps mentioned below.</p><p><strong>Step 1:</strong>&nbsp;open the IPTV Smarters Pro app and click on the &ldquo;add new user&rdquo;.</p><p><strong>Step 2:</strong> Now, you need to login into the app. There are two ways to do so. Either by using M3U playlist or by using the username and password that is the Xtream codes API.</p><p>The username and password can be found by looking at the URL we provide to you when you make a purchase. If you do not have/know the necessary details, please contact us by using the page up above or by using our whatsapp.</p><p><strong>Step 4: </strong>Once you are done logging in, you will be redirected to the list users screen as shown below. Click on the profile you just created.</p><p><strong>Step 5:</strong> Congratulations, you have now successfully set up and configured the IPTV Smarters Pro app on your devices.</p>',
            'visibility' => 1,
        ]);

        File::copy(public_path('images/how_to_install/firestick-tivimate/icon.png'), 'storage/app/public/firestick-tivimate_icon.png');
        Post::create([
            'title' => 'Firestick ( TiviMate Application )',
            'slug' => 'firestick-tivimate',
            'icon' => 'firestick-tivimate_icon.png',
            'content' => '<h2>What Is TiviMate?</h2><p>Don&rsquo;t confuse TiviMate with an IPTV provider. TiviMate is an IPTV player that allows you to integrate third-party IPTV services with M3U links, Xtream codes, and Stalker Portal (we&rsquo;ll discuss each of these later in the article). You can&rsquo;t simply download TiviMate on a compatible device and watch TV channels or movies. You need an IPTV service that supports one of the three integration methods I mentioned.</p><p>So, first, we will download TiviMate on FireStick, and then we&rsquo;ll use our IPTV service ( details should be sent to your email after you subscribe&nbsp;) to enable the player&rsquo;s capabilities. TiviMate offers a premium version as well. If you decide you&rsquo;re going to use TiviMate regularly, I advise shelling out a few bucks for the advanced features.</p><p><strong>Didn&#39;t have your details yet, <a target="_blank" href="'.route("subscriptions").'">subscribe now</a>.</strong></p><p>So, first, we will download TiviMate on FireStick, and then we&rsquo;ll use an IPTV service to enable the player&rsquo;s capabilities. TiviMate offers a premium version as well. If you decide you&rsquo;re going to use TiviMate regularly, I advise shelling out a few bucks for the advanced features.</p><h2>How to Install TiviMate on FireStick</h2><p>TiviMate isn&rsquo;t officially available from the Amazon App Store. Users will have to rely on sideloading to install the app on their devices.</p><p>I&rsquo;ve separated the sideloading steps into three parts to make it easier to follow along. First, we&rsquo;ll need to get the Downloader app on the FireStick. Then, we&rsquo;ll make necessary changes in our Fire TV settings. Finally, we&rsquo;ll be able to download TiviMate APK with Downloader.</p><p>Go through all three parts below to get TiviMate on FireStick.</p><h3>#1 Get Downloader on FireStick:</h3><p><strong>1.</strong>&nbsp;Open the FireStick home screen.</p><p><strong>2.</strong>&nbsp;Go to the&nbsp;<strong>Find</strong>&nbsp;menu.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/1.webp').'" /></p><p><strong>3.</strong>&nbsp;Select&nbsp;<strong>Search</strong>&nbsp;at the top.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/2.webp').'" /></p><p><strong>4.</strong>&nbsp;It will open a virtual keyboard on your FireStick.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/3.webp').'" /></p><p><strong>5.</strong>&nbsp;Start to type&nbsp;<strong>Downloader</strong>. Select&nbsp;<strong>Downloader</strong>&nbsp;when it shows up among the suggestions below the keyboard.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/4.webp').'" /></p><p><strong>6.</strong>&nbsp;Select the&nbsp;<strong>Downloader</strong>&nbsp;app, which you can recognize by its orange background. Then, on the following screen, select&nbsp;the&nbsp;<strong>Get</strong>&nbsp;or&nbsp;<strong>Download</strong>&nbsp;button.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/5.webp').'" /></p><p>It will take a minute to install the Downloader app on your FireStick. Before you open the Downloader app to install TiviMate APK, you need to make changes in the FireStick settings menu. Otherwise, you will receive errors during installation.</p><h3>#2 Change FireStick Settings</h3><p><strong>1.</strong>&nbsp;Press the&nbsp;<strong>home button</strong>&nbsp;on your FireStick remote.</p><p><strong>2.</strong>&nbsp;Go to the&nbsp;<strong>settings gear</strong>&nbsp;on the far right.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/6.webp').'" /></p><p><strong>3.</strong>&nbsp;Scroll down and select&nbsp;<strong>My Fire TV</strong>.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/7.webp').'" /></p><p><strong>4.</strong>&nbsp;Choose&nbsp;<strong>Developer Options</strong>.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/8.webp').'" /></p><p><strong>5.</strong>&nbsp;Find&nbsp;<strong>Apps from Unknown Sources</strong>. By default, it&rsquo;s off. Select it to turn it&nbsp;<strong>ON</strong>.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/9.webp').'" /></p><p>Now you can comfortably sideload any app installation file (APK) on the FireStick without any issue. Follow the steps below to install TiviMate APK on the FireStick using the Downloader app.</p><h3>#3 Use Downloader to Install TiviMate on FireStick</h3><p><strong>1.</strong>&nbsp;Go to the&nbsp;<strong>Apps</strong>&nbsp;menu from the FireStick home.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/10.webp').'" /></p><p><strong>2.</strong>&nbsp;Open the&nbsp;<strong>Downloader</strong>&nbsp;app and select the&nbsp;<strong>Enter a URL</strong>&nbsp;box on the home screen.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/11.webp').'" /></p><p><strong>3.</strong>&nbsp;It will open a virtual keyboard. Type&nbsp;<strong>https://tivimates.com/tiviapk</strong>&nbsp;and hit&nbsp;<strong>Go</strong>&nbsp;at the bottom.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/12.webp').'" /></p><p><strong>4.&nbsp;</strong>Downloader will install the latest TiviMate APK onto your FireStick. It&rsquo;s about 11MB.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/13.webp').'" /></p><p><strong>5.</strong>&nbsp;Click&nbsp;<strong>Install</strong>&nbsp;when prompted.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/14.webp').'" /></p><p><strong>6.&nbsp;</strong>After installation,&nbsp;<strong>Delete</strong>&nbsp;the APK from your device.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/15.webp').'" /></p><h2>Setup Our Subscription :</h2><p>now tivimate iptv player is installed successfully, what you have to do now after you get subscribed&nbsp;is to :</p><p><strong>1.</strong>&nbsp;Press and hold the&nbsp;<strong>home button&nbsp;</strong>on your FireStick remote.</p><p><strong>2.</strong>&nbsp;Select&nbsp;<strong>Apps&nbsp;</strong>on the following screen.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/16.webp').'" /></p><p><strong>3.</strong>&nbsp;Open the&nbsp;<strong>TiviMate</strong>&nbsp;app.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/17.webp').'" /></p><p><strong>4.</strong>&nbsp;Select&nbsp;<strong>Add playlist</strong>.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/18.webp').'" /></p><p><strong>5.</strong>&nbsp;TiviMate will ask you to add a playlist using an M3U link, Xtream code, or Stalker Portal. Select the&nbsp;<strong>M3U playlist</strong>.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/19.webp').'" /></p><p>In this article, we will use an M3U link to play an IPTV service in the TiviMate app. When you&nbsp;<strong>subscribe</strong>&nbsp;to our IPTV service, you will&nbsp;<strong>receive an email</strong>&nbsp;with&nbsp; both&nbsp;<strong>XTREAM CODES API</strong>&nbsp;information and an&nbsp;<strong>M3U link</strong>. If you don&rsquo;t get an M3U link.</p><p>Now that you have identified your M3U link that it shoule be like this</p><pre>
<strong>http://xxxx.xxxx.org/get.php?username=TEST8877c&password=TEST8877&type=m3u_plus&output=ts</strong></pre><p>let&rsquo;s proceed with integration.</p><p><strong>6.</strong>&nbsp;TiviMate will ask for your M3U link. Enter your&nbsp;<strong>M3U link&nbsp;</strong>and press&nbsp;<strong>Next</strong>.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/20.webp').'" /></p><p><strong>7.&nbsp;</strong>TiviMate will load the IPTV service and offer a peek at the number of channels and movies available in the IPTV package.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/21.webp').'" /></p><p><strong>8.</strong>&nbsp;Add a&nbsp;<strong>Playlist name</strong>.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/22.webp').'" /></p><p><strong>9.&nbsp;</strong>If the playlist is finished processing, select&nbsp;<strong>Done</strong>.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/23.webp').'" /></p><p>A minute or two later, you will see the IPTV service&rsquo;s content appearing in the TiviMate app.</p><p>Most IPTV services come with a dedicated EPG (electronic program guide), as shown below.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/24.webp').'" /></p><p>If you don&rsquo;t see an EPG enabled in the TiviMate app, consider enabling it in the app&rsquo;s&nbsp;<strong>Settings</strong>.</p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/25.webp').'" /></p><p><img alt="" src="'.asset('images/how_to_install/firestick-tivimate/26.webp').'" /></p><p>As I mentioned above, the major features of TiviMate are behind a paywall. You need to pay for the premium version to enjoy TiviMate at its greatest potential.</p><p>When you try to access any premium feature without a premium account, TiviMate will ask you to upgrade to premium. For example, when you try to add a channel to your list of favorites, TiviMate will prompt you to upgrade the app. If you wish to continue with the free version, you can hit Cancel and keep using the free TiviMate app on FireStick.</p><p>To purchase the premium version, you need to use the TiviMate Companion app from the Google Play Store. Here&rsquo;s how to do it.</p>',
            'visibility' => 1
        ]);

        File::copy(public_path('images/how_to_install/firestick-smarters/icon.png'), 'storage/app/public/firestick-smarters_icon.png');
        Post::create([
            'title' => 'Firestick ( Smarters Application )',
            'slug' => 'firestick-smarters',
            'icon' => 'firestick-smarters_icon.png',
            'content' => '<p>First of all you need to enable developer options on your firestick :</p><p><strong>1.</strong>&nbsp;Select FireStick&nbsp;<strong>Settings.</strong></p><p><img alt="firestick settings" src="'.asset('images/how_to_install/firestick-smarters/1.jpg').'" style="height:540px; width:960px"/></p><p><strong>2.</strong>&nbsp;Click&nbsp;<strong>My Fire TV.</strong></p><p><img alt="apps from unknown sources firestick" src="'.asset('images/how_to_install/firestick-smarters/2.webp').'" style="height:540px; width:960px"/></p><p><strong>3.</strong>&nbsp;Click&nbsp;<strong>About</strong>&nbsp;(only if you&nbsp;<strong>DO NOT</strong>&nbsp;see Developer Options on this screen).</p><p><img alt="How to install 3rd party apps on FireStick" src="'.asset('images/how_to_install/firestick-smarters/3.webp').'" style="height:459px; width:960px"/></p><p><strong>4.</strong>&nbsp;Click on your&nbsp;<strong>Fire TV Stick&nbsp;</strong>quickly&nbsp;<strong>7</strong>&nbsp;times.</p><p><img alt="How to get Developer options on Firestick" src="'.asset('images/how_to_install/firestick-smarters/4.webp').'" style="height:540px; width:960px"/></p><p><strong>5.</strong>&nbsp;You will see a notification at the bottom saying&nbsp;<strong>No need, you are already a developer.&nbsp;</strong>That&rsquo;s it, you have enabled Developer Options.</p><p><img alt="notification at the bottom" src="'.asset('images/how_to_install/firestick-smarters/5.webp').'" style="height:540px; width:960px"/></p><p><strong>6.</strong>&nbsp;Press the back button once or go back to&nbsp;<strong>Settings</strong>&nbsp;&gt;&nbsp;<strong>My Fire TV&nbsp;</strong>and you will now see Developer Options.</p><p><img alt="amazon removes developer options on fire stick" src="'.asset('images/how_to_install/firestick-smarters/6.webp').'" style="height:540px; width:960px"/></p><p>Now you can go into Developer Options and enable Apps from Unknown Sources to sideload APKs on your FireStick device.</p><h2><strong>How to Install IPTV Smarters Pro on FireStick</strong></h2><p>the Amazon Store does not host <strong>IPTV Smarters Pro</strong>. Therefore, it must be sideloaded if you want it on your FireStick.</p><p>We will download the IPTV Smarters APK using the Downloader app. This app will help you sideload IPTV Smarter on FireStick (because browser downloads are not allowed)</p><p>So, we must have a Downloader on FireStick. Then, we need to enable permission for the app to install APK files. Here are the quick steps:</p><p><strong>1.</strong>&nbsp;Click the&nbsp;<strong>Magnifying Glass &gt; Search</strong>&nbsp;option on the home screen of FireStick. Type the name of the app (which is&nbsp;<strong>Downloader</strong>). Click the&nbsp;<strong>Downloader</strong>&nbsp;option when it is displayed in the search results.</p><p><img alt="find-search" src="'.asset('images/how_to_install/firestick-smarters/7.jpg').'" style="height:540px; width:960px"/></p><p>Choose the&nbsp;<strong>Downloader</strong>&nbsp;icon on the following screen and download and install the app.</p><p><img alt="How to Install IPTV Smarters Pro on FireStick" src="'.asset('images/how_to_install/firestick-smarters/8.jpg').'" style="height:540px; width:960px"/></p><p><strong>2.</strong>&nbsp;Click&nbsp;<strong>Settings</strong>. Next, please choose the option My Fire TV.&nbsp;When the following options are displayed on the next screen, click&nbsp;<strong>Developer options</strong>.</p><p>After that, select&nbsp;<strong>Install from unknown apps</strong>. Enable&nbsp;<strong>Downloader</strong>&nbsp;to change the status to&nbsp;<strong>ON</strong>.</p><p><img alt="enable downloader" src="'.asset('images/how_to_install/firestick-smarters/9.jpg').'"/></p><p>With this, you have configured the FireStick settings to allow the installation of IPTV Smarters and other third-party apps.</p><h3>Sideload IPTV Smarters Pro APK</h3><p>Here are the steps:</p><p><strong>1.&nbsp;</strong>Open the&nbsp;<strong>Downloader&nbsp;</strong>app.</p><p>On this screen, you need to click the URL textbox on the right side (make sure the&nbsp;<strong>Home</strong>&nbsp;option in the left menu is selected).</p><p><em><strong>Note:</strong>&nbsp;A set of prompts will appear when you run this app for the first time.&nbsp;<strong>Dismiss</strong>&nbsp;them until you see the following screen.</em></p><p><img alt="iptv smarters firestick" src="'.asset('images/how_to_install/firestick-smarters/10.jpg').'" style="height:540px; width:960px"/></p><p><strong>2.</strong>&nbsp;Go ahead and enter the following path on this window:&nbsp;<strong>firesticktricks.com/smarter</strong>. Next, click&nbsp;<strong>GO</strong>.</p><p><em><strong>Note:</strong>&nbsp;FireStickTricks does not host this URL. It is a shortcut and redirects to another URL on an external server.</em></p><p><em><strong>Note:</strong>&nbsp;FireStickTricks does not host this URL. It is a shortcut and redirects to another URL on an external server.</em></p><p><img alt="iptv smarters apk firestick" src="'.asset('images/how_to_install/firestick-smarters/11.png').'" style="height:540px; width:960px"/></p><p><strong>3.</strong>&nbsp;Give it a minute or two until the IPTV Smarter is downloaded onto your FireStick device.</p><p><img alt="iptv smarters pro" src="'.asset('images/how_to_install/firestick-smarters/12.jpg').'" style="height:273px; width:960px"/></p><p><strong>4.</strong>&nbsp;When the download has been completed, the Downloader app will run the APK file, and the installation will start. Click&nbsp;<strong>Install</strong>.</p><p><img alt="how to install iptv smarters pro on firestick" src="'.asset('images/how_to_install/firestick-smarters/13.jpg').'" style="height:540px; width:960px"/></p><p><strong>5.</strong>&nbsp;Wait for the installation to finish.</p><p><img alt="installing iptv smarters pro" src="'.asset('images/how_to_install/firestick-smarters/14.jpg').'" style="height:540px; width:960px"/></p><p><strong>6.</strong>&nbsp;Installation is concluded with the&nbsp;<strong>app installed</strong>&nbsp;notification. You may now choose to click OPEN and get started with IPTV Smarters.</p><p>I recommend choosing&nbsp;<strong>DONE</strong>&nbsp;so you may first delete the APK file and save some space on the FireStick storage.</p><p><img alt="click on done button" src="'.asset('images/how_to_install/firestick-smarters/15.jpg').'" style="height:540px; width:960px"/></p><p><strong>7.</strong>&nbsp;If you click&nbsp;<strong>DONE</strong>&nbsp;above, you will return to the Downloader interface. Click&nbsp;<strong>Delete</strong>.</p><p><img alt="delete iptv smarters pro apk files" src="'.asset('images/how_to_install/firestick-smarters/16.jpg').'" style="height:283px; width:960px"/></p><p><strong>8.</strong>&nbsp;Again, click&nbsp;<strong>Delete</strong>.</p><p><img alt="click on delete button" src="'.asset('images/how_to_install/firestick-smarters/17.jpg').'" style="height:264px; width:960px"/></p><p>Great! You now have the IPTV Smarters app on FireStick.</p><p>&nbsp;</p><h2><strong>How to Use IPTV Smarters on FireStick</strong></h2><p>Before you launch IPTV Smaters, create its shortcut for easy access. Go to&nbsp;<strong>IPTV Smarters</strong>. Then, Press the&nbsp;<strong>Menu</strong>&nbsp;button on the remote (3-line button). Next, click&nbsp;<strong>Move</strong>&nbsp;on the screen in the popup menu on the bottom right. Now, you can move the icon to the top shelf.</p><p><img alt="How to Use IPTV Smarters on FireStick" src="'.asset('images/how_to_install/firestick-smarters/18.jpg').'" style="height:540px; width:960px"/></p><p>As I said before, IPTV Smarters DOES NOT have any channels of its own. It is a facilitator that lets you stream channels you can access through the IPTV service providers. Therefore, to use IPTV Smarters, you must have subscribed to at least one IPTV service.</p><p>When you run the IPTV Smarters app for the first time, the&nbsp;<em>Terms of Use</em>&nbsp;will be the first window. Scroll down and click&nbsp;<strong>Accept.</strong></p><p><img alt="click on accept button" src="'.asset('images/how_to_install/firestick-smarters/19.jpg').'" style="height:540px; width:960px"/></p><p>This is the window that you land on next. You must start by clicking&nbsp;<strong>ADD USER</strong>&nbsp;in the top-right corner or&nbsp;<strong>ADD NEW USER</strong>&nbsp;in the middle of the screen.</p><p><img alt="select add new user" src="'.asset('images/how_to_install/firestick-smarters/20.jpg').'" style="height:540px; width:960px"/></p><p>click&nbsp;<strong>Login with Xtream Codes API,</strong>&nbsp;here is the window where you can enter your details:</p><p><img alt="how to install iptv smarters pro on firestick" src="'.asset('images/how_to_install/firestick-smarters/21.jpg').'" style="height:540px; width:960px"/></p><p>Then you just need to put the details sent vial Email, if you didn&#39;t subscribe yet, here is the link to subscribe -&gt;&nbsp;<strong><a target="_blank" href="'.route('subscriptions').'">Click Here</a></strong></p><p>&nbsp;</p><div id="gtx-trans" style="position: absolute; left: -65px; top: 43.4px;"> <div class="gtx-trans-icon">&nbsp;</div></div>',
            'visibility' => 1
        ]);

        File::copy(public_path('images/how_to_install/computer-laptop/icon.png'), 'storage/app/public/computer-laptop_icon.png');
        Post::create([
            'title' => 'WINDOWS 10/11',
            'slug' => 'windows-1011',
            'icon' => 'computer-laptop_icon.png',
            'content' => '<p> Download Smarters application from this link : <strong><a href="https://www.iptvsmarters.com/IPTVSmartersPro-Setup-1.1.1.exe">Click Here</a></strong> </p><p> <br/> </p><p> <img src="'.asset('images/how_to_install/computer-laptop/1.png').'"/><br/> </p><p> <br/> </p><p> 1. Put any name you want. </p><p> 2. put the username you got under Xtream Codes API, if you still don\'t have your subscription yet, you can get one here :&nbsp;<a href="'.route('subscriptions').'">'.route('subscriptions').'</a> </p><p> 3. put the password you got vial email, you will find it under&nbsp;Xtream Codes API. </p><p> 4.&nbsp;put the URL you got vial email, you will find it under&nbsp;Xtream Codes API. </p><p style="" class=""> and click &quot;<strong>add user</strong>&quot;. </p><p style="" class=""> <br/> </p><p style="" class=""> Channels, movies and series should be loaded then. </p>',
            'visibility' => 1,
        ]);

        File::copy(public_path('images/how_to_install/mag-device/icon.png'), 'storage/app/public/mag-device_icon.png');
        Post::create([
            'title' => 'MAG device',
            'slug' => 'mag-device',
            'icon' => 'mag-device_icon.png',
            'content' => '<h2>An overview of MAG</h2><p>MAG boxes are some of the most powerful streaming media players. IPTV users choose them for their speed, simplicity, and excellent streaming performance. The user interface is simple and responsive, channel switching is quick and you receive all the features required to get the most out of your <strong>IPTV </strong>service.</p><p>If your Mad device does not allow you to type in m3u link, please get back to us with your MAC address, we will add it to our server.This tutorial will guide you through a simple and effective step of installation your&nbsp;Mag (250/254/256&hellip;).&nbsp;</p><p><br/><strong>Step 1:</strong> When the box is being loaded the main portal screen appears. After that click on &ldquo;settings&rdquo;, press remote button &ldquo;SETUP/SET&rdquo;.</p><p><img alt="" src="'.asset('images/how_to_install/mag-device/1.webp').'" /></p><p><strong>Step 2:</strong> Then press on &ldquo;System settings&rdquo; and click on &ldquo;Servers&rdquo;.</p><p><img alt="" src="'.asset('images/how_to_install/mag-device/2.webp').'" /></p><p><strong>Step 3:</strong> Click on &lsquo;Servers&rsquo;</p><p><img alt="" src="'.asset('images/how_to_install/mag-device/3.webp').'" /></p><p><strong>Step 4: </strong>Choose and Press option &lsquo;Portals&rsquo;</p><p><img alt="" src="'.asset('images/how_to_install/mag-device/4.webp').'" /></p><p><strong>Step 5:</strong> In the &lsquo;Portal 1 name&rsquo; line enter a portal name and in the &lsquo;Portal 1 URL&rsquo; enter portal URL.</p><p><img alt="" src="'.asset('images/how_to_install/mag-device/5.webp').'" /></p><p>Therefore for the activation of our <strong>IPTV </strong>subscription on your MAG box, you must send us with your order the MAC address found on the label behind the box, the activation is done entirely remotely, just after activation, we will send you a URL link that you have to put on your PORTAL, as in the photo below:</p><p><strong>Step 6</strong> &ndash; Finally when you complete select and click &lsquo;OK&rsquo; to save the changes.<br/><strong>Step&nbsp;7</strong> &ndash; Click &lsquo;EXIT&rsquo; on the remote control after the settings are being saved.<br/><strong>Step&nbsp;8</strong> &ndash; Consequently you have to reboot the box. Choose the option &lsquo;OK&rsquo; to make the changes applied.<br/><strong>Step&nbsp;9</strong> &ndash; Enjoy watching over than 8000 channels with HD quality worldwide.</p>',
            'visibility' => 1,
        ]);

        
        File::copy(public_path('images/how_to_install/apple-devices/icon.png'), 'storage/app/public/apple-devices_icon.png');
        Post::create([
            'title' => 'Apple TV/iPhone/iPad',
            'slug' => 'apple-tv-iphone-ipad',
            'icon' => 'apple-devices_icon.png',
            'content' => '<p> Download Smarters Application :&nbsp;<a href="https://apps.apple.com/in/app/smarters-player-lite/id1628995509">https://apps.apple.com/in/app/smarters-player-lite/id1628995509</a> </p><p> <img src="'.asset('images/how_to_install/apple-devices/1.png').'"/><br/><br/>then open it and add a playlist via &quot;<strong>XC API</strong>&quot; which means <strong>Xtream Codes API</strong> : </p><p> ( if you didn\'t get your subscription yet subscribe here :&nbsp;<a href="'.route('subscriptions').'" target="_blank">'.route('subscriptions').'</a> ) </p><p> <br/><img src="'.asset('images/how_to_install/apple-devices/2.png').'"/><br/><br/>then add the details you got via email after you subscribe :&nbsp; </p><p> <br/><img src="'.asset('images/how_to_install/apple-devices/3.png').'"/><br/><br/>1. Put any name you want.<br/>2. Put the username.<br/>3. Put Password. </p><p> 4. Put URL.<br/><br/>for username, password and URL you should use the ones you got via email after you subscribe.<br/><br/>and click &quot;<strong>add user</strong>&quot;.<br/> </p>',
            'visibility' => 1
        ]);


        File::copy(public_path('images/how_to_install/dreamlink/icon.png'), 'storage/app/public/dreamlink_icon.png');
        Post::create([
            'title' => 'Dreamlink box ( DOL2 )',
            'slug' => 'dreamlink-box-dol2',
            'icon' => 'dreamlink_icon.png',
            'content' => '<h2>How to add IPTV channels to Dreamlink</h2><p>In order to add channels to your dreamlink device, follow the below steps.</p><p><strong>Step 1</strong>:&nbsp;From the main page, go to &ldquo;<strong>My Apps</strong>&ldquo;.&nbsp;</p><ul><li><p><img style="height: 675px; width: 1285px;" src="'.asset('images/how_to_install/dreamlink/1.png').'" alt="How to setup IPTV on Dreamlink box via DOL2"></p></li></ul><p><strong>Step 2</strong>:&nbsp;Select DreamOnline (DOL 2).<br>Note, If the DreamOnline (<strong>DOL2)</strong>&nbsp;app is not in the My apps folder go to the Market folder, find DreamOnline (<strong>DOL2</strong>) and install&nbsp;it. After that, it will appear in the My apps folder/</p><ul><li><p><img style="height: 669px; width: 1337px;" src="'.asset('images/how_to_install/dreamlink/2.png').'" alt="How to setup IPTV on Dreamlink box via DOL2"></p></li></ul><p><strong>Step 3</strong>: Now select &ldquo;<strong>Edit Service</strong>&rdquo; and then click on &ldquo;<strong>Click Edit</strong>&ldquo;.&nbsp;<br><strong>Important</strong>: Be sure that you already got your subscription ( <strong><a href="'.route('subscriptions').'" target="_blank">HERE</a></strong> ) with your right MAC Address (if necessary).</p><ul><li><p><img style="height: 720px; width: 1280px;" src="'.asset('images/how_to_install/dreamlink/3.png').'" alt="How to setup IPTV on Dreamlink box via DOL2"></p></li></ul><p><strong>Step 4</strong>:&nbsp;Enter Service Nickname (Any name).</p><ul><li><p><img style="height: 720px; width: 1280px;" src="'.asset('images/how_to_install/dreamlink/4.png').'" alt="How to setup IPTV on Dreamlink box via DOL2"></p></li></ul><p><strong>Step 5</strong>:&nbsp;Enter the IPTV Server URL (<strong>Portal URL</strong>) you get from your Server Operator.</p><ul><li><p><img style="height: 720px; width: 1280px;" src="'.asset('images/how_to_install/dreamlink/5.png').'" alt="How to setup IPTV on Dreamlink box via DOL2"></p></li></ul><p><strong>Step 6</strong>: It is&nbsp;<strong>NOT</strong>&nbsp;necessary to enter the&nbsp;<strong>Username</strong>&nbsp;and&nbsp;<strong>Password.</strong></p><ul><li><p><img style="height: 720px; width: 1280px;" src="'.asset('images/how_to_install/dreamlink/6.png').'" alt="How to setup IPTV on Dreamlink box via DOL2"></p></li></ul><p><strong>Step 7</strong>:&nbsp;Click &ldquo;<strong>OK</strong>&ldquo;.</p><ul><li><p><img style="height: 720px; width: 1280px;" src="'.asset('images/how_to_install/dreamlink/7.png').'" alt="How to setup IPTV on Dreamlink box via DOL2"></p></li></ul><p><strong>Step 8</strong>:&nbsp;Connecting to IPTV Server (with your registered data) in progress.&nbsp;</p><ul><li><p><img style="height: 720px; width: 1280px;" src="'.asset('images/how_to_install/dreamlink/9.png').'" alt="How to setup IPTV on Dreamlink box via DOL2"></p></li></ul><p><strong>Step 9</strong>:&nbsp;Successful Connection! You receive all channels associated with your account.&nbsp;</p><ul><li><p><img style="height: 720px; width: 1280px;" src="https://iptvhelpcenter.com/wp-content/uploads/2021/08/How-to-setup-IPTV-on-Dreamlink-box-via-DOL2-9.png" alt="How to setup IPTV on Dreamlink box via DOL2"></p></li></ul>',
            'visibility' => true
        ]);

        File::copy(public_path('images/how_to_install/tvip/icon.png'), 'storage/app/public/tvip_icon.png');
        Post::create([
            'title' => 'TVIP box',
            'slug' => 'tvip-box',
            'icon' => 'tvip_icon.png',
            'content' => '<h2 class="wp-block-heading">How to add IPTV channels to TVIP Box (New version)</h2><p>If you have new&nbsp;<strong>TVIP boxes like&nbsp;605, 615</strong> you can use this tutorial, but if your boxes is a older version like 410 you need to update the TVIP box operating system</p><p><strong>Step 1</strong>: After run the TVIP box and set the primary setting like language and time, Start from the main menu and go down to see the &ldquo;<strong>Setting</strong>&rdquo; and click on &ldquo;<strong>TV</strong>&rdquo; as depicted in the below picture.</p><figure class="wp-block-gallery columns-1 is-cropped wp-block-gallery-26 is-layout-flex"> <ul class="blocks-gallery-grid"> <li class="blocks-gallery-item"> <figure><img class="wp-image-9001293" src="'.asset('images/how_to_install/tvip/1.jpg').'" alt="How to setup IPTV on TVIP Box" width="800" height="425" loading="lazy" data-id="9001293"></figure> </li></ul></figure><p><strong>Step 2</strong>: Now change the Content source to &ldquo;<strong>Web portal</strong>&rdquo; and click on &ldquo;<strong>Setup Web portal</strong>&ldquo;.</p><figure class="wp-block-gallery columns-1 is-cropped wp-block-gallery-28 is-layout-flex"> <ul class="blocks-gallery-grid"> <li class="blocks-gallery-item"> <figure><img class="wp-image-9001294" src="'.asset('images/how_to_install/tvip/2.jpg').'" alt="How to setup IPTV on TVIP Box" width="800" height="422" loading="lazy" data-id="9001294"></figure> </li></ul></figure><p><strong>Step 3</strong>: First change the API Mode to &ldquo;<strong>MAG</strong>&rdquo; then on the &ldquo;<strong>Portal URL:</strong>&rdquo; enter your portal server address (you can ask for this info from your IPTV distributor) and click on &ldquo;<strong>Apply</strong>&rdquo; and &ldquo;<strong>Restart</strong>&ldquo;.</p><p><strong>Note</strong>: If you don&rsquo;t have &ldquo;<strong>MAG&rdquo;&nbsp;</strong>API in your setting use &ldquo;<strong>GSTB&rdquo;&nbsp;</strong>API.</p><p>Now you must insert your device Mac address to your IPTV dashboard or simply give it to your IPTV distributor.&nbsp;<a href="https://iptvhelpcenter.com/what-is-mac-address-in-mag-box/" target="_blank" rel="noreferrer noopener" data-type="post" data-id="1289">What is Mac address?<br></a>The&nbsp;<strong>progressive IPTV providers</strong>&nbsp;give you a dashboard which you can&nbsp;add MAC to your line yourself on dashboard.</p><p>Note: You can find the TVIP box MAC address on the back of the box.</p><figure class="wp-block-gallery columns-1 is-cropped wp-block-gallery-30 is-layout-flex"> <ul class="blocks-gallery-grid"> <li class="blocks-gallery-item"> <figure><img class="wp-image-9001296" src="'.asset('images/how_to_install/tvip/3.jpg').'" alt="How to setup IPTV on TVIP Box" width="800" height="439" loading="lazy" data-id="9001296"></figure> </li></ul></figure><p><strong>Step 4</strong>: After restarting the box in the main menu click on &ldquo;<strong>Watch TV</strong>&ldquo;, you must wait for the portal to load your playlist. This might take a few minutes.</p><figure class="wp-block-gallery columns-1 is-cropped wp-block-gallery-32 is-layout-flex"> <ul class="blocks-gallery-grid"> <li class="blocks-gallery-item"> <figure><img class="wp-image-9001297" src="'.asset('images/how_to_install/tvip/4.jpg').'" alt="How to setup IPTV on TVIP Box" width="800" height="423" loading="lazy" data-id="9001297"></figure> </li></ul></figure><p><strong>Step 5</strong>: As you can see the channels will pop up automatically and you can select any desired channel and start the streaming.</p><h3 id="h6sk8hbr72r18nd9gs1r8g6ep1jjap7a" class="wp-block-heading">How to add IPTV channels to TVIP Box using M3U url</h3><p>In&nbsp;<strong>Step 2</strong>&nbsp;of the above tutorial&nbsp;change the Content source to &ldquo;<strong>M3U-playlist</strong>&rdquo; and click on &ldquo;<strong>Setup M3U-playlist</strong>&ldquo;.</p><p>Enter M3U url which you receive from your IPTV provider here and&nbsp;click on &ldquo;<strong>Apply</strong>&rdquo; and &ldquo;<strong>Restart</strong>&ldquo;.</p><figure class="wp-block-gallery columns-1 is-cropped wp-block-gallery-34 is-layout-flex"> <ul class="blocks-gallery-grid"> <li class="blocks-gallery-item"> <figure><img class="wp-image-9001295" src="'.asset('images/how_to_install/tvip/5.jpg').'" alt="How to setup IPTV on TVIP Box" width="800" height="420" loading="lazy" data-id="9001295"></figure> </li></ul></figure><h2 id="h170sk8hd54dt1knx3c8ht48td9rvsym" class="wp-block-heading">How to add IPTV channels to TVIP Box (Old version)</h2><p><strong>Step 1</strong>: Start from the main menu and select the &ldquo;<strong>Setting</strong>&rdquo; as depicted in the below picture.</p><figure class="wp-block-gallery columns-1 is-cropped wp-block-gallery-36 is-layout-flex"> <ul class="blocks-gallery-grid"> <li class="blocks-gallery-item"> <figure><img class="wp-image-9001300" src="'.asset('images/how_to_install/tvip/6.jpg').'" alt="How to setup IPTV on TVIP Box" width="800" height="450" loading="lazy" data-id="9001300"></figure> </li></ul></figure><p><strong>Step 2</strong>: Now on the right menu select the &ldquo;<strong>TV</strong>&rdquo;&nbsp;icon and then on the right side change the Content source to &ldquo;<strong>Web portal</strong>&rdquo; and click on &ldquo;<strong>Setup Web portal</strong>&ldquo;</p><figure class="wp-block-gallery columns-1 is-cropped wp-block-gallery-38 is-layout-flex"> <ul class="blocks-gallery-grid"> <li class="blocks-gallery-item"> <figure><img class="wp-image-9001291" src="'.asset('images/how_to_install/tvip/7.jpg').'" alt="How to setup IPTV on TVIP Box" width="800" height="450" loading="lazy" data-id="9001291"></figure> </li></ul></figure><p><strong>Step 3</strong>: Now on the &ldquo;<strong>Portal URL:</strong>&rdquo; enter your portal server address (you can ask for this info from your IPTV distributor) and click on &ldquo;<strong>Apply</strong>&ldquo;.&nbsp;</p><p>Now you must insert your device Mac address to your IPTV dashboard or simply give it to your IPTV distributor.&nbsp;<a href="https://iptvhelpcenter.com/what-is-mac-address-in-mag-box/" target="_blank" rel="noreferrer noopener" data-type="post" data-id="1289">What is Mac address?<br></a>The&nbsp;<strong>progressive IPTV providers</strong>&nbsp;give you a dashboard which you can&nbsp;add MAC to your line yourself on dashboard.</p><p>Note: You can find the TVIP box MAC address on the back of the box.</p><figure class="wp-block-gallery columns-1 is-cropped wp-block-gallery-40 is-layout-flex"> <ul class="blocks-gallery-grid"> <li class="blocks-gallery-item"> <figure><img class="wp-image-9001302" src="'.asset('images/how_to_install/tvip/8.jpg').'" alt="How to setup IPTV on TVIP Box" width="675" height="503" loading="lazy" data-id="9001302"></figure> </li></ul></figure><p><strong>Step 4</strong>: After adding your portal server address, you must wait for the portal to load your playlist. This might take a few minutes.</p><figure class="wp-block-gallery columns-1 is-cropped wp-block-gallery-42 is-layout-flex"> <ul class="blocks-gallery-grid"> <li class="blocks-gallery-item"> <figure><img class="wp-image-9001301" src="'.asset('images/how_to_install/tvip/9.jpg').'" alt="How to setup IPTV on TVIP Box" width="800" height="412" loading="lazy" data-id="9001301"></figure> </li></ul></figure><p><strong>Step 5</strong>: As you can see the channels will pop up automatically and you can select any desired channel and start the streaming.</p><figure class="wp-block-gallery columns-1 is-cropped wp-block-gallery-44 is-layout-flex"> <ul class="blocks-gallery-grid"> <li class="blocks-gallery-item"> <figure><img class="wp-image-9001292" src="'.asset('images/how_to_install/tvip/10.jpg').'" alt="How to setup IPTV on TVIP Box" width="800" height="450" loading="lazy" data-id="9001292"></figure> </li></ul></figure>',
            'visibility' => true
        ]);

        File::copy(public_path('images/how_to_install/FormulerZ11/icon.png'), 'storage/app/public/FormulerZ11_icon.png');
        Post::create([
            'title' => 'FormulerZ11 box ( MYTV Online 3 )',
            'slug' => 'formulerz11-box-mytv-online-3',
            'icon' => 'FormulerZ11_icon.png',
            'content' => '<p><strong>Formuler Z</strong> boxes are one of the best devices for watching IPTV.<br>The most important advantage of FormulerZ boxes is supporting both MAC base Portal System and M3U base Playlist.<br>After successful Formuler Z8 and Formuler Z10 boxes now we have Formuler Z11 set up boxes.<br>The Formuler Z11 is a more advanced IPTV set-top box than the Formuler Z10. Here are some of the key differences between the two devices :</p><p><em><strong>Processor</strong></em>: The Formuler Z11 comes with a faster processor than the Formuler Z10. The Z11 is equipped with a quad-core processor, while the Z10 has a dual-core processor.<br><em><strong>RAM</strong></em>: The Formuler Z11 has more RAM than the Formuler Z10. The Z11 has 2GB of RAM, while the Z10 has 1GB of RAM.<br><em><strong>Storage</strong></em>: The Formuler Z11 has more storage than the Formuler Z10. The Z11 comes with 16GB of internal storage, while the Z10 has 8GB of internal storage.</p><p><em><strong>Connectivity</strong></em>: The Formuler Z11 has more connectivity options than the Formuler Z10. The Z11 supports Gigabit Ethernet, while the Z10 supports Fast Ethernet. The Z11 also comes with built-in dual-band Wi-Fi, while the Z10 has single-band Wi-Fi.</p><p><em><strong>HDR</strong></em>: The Formuler Z11 supports HDR (High Dynamic Range), which provides a wider range of colors and contrast than the Formuler Z10.</p><h2>How to bring IPTV channels to your FormulerZ11</h2><p>This tutorial is useful for all model of Formuler boxes which have MYTVonline3.</p><p><em><strong>Note</strong></em>: Please consider in the new generation of Formuler boxes like Formuler Z11, the MAC address which you need to give IPTV provider is the MAC ID of the box which starts with 00:1E:B8:XX:XX:XX . In the old model like Formuler Z7 and Z8 you need to change this MAC ID to MAC address which start with 00:1A:79:XX:XX:XX</p><p><img class="wp-image-9002503" src="'.asset('images/how_to_install/FormulerZ11/1.jpg').'" alt="Formuler Z11 box" width="1024" height="649" loading="lazy"></p><p><strong>Step 1</strong>:&nbsp;The default application for IPTV on Formuler Z11 is&nbsp;<strong>&ldquo;MYTV Online 3&rdquo;.</strong><br>Open this app.</p><p><strong>Step 2</strong>:&nbsp;Go to&nbsp;<strong>Menu&nbsp;</strong>then&nbsp;<strong>Content Manager</strong>&nbsp;and click on &ldquo;<strong>Source Manager</strong>&ldquo;.</p><p><img src="'.asset('images/how_to_install/FormulerZ11/2.jpg').'" alt="How to setup IPTV on FormulerZ11 box via MYTV Online 3 app"></p><p><strong>Step 3</strong>:&nbsp;If you want to setup your formuler Z11 box with portal system, click on&nbsp;<strong>&ldquo;+Add&rdquo;</strong>&nbsp;and then&nbsp;<strong>&ldquo;Add Portal&rdquo;</strong>.<br>Here you have an ID of your box, click on the eye icon to see the full MAC ID. you need to send this&nbsp;<strong>MAC ID</strong>&nbsp;to your IPTV provider and they will add the MAC in the system and give you the&nbsp;<strong>Portal URL</strong>. Then you need to add the Portal URL here in this page. Let be the Login required off, in the last step click on&nbsp;<strong>&ldquo;Connect&rdquo;</strong> to load the channels.</p><p><img src="'.asset('images/how_to_install/FormulerZ11/3.jpg').'" alt="How to setup IPTV on FormulerZ11 box via MYTV Online 3 app"></p><p>If you want to setup your formuler Z11 box with M3U system, after click on&nbsp;<strong>&ldquo;+Add&rdquo;</strong>&nbsp;choose&nbsp;<strong>&ldquo;Add m3u Playlist&rdquo;</strong>.<br>Enter the M3U url which you receive from your IPTV provider in&nbsp;<strong>&ldquo;Playlist URL&rdquo;</strong>&nbsp;. if you enter&nbsp;<strong>M3U with options</strong> not need to add&nbsp; VOD URL and EPG URL, leave them blank. EPG and Movies will load automatically.</p><p><img src="'.asset('images/how_to_install/FormulerZ11/4.jpg').'" alt="How to setup IPTV on FormulerZ11 box via MYTV Online 3 app"></p><p>In the last step click and Connect and Enjoy!</p>',
            'visibility' => true
        ]);


        File::copy(public_path('images/how_to_install/FormulerZ8/icon.png'), 'storage/app/public/FormulerZ8_icon.png');
        Post::create([
            'title' => 'FormulerZ8 box ( MYTV Online 2 )',
            'slug' => 'formulerz8-box-mytv-online-2',
            'icon' => 'FormulerZ8_icon.png',
            'content' => '<h2 id="mcetoc_1e0gc2dd30" class="wp-block-heading">How to bring IPTV channels to your FormulerZ8&nbsp;</h2><p>This tutorial can be used for all model of formuler boxes includes: &nbsp;FormulerZ8+ and Formuler Z10 .</p><p><img src="'.asset('images/how_to_install/FormulerZ8/1.jpg').'"></p><p><strong>Step 1</strong>:&nbsp;Open the exclusive application for watching IPTV in Formuler boxes&nbsp;<strong>&ldquo;MYTV Online 2&rdquo;.<br></strong>If you don&rsquo;t have this application on your device you can download it from the&nbsp;<strong>Google Play</strong> store.</p><p><img src="'.asset('images/how_to_install/FormulerZ8/2.jpg').'"></p><p><strong>Step 2</strong>:&nbsp;&nbsp;You can see the box&rsquo;s&nbsp;<strong>MAC</strong>&nbsp;in the top right of this page.<br><strong>Please note</strong>, this MAC address must be given to your IPTV provider (Some progressive IPTV provider present you a dashboard to manage IPTV settings, you can Add MAC address to your subscription in dashboard)</p><p>Here you can see the two options, select&nbsp;<strong>&ldquo;Add Portal&rdquo;</strong>&nbsp;to set device as a&nbsp;<strong>MAC base</strong> device like MAG boxes.</p><p><img src="'.asset('images/how_to_install/FormulerZ8/3.jpg').'"></p><p><strong>Step 3</strong>: Enter&nbsp;<strong>Portal&nbsp;Nickname</strong>&nbsp;(Example: MYIPTV).<br>Enter IPTV&nbsp;<strong>Portal URL</strong>&nbsp;you get from your&nbsp;<strong>IPTV provider&nbsp;</strong>and click on<strong>&nbsp;&ldquo;CONNECT&rdquo;</strong>. You can ask for portal URL from your IPTV service provider.</p><p><img src="'.asset('images/how_to_install/FormulerZ8/4.jpg').'"></p><p><strong>Step 4</strong>:&nbsp;Successful Connection! You receive all channels associated with your subscription<br>Please note, this might take a little time&hellip;</p><h2 class="wp-block-heading">How to setup FormulerZ8 with MYTV Online 2 using M3U Url</h2><p><strong>Step 1</strong>: After opening the MYTV online application you have two options.<br>To setup FormulerZ8 using M3U url you need to select&nbsp;<strong>&ldquo;Add Playlist&rdquo;</strong> here.</p><p><img src="'.asset('images/how_to_install/FormulerZ8/5.jpg').'"></p><p><strong>Step 2</strong>:&nbsp;Enter&nbsp;<strong>Playlist Nickname</strong>&nbsp;(Example: MYIPTV).</p><p>Enter IPTV&nbsp;M3U<strong>&nbsp;URL</strong>&nbsp;you get from your&nbsp;<strong>IPTV provider&nbsp;</strong>and click on<strong>&nbsp;&ldquo;CONNECT&rdquo;</strong>.&nbsp;(Some progressive IPTV provider present you a dashboard to manage IPTV settings, you can&nbsp;Access&nbsp;your M3U Url in dashboard)<br><strong>Note</strong>: If you add M3U&nbsp;<strong>with Options</strong> Url here, Do not need to Add VOD or EPG url anymore. For more information please contact your IPTV provider.</p><p><img src="'.asset('images/how_to_install/FormulerZ8/6.jpg').'"></p><p><strong>Step 3</strong>: Now Everything is ready and you can start watching Live TV.<br>Please note, this might take a little time&hellip;</p>',
            'visibility' => true
        ]);

    }
}
