<?php

namespace Database\Seeders;

use App\Models\Config;
use App\Models\Order;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\File;

class AppSeeder extends Seeder
{
    public function run()
    {
        User::create([
            'name' => 'AACHDEV',
            'email' => 'admin@admin.com',
            'password' => bcrypt('Admin@1996-'),
            'is_admin' => 1
        ]);
        
        Config::create([ 'name' => 'disable_tools', 'value' => false ]);
        Config::create([ 'name' => 'paypal_shuffled', 'value' => false ]);
        Config::create([ 'name' => 'gtag', 'value' => '#' ]);
        Config::create([ 'name' => 'redirection_allowed', 'value' => true ]);
        Config::create([ 'name' => 'trial_allowed', 'value' => true ]);
        Config::create([ 'name' => 'top_message_allowed', 'value' => true ]);
        Config::create([ 'name' => 'top_message', 'value' => 'BEST Canada & USA IPTV PROVIDER' ]);
        Config::create([ 'name' => 'whatsapp_link', 'value' => 'https://wa.me/+19144316226' ]);
        Config::create([ 'name' => 'website_title', 'value' => config('app.name') ]);
        Config::create([ 'name' => 'website_description', 'value' => 'Best IPTV Provider In Canada & USA 2024' ]);
        Config::create([ 'name' => 'seo_title', 'value' => config('app.name').' || Best IPTV Provider in Canada & USA 2024' ]);
        Config::create([ 'name' => 'seo_description', 'value' => config('app.name').' is one of the best IPTV services providing up than 16,000 live channels and 60,000+ MOVIES & TV Shows (VODs).' ]);
        Config::create([ 'name' => 'seo_keywords', 'value' => 'iptv, best iptv, iptv subscription, iptv 2024, world cup 2024, qatar 2024' ]);
        Config::create([ 'name' => 'about_us', 'value' => 'Our IPTV subscription service in Canada & USA offers the ultimate streaming experience, with a range of devices and platforms to access our extensive channel lineup.' ]);
        Config::create([ 'name' => 'default_iptvServer', 'value' => 2 ]);
        Config::create([ 'name' => 'oneSignalAppId', 'value' => '96ef64be-91f3-4ad6-98d0-1df7ccc97049' ]);
        Config::create([ 'name' => 'oneSignalRestApiKey', 'value' => 'NGQ0MDIxOGItY2VkNi00YzQwLTk3YTItNGQ5MDIyNDcyMjlj' ]);
        Config::create([ 'name' => 'currency', 'value' => 1 ]);
        Config::create([ 'name' => 'app_notifications', 'value' => true ]);
        Config::create([ 'name' => 'client_notifications', 'value' => true ]);
        Config::create([ 'name' => 'adult_enabled', 'value' => true ]);
        Config::create([ 'name' => 'adult_price', 'value' => 0.99 ]);
        Config::create([ 'name' => 'fastdelivery_enabled', 'value' => true ]);
        Config::create([ 'name' => 'fastdelivery_price', 'value' => 1.99 ]);
        Config::create([ 'name' => 'legal_website', 'value' => 'https://buysubiv.test' ]);
        
        Config::create([ 'name' => 'redirection_seconds', 'value' => 2 ]);
        Config::create([ 'name' => 'background_color', 'value' => "#0e1124" ]);
        Config::create([ 'name' => 'cta_color', 'value' => "#b105a7" ]);

        Config::create([ 'name' => 'gads_tracking_enabled', 'value' => true ]);
        Config::create([ 'name' => 'gads_tracking_tag', 'value' => '#' ]);
        Config::create([ 'name' => 'gads_conversion_id', 'value' => '#' ]);

        /**
         * HOMEPAGE SETTINGS;
        */
        Config::create([ 'name' => 'homepage_showDevices', 'value' => false ]);
        Config::create([ 'name' => 'homepage_showTargetedCountry', 'value' => true ]);

        Config::create([ 'name' => 'homepage_vodEnabled', 'value' => true ]);
        Config::create([ 'name' => 'homepage_newsEnabled', 'value' => false ]);
        Config::create([ 'name' => 'homepage_testimonialsEnabled', 'value' => true ]);
        Config::create([ 'name' => 'homepage_faqEnabled', 'value' => true ]);

        Config::create([ 'name' => 'homepage_ctaTitle', 'value' => 'Best Canada & USA IPTV Service Provider' ]);
        Config::create([ 'name' => 'homepage_ctaSubtitle', 'value' => 'No Contract is required, No Automatic Payments' ]);
        Config::create([ 'name' => 'homepage_ctaParagraphHtml', 'value' => '<p>* up to 18.500 TV Channels With EPG and up to 64.500 Movies &amp; Series 4K.</p><p>* AntiFreeze Technology, Fast &amp; Stable, 99.9% Server Uptime.</p><p>* Enjoy the Best Canada & USA IPTV Service with High Quality 4k/FHD</p>' ]);

        Config::create([ 'name' => 'homepage_mainTitle', 'value' => 'Stream Iptv With The Best IPTV Service Provider since 2018.' ]);
        Config::create([ 'name' => 'homepage_mainParagraphHtml', 'value' => '<p>Our IPTV service is the fruit of our 5 Years\' experience, our goal is to satisfy our clients, give them the best experience possible and build a long term relationship with them, we have the most stable and powerful servers on the market with no buffering or freeze at all.</p><p>Our IPTV stream makes it faster, easier and cheaper than ever to watch everything you want with a clear, high-quality picture.</p>' ]);

        Config::create([ 'name' => 'cl_defaultStandardCountryId', 'value' => 2 ]);
        Config::create([ 'name' => 'cl_defaultPremiumCountryId', 'value' => 2 ]);
        Config::create([ 'name' => 'cl_defaultCategory', 'value' => 1 ]);

        /**
         * PICTURE RESOLUTION 380x154;
        */
        File::copy(public_path('app_images/white.webp'), 'storage/app/public/white.webp');
        File::copy(public_path('app_images/black.webp'), 'storage/app/public/black.webp');
        File::copy(public_path('app_images/favicon.ico'), 'storage/app/public/favicon.ico');
        Config::create([ 'name' => 'black_logo', 'value' => 'black.webp' ]);
        Config::create([ 'name' => 'white_logo', 'value' => 'white.webp' ]);
        Config::create([ 'name' => 'favicon', 'value' => 'favicon.ico' ]);
        /**
         * LIVE CHAT;
        */
        $chat_script = "";
        $chat_script .= '<script type="text/javascript">';
        $chat_script .= 'var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();';
        $chat_script .= '(function(){';
        $chat_script .= 'var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];';
        $chat_script .= 's1.async=true;';
        $chat_script .= "s1.src='https://embed.tawk.to/643363b031ebfa0fe7f76073/1gtkbqqra';";
        $chat_script .= "s1.charset='UTF-8';";
        $chat_script .= "s1.setAttribute('crossorigin','*');";
        $chat_script .= 's0.parentNode.insertBefore(s1,s0);';
        $chat_script .= '})();';
        $chat_script .= '</script>';
        Config::create([ 'name' => 'chat_enabled', 'value' => true ]);
        Config::create([ 'name' => 'chat_script', 'value' => $chat_script ]);
    }
}