<?php

namespace App\Mail;

use App\Models\Config;
use App\Models\Currency;
use App\Models\Order;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Encryption\Encrypter;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Config as FacadesConfig;

class SendInvoiceMail extends Mailable
{
    use Queueable, SerializesModels;

    public $order_id;

    public function __construct($order_id)
    {
        $this->order_id = $order_id;
    }
    
    public function build()
    {
        $order = Order::whereId($this->order_id)->first();
        $json["uuid"] = $order->uuid;
        $json["background_color"] = Config::whereName('background_color')->first()->value;
        $json["order_id"] = $order->id;
        $json["product_name"] = $order->product->period;
        $json["subtotal"] = $order->subtotal;
        $json["total"] = $order->total;
        $json["vod"] = $order->vod;
        $json["vod_price"] = $order->vod_price;
        $json["adult"] = $order->adult;
        $json["adult_price"] = $order->adult_price;
        $json["fastdelivery"] = $order->prioritize;
        $json["fastdelivery_price"] = $order->prioritize_price;
        $json["ppv"] = $order->ppv;
        $json["ppv_price"] = $order->ppv_price;
        $json["email"] = $order->billing_email;
        $json["name"] = $order->billing_name;
        $redirection_seconds = Config::whereName('redirection_seconds')->first()->value;
        $json["redirection_seconds"] = $redirection_seconds;
        $currency_id = Config::whereName('currency')->first()->value;
        $json["currency"] = Currency::whereId($currency_id)->select(['symbol', 'code'])->first()->toArray();
        // $data = base64_encode(json_encode($json));
        try {
            $newEncrypter = new Encrypter( env('AES_SECRET_KEY'), FacadesConfig::get( 'app.cipher' ) );
            $data = $newEncrypter->encrypt($json);
        }catch(Exception $e) {
            return $e;
        }
        $url = route('pay_invoice', $data);
        return $this->subject($order->product->short_title.' [ Invoice Payment ]')
                    ->markdown('mails.send_invoice', [ 'url' => $url, 'order' => $order ]);
    }
}