<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SendExpiredMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */

    protected $order;
    protected $expiration_date;

    public function __construct($order, $expiration_date)
    {
        $this->order = $order;
        $this->expiration_date = $expiration_date;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->markdown('mails.send_expiration')
                    ->subject(config('app.name').' - RENEWING REMINDER')
                    ->with([
                        'order' => $this->order,
                        'expiration_date' => $this->expiration_date                        
                    ]);
    }
}
