<?php

namespace App\Http\Controllers;

use Exception;
use App\Jobs\NewOrderJob;
use App\Models\Config;
use App\Models\Connection;
use App\Models\ConnectionOrder;
use App\Models\Currency;
use App\Models\Order;
use App\Models\Paypal;
use App\Models\Subtype;
use Carbon\Carbon;
use Gloudemans\Shoppingcart\Facades\Cart;
use Illuminate\Encryption\Encrypter;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config as FacadesConfig;
use Illuminate\Support\Str;

class CheckoutController extends Controller
{
    public function show() {
        // Check If Redirection Is Allowed;
        $redirection_allowed = Config::whereName('redirection_allowed')->first()->value;
        if($redirection_allowed) return redirect()->route('cart') ;
        $items = Cart::content();
        if(count($items) == 0) return redirect()->route('home');
        foreach( $items as $item ) {
            $vod = $item->options->vod ? 1 : 0;
            $vod_price = $item->options->vod_price;

            $adult = $item->options->adult ? 1 : 0;
            $adult_price = $item->options->adult_price;

            $fastdelivery = $item->options->fastdelivery ? 1 : 0;
            $fastdelivery_price = $item->options->fastdelivery_price;

            $product_title = $item->name;

            $name = $item->options->name;
            $email = $item->options->email;
            $renewing = $item->options->renewing;

            $notes = $item->options->notes;

            $connections = $item->options->connections;
            break;
        }
        $currency_id = Config::whereName('currency')->first()->value;
        $currency = Currency::whereId($currency_id)->first();
        $subtypes = Subtype::all();
        $paypal_shuffled = Config::whereName('paypal_shuffled')->first()->value;
        $client_id = 0;
        if( $paypal_shuffled == 1 ) {
            $paypals = Paypal::whereActive(true)->get();
            $randomPaypal = $this->getRandomElement($paypals);
            $client_id = $randomPaypal->client_id;
        }else $client_id = Paypal::whereActive(true)->first()->client_id;
        return view('checkout')->with(compact(
            'vod', 'vod_price',
            'adult', 'adult_price',
            'fastdelivery', 'fastdelivery_price',
            'product_title', 'client_id', 'name', 'email', 'notes', 'connections', 'subtypes', 'currency'
        ));
    }

    public function payment_regular(Request $request) {
        $connections = json_decode($request->connections, true);
        $request['connections'] = $connections;
        foreach( Cart::content() as $item ) {
            $cart_item = $item;
            break;
        }
        $default_currency = Config::whereName('currency')->first()->value;
        $orderData['currency_id'] = $default_currency;
        $orderData['uuid'] = uniqid();       
        $orderData['product_id'] = $cart_item->model->id;       
        $orderData['customer_id'] = $request->customer_id;
        $orderData['transaction_id'] = $request->transaction_id;
        $orderData['ppl_firstName'] = $request->ppl_firstName;
        $orderData['ppl_lastName'] = $request->ppl_lastName;
        $orderData['ppl_email'] = $request->ppl_email;
        $orderData['ppl_country'] = $request->ppl_country;
        $orderData['notes'] = $cart_item->options->notes;
        $orderData['billing_name'] = $cart_item->options->name;
        $orderData['billing_email'] = $cart_item->options->email;
        $orderData['renewing'] = $cart_item->options->renewing;
        $orderData['subtotal'] = (float) Cart::subtotal();
        $orderData['total'] = (float) Cart::subtotal() + (float)$cart_item->options->vod_price + (float)$cart_item->options->adult_price + (float)$cart_item->options->fastdelivery_price;
        $orderData['vod'] = $cart_item->options->vod;
        $orderData['vod_price'] = $cart_item->options->vod_price;
        $orderData['adult'] = $cart_item->options->adult;
        $orderData['adult_price'] = $cart_item->options->adult_price;
        $orderData['fastdelivery'] = $cart_item->options->fastdelivery;
        $orderData['fastdelivery_price'] = $cart_item->options->fastdelivery_price;
        $orderData['paid'] = true;
        $orderData['payment_date'] = Carbon::now();
        $orderData['sent'] = false;
        $orderData['gateway'] = 'PayPal';
        $orderData['refunded'] = false;
        $order = Order::create($orderData);
        /**
         * CREATE SERVICES;
        */
        foreach(json_decode($cart_item->options->connections) as $connectionData) {
            $connection = Connection::create([
                'subtype_id' =>  $connectionData->subtype,
                'mac_address' =>  $connectionData->mac_address->value,
            ]);
            ConnectionOrder::create([
                'connection_id' => $connection->id,
                'order_id' => $order->id,
            ]);
        }
        session()->put('order_received', $order->id);
        return redirect()->route('order_received');
    }

    public function checkout_bridge(Request $request) {
        if( count(Cart::content()) == 0 ) return redirect()->route('home');
        // UPDATE CART;
        $vod_price = $request->vod ? $this->getAddonPrice('vod_price') : 0;
        $adult_price = $request->adult ? $this->getAddonPrice('adult_price') : 0;
        $fastdelivery_price = $request->fastdelivery ? $this->getAddonPrice('fastdelivery_price') : 0;
        foreach( Cart::content() as $item ) {
            Cart::update($item->rowId, [
                'options' => [
                    'name' => $request->name,
                    'email' => $request->email_address,
                    'renewing' => $request->renewing,
                    'phone_number' => $request->phone_number,
                    'countries' => $request->countries,
                    'languages' => $request->languages,
                    'mac_address' => $request->mac_address,
                    'notes' => $request->notes,
                    'vod' => (boolean) $request->vod,
                    'vod_price' => (float) $vod_price,
                    'adult' => (boolean) $request->adult,
                    'adult_price' => (float) $adult_price,
                    'fastdelivery' => (boolean) $request->fastdelivery,
                    'fastdelivery_price' => (float) $fastdelivery_price,
                    'connections' => $request->connections
                ],
            ]);
        }
        // Validate Email;
        $validator = $request->validate([
            'email_address' => 'required|regex:/(.+)@(.+)\.(.+)/i'
        ]);
        // if ($validator->fails()) {
        //     $error = $validator->errors()->first();
        //  }
        // Check If Redirection Is Allowed;
        $redirection_allowed = Config::whereName('redirection_allowed')->first()->value;
        if(!$redirection_allowed) return redirect()->route('checkout') ;
        // SETUP INVOICE;
        $connections = json_decode($request->connections, true);
        $request['connections'] = $connections;
        foreach( Cart::content() as $item ) {
            $cart_item = $item;
            break;
        }
        /**
         * CREATE NEW ORDER;
        */
        $default_currency = Config::whereName('currency')->first()->value;
        $orderData['uuid'] = uniqid();       
        $orderData['currency_id'] = $default_currency;   
        $orderData['product_id'] = $cart_item->model->id;       
        $orderData['product_id'] = $cart_item->model->id;       
        $orderData['customer_id'] = "";
        $orderData['transaction_id'] = "";
        $orderData['ppl_firstName'] = "";
        $orderData['ppl_lastName'] = "";
        $orderData['ppl_email'] = "";
        $orderData['ppl_country'] = "";
        $orderData['notes'] = $request->notes;
        $orderData['billing_name'] = $request->name;
        $orderData['billing_email'] = $request->email_address;
        $orderData['renewing'] = $request->renewing;

        $orderData['phone_number'] = $request->phone_number;
        $orderData['countries'] = $request->countries;
        $orderData['languages'] = $request->languages;

        $orderData['subtotal'] = (float) Cart::subtotal();
        $orderData['total'] = (float) Cart::subtotal() + (float)$cart_item->options->adult_price + (float)$cart_item->options->fastdelivery_price;
        $orderData['gateway'] = '';
        $orderData['vod'] = $cart_item->options->vod;
        $orderData['vod_price'] = $cart_item->options->vod_price;
        $orderData['adult'] = $cart_item->options->adult;
        $orderData['adult_price'] = $cart_item->options->adult_price;
        $orderData['fastdelivery'] = $cart_item->options->fastdelivery;
        $orderData['fastdelivery_price'] = $cart_item->options->fastdelivery_price;
        $orderData['paid'] = false;
        $orderData['sent'] = false;
        $orderData['refunded'] = false;
        $order = Order::create($orderData);
        /**
         * CREATE SERVICES;
        */
        foreach($request['connections'] as $connectionData) {
            $connection = Connection::create([
                'subtype_id' =>  $connectionData['subtype'],
                'mac_address' =>  $connectionData['mac_address']['value'],
            ]);
            ConnectionOrder::create([
                'connection_id' => $connection->id,
                'order_id' => $order->id,
            ]);
        }
        /**
         * SETUP CLOAKING;
        */
        $json["background_color"] = Config::whereName('background_color')->first()->value;
        $json["uuid"] = $order->uuid;
        $json["order_id"] = $order->id;
        $json["order_uuid"] = $order->id;
        $json["product_name"] = $order->product->period;
        $json["subtotal"] = (float) Cart::subtotal();
        $json["total"] = $order->total;
        $json["vod"] = $order->vod;
        $json["vod_price"] = $order->vod_price;
        $json["adult"] = $order->adult;
        $json["adult_price"] = $order->adult_price;
        $json["fastdelivery"] = $order->fastdelivery;
        $json["fastdelivery_price"] = $order->fastdelivery_price;
        $json["email"] = $order->billing_email;
        $json["name"] = $order->billing_name;
        $redirection_seconds = Config::whereName('redirection_seconds')->first()->value;
        $json["redirection_seconds"] = $redirection_seconds;
        // Currency;
        $currency_id = Config::whereName('currency')->first()->value;
        $json["currency"] = Currency::whereId($currency_id)->select(['symbol', 'code'])->first()->toArray();
        $legal_website = Config::whereName('legal_website')->first()->value;
        // $base64encrypted = base64_encode(json_encode($json)); // Base64 encryption
        /**
         * AES ENCRYPTION;
        */
        $newEncrypter = new Encrypter( env('AES_SECRET_KEY'), FacadesConfig::get( 'app.cipher' ) );
        $encrypted = $newEncrypter->encrypt( $json );
        return redirect($legal_website.'/checkout/'.$encrypted);       
    }

    private function getAddonPrice($string) {
        return Config::whereName($string)->first()->value;
    }

    function getrandomelement($array) {
        $pos=rand(0,sizeof($array)-1);
        $res=$array[$pos];
        if (is_array($res)) return $this->getrandomelement($res);
        else return $res;
    }

    public function complete_ref_payment($json) {
        $legal_website = Config::whereName('legal_website')->first()->value;
        $referer = str_replace("https://", "", $legal_website);
        $referer = str_replace("http://", "", $referer);
        $referer = str_replace("/", "", $referer);
        if( Str::contains(request()->headers->get('referer'), $referer) ) {
            try {
                $newEncrypter = new Encrypter( env('AES_SECRET_KEY'), FacadesConfig::get( 'app.cipher' ) );
                $data = $newEncrypter->decrypt($json);
            }catch(Exception $e) {
                return redirect()->route('home');
            }
            $result = Order::whereId($data['order_id'])->first()->update([
                'customer_id' => $data['customer_id'],
                'transaction_id' => $data['transaction_id'],
                'ppl_firstName' => $data['first_name'],
                'ppl_lastName' => $data['last_name'],
                'ppl_email' => $data['paypal_email'],
                'ppl_country' => $data['country'],
                'ppl_account' => $data['ppl_account'],
                'gateway' => $data['gateway'],
                'paid' => $data['paid'],
                'payment_date' => Carbon::now(),
            ]);
            if($result == 1) {
                session()->put('order_received', $data['order_id']);
                return redirect()->route('order_received');
            }
        }
        return redirect()->route('home');
    }

    public function order_received() {
        $currency_id = Config::whereName('currency')->first()->value;
        $currency = Currency::whereId($currency_id)->first();
        if( session()->has('order_received') ) {
            $order = Order::whereId(session()->get('order_received'))->first();
            NewOrderJob::dispatch( $order->billing_email, $order->id);
            session()->forget('order_received');
            Cart::destroy();
            return view('order_received')->with(compact('order', 'currency'));
        }else return redirect()->route('home');
    }

    public function pay_invoice($data) {
        try {
            $newEncrypter = new Encrypter( env('AES_SECRET_KEY'), FacadesConfig::get( 'app.cipher' ) );
            $d = $newEncrypter->decrypt($data);
        }catch(Exception $e) {
            return $e;
        }
        $order = Order::whereId($d['order_id'])->firstOrFail();
        $url = route('home');
        if( $order != null && $order->paid == 0 ) {
            $paid = false;
            $legal_website = Config::whereName('legal_website')->first()->value;
            $url = $legal_website.'/checkout/'.$data;
        }else $paid = true;
        return view('pay_invoice')->with(compact('paid', 'url'));
    }

    /**
     * STRIPE WEBHOOK;
     */
    public function stripe_webhook(Request $request) {
        $order = Order::whereUuid($request->uuid)->first();
        if( $order = Order::whereUuid($request->uuid)->first() ) {
            $order->update([
                'paid' => true,
                'customer_id' => $request->customer_id,
                'transaction_id' => $request->transaction_id,
                'gateway' => 'Stripe',
                'payment_date' => Carbon::now(),
            ]);
        }
    }
    /**
     * END STRIPE WEBHOOK;
     */
}