<?php

namespace App\Console\Commands;

use App\Jobs\SendExpiredEmailJob;
use App\Models\Order;
use Carbon\Carbon;
use Illuminate\Console\Command;


class SendExpiredMails extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'expired:send {months=1}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send renewing mails to the expired subscriptions.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $monthsNumber = (int) $this->argument('months');
        
    	$orders = Order::where('paid', 1)
                        ->whereHas('connections', function ($q) use ($monthsNumber) {
                            $q->whereBetween('expiration_date', [
                                Carbon::now(),
                                Carbon::now()->addMonths($monthsNumber)
                            ]);
                        })
                        ->with(['connections' => function ($q) use ($monthsNumber) {
                            $q->whereBetween('expiration_date', [
                                Carbon::now(),
                                Carbon::now()->addMonths($monthsNumber)
                            ])
                            ->orderBy('expiration_date', 'asc'); // soonest expiring first
                        }])->get();
                        
        foreach($orders as $order) {
            if( !$order->expiration_sent ) {
                SendExpiredEmailJob::dispatch($order->id, $order->connections[0]->expiration_date);
                $this->info("Order N° : ".$order->id." ==> Queued.");
            }
        }

        return true;
    }
}
