
<?php $__env->startSection('title', config('app.name').' || CheckOut'); ?>
<?php $__env->startSection('content'); ?>

<?php
    $isDigital =  \App\Models\Config::whereName("isDigital")->first()->value;
?>

<div id="check_out">
    <div class="container">
        <img id="logo" src="<?php echo e(asset('storage/'.$iptv_logo)); ?>" />
        <p class="sub_title">You are almost there</p>
        <div class="gray_elements">
            <span class="element">
                <i class="fa fa-shield"></i>
                SSL secured checkout
            </span>
            <span class="element">
                <i class="fa fa-life-ring"></i>
                24/7 support available
            </span>
            <span class="element">
                <i class="fa fa-credit-card-alt"></i>
                Payment option
            </span>
        </div>
        <div class="checkout_container">
            <div id="top_breadcrumb">
                <div class="breadcrumb_elements">
                    <span class="breadcrumb_element">
                        <i class="fa fa-circle-o"></i>
                        cart
                    </span>
                    <span class="divider"></span>
                    <span class="breadcrumb_element">
                        <i class="fa fa-circle"></i>
                        information
                    </span>
                    <span class="divider"></span>
                    <span class="breadcrumb_element">
                        <i class="fa fa-circle-o"></i>
                        finish
                    </span>
                </div>
            </div>
        </div>
        <div class="checkout_container billing">
            <div class="row d-flex justify-content-center">
                <div class="col-md-8 col-sm-12">
                    <h1>Your Order</h1>
                    <div class="order_details">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th class="title" scope="col">product</th>
                                    <th class="title right" scope="col">subTotal</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <th scope="row" class="prod_title"><?php echo e($product_name); ?></th>
                                    <td class="right">
                                        <span class="quantity">x1</span>
                                        <span class="subtotal"><?php echo e($subtotal); ?> <?php echo e($currency['symbol']); ?></span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="table">
                            <tbody>
                                <?php if( $adult == 1 ): ?>
                                <tr>
                                    <th scope="row">adult</th>
                                    <td class="right">
                                        <span class="subtotal">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <?php echo e($adult_price); ?> <?php echo e($currency['symbol']); ?></span>
                                    </td>
                                </tr>
                                <?php endif; ?>

                                <?php if( $vod == 1 ): ?>
                                <tr>
                                    <th scope="row">vod</th>
                                    <td class="right">
                                        <span class="subtotal">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <?php echo e($vod_price); ?> <?php echo e($currency['symbol']); ?></span>
                                    </td>
                                </tr>
                                <?php endif; ?>

                                <?php if( $fastdelivery == 1 ): ?>
                                <tr>
                                    <th scope="row">fast delivery</th>
                                    <td class="right">
                                        <span class="subtotal">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <?php echo e($fastdelivery_price); ?> <?php echo e($currency['symbol']); ?></span>
                                    </td>
                                </tr>
                                <?php endif; ?>

                            </tbody>
                        </table> 
                        <div class="total">
                            <span class="label">total</span>
                            <span class="value"><?php echo e($total); ?> <?php echo e($currency['symbol']); ?></span>
                        </div>

                        <form id="submit-payment" class="d-none" method="POST" action="<?php echo e(route('complete_iptv_payment')); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="order_id" value="<?php echo e($order_id); ?>">
                            <input type="hidden" name="user_id" value="<?php echo e($user_id); ?>">
                            <input type="hidden" name="uuid" value="<?php echo e($uuid); ?>">
                            <input type="hidden" name="ppl_id" value="<?php echo e($paypal_id); ?>">

                            <input type="hidden" name="customer_id" id="customer_id">
                            <input type="hidden" name="transaction_id" id="transaction_id">
                            <input type="hidden" name="paypal_email" id="paypal_email">
                            <input type="hidden" name="first_name" id="first_name">
                            <input type="hidden" name="last_name" id="last_name">

                            <?php if( !$isDigital ): ?>
                            <input type="hidden" name="country" id="country">
                            <?php endif; ?>

                        </form>
                        
                        <p class="privacy_policy">Your personal data will be used to process your order, support your experience throughout this website, and for other purposes described in our <b>privacy policy</b>.</p>                       
                        <div id="paypal_box">
                            <span class="title">PayPal <small> ( Debit / Credit Cards ) </small></span>
                            <span class="paypal_box_container">
                                <div id="pay">
                                    <div id="paypal-button-container"></div>
                                </div>
                            </span>
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/axios/1.3.1/axios.min.js" integrity="sha512-NbjaUHU8g0+Y8tMcRtIz0irSU3MjLlEdCvp82MqciVF4R2Ru/eaXHDjNSOvS6EfhRYbmQHuznp/ghbUvcC0NVw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://www.paypal.com/sdk/js?client-id=<?php echo e($clientid); ?>"></script>
<?php if( env('APP_ENV') == 'local' ): ?>
<script src="<?php echo e(asset('js/vue.js')); ?>"></script>
<?php else: ?>
<script src="<?php echo e(asset('js/vue.min.js')); ?>"></script>
<?php endif; ?>
<script>

    new Vue({
        el: '#check_out',
        data: {

        },
        methods: {
            renderPayPal() {
                var self = this
                paypal.Buttons({
                    createOrder: function(data, actions) {
                        return actions.order.create({
                            purchase_units: [{
                                amount: {
                                    value: <?php echo e($total); ?>

                                }
                            }],
                            
                            <?php if( $isDigital ): ?>
                            application_context: {
                                shipping_preference: "NO_SHIPPING"
                            }
                            <?php endif; ?>
                        });
                    },
                    onApprove: function(data, actions) {
                        return actions.order.capture().then(function(details) {


                            if(  details.status == "COMPLETED"  ) {

                                document.getElementById('customer_id').value = details.payer.payer_id
                                document.getElementById('transaction_id').value = details.purchase_units[0].payments.captures[0].id

                                document.getElementById('first_name').value = details.payer.name.given_name
                                document.getElementById('last_name').value = details.payer.name.surname
                                <?php if( !$isDigital ): ?>
                                document.getElementById('country').value = details.purchase_units[0].shipping.address.country_code
                                <?php endif; ?>
                                document.getElementById('paypal_email').value = details.payer.email_address

                                $('form#submit-payment').submit()
                            }else alert("Payment declined");
                        });
                    },
                    onClick: function(data, actions) {
                        
                        console.log(actions)

                    },
                    onCancel: () => {
                        alert('Payment Cancelled!!')
                    }
                }).render('#paypal-button-container')
            },
        },
        mounted() {
            this.renderPayPal()  
        },

    })

</script>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_css'); ?>
<style>

div#check_out {
    text-align: center;
    padding: 33px 24px;
    background-color: <?php echo e($background_color); ?>;
}

div#check_out img#logo {
    width: 166px;
    margin: 20px;
}

select#country {
    display: block;
}

p.sub_title {
    font-size: 34px;
    font-weight: 500;
    color: #c6c6c6;
}

.gray_elements {
    color: #eee;
}

.gray_elements span.element {
    padding: 12px 10px;
    display: inline-block;
}

span.divider {
    display: inline-block;
    width: 80px;
    background: #dadada;
    height: 1px;
    border-radius: 3px;
    margin: 4px 17px;
}

.breadcrumb_elements span.breadcrumb_element {
    color: #fbfbfb;
    font-size: 15px;
    text-transform: capitalize;
    font-weight: 500;
}

.checkout_container {
    background: #00000021;
    padding: 21px 0;
    border-radius: 10px;
    margin: 22px 0;
}

.checkout_container.billing {
    text-align: left;
    padding: 68px 46px;
}

.checkout_container.billing h1 {
    font-size: 18px;
    margin-bottom: 28px;
    text-align: center;
    color: #c7c7c7;
}

.checkout_container.billing label {
    color: #e7e7e7;
    font-size: 14px;
    font-weight: 500;
    margin-bottom: 7px;
    margin-left: 2px;
}

.checkout_container.billing .form-control, .checkout_container.billing .form-control:focus {
    background: #ffffff2b;
    color: white;
    border: none;
    box-shadow: none;
    padding: 8px 12px;
    border-radius: 2px;
    font-size: 14px;
}

.checkout_container.billing .form-group {
    margin-bottom: 22px;
}

span.select2-selection.select2-selection--single, .select2-container--default.select2-container--disabled .select2-selection--single {
    background: #ffffff2b;
    border: none;
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    color: white;
    font-weight: 500;
    font-size: 15px;
}

.table th {
    text-transform: capitalize;
}

.checkout_container.billing tr, .checkout_container.billing th {
    border-top: hidden;
    border-bottom: 1px dashed #b4b4b4;
}

.table>tbody>tr>td,
.table>tbody>tr>th {
    border-top: none;
    border-bottom: none;
}

table.table {
    margin: 0;
}

.table>tbody>tr>td span.subtotal {
    color: yellow;
    font-size: 15px;
    font-weight: 600;
}

.table>tbody>tr>td span.quantity {
    color: #dfd9d9;
    font-size: 14px;
    margin-right: 4px;
}

th.title {
    font-size: 14px;
    color: #a2a2a2;
}

div#paypal_box {
    background: #ffffff1a;
    padding: 16px 16px;
    color: white;
    margin-bottom: 15px;
    border-radius: 10px;
    box-shadow: 0 0 2px #161d62;
}

div#paypal_box span.title {
    font-weight: 700;
}

div#paypal_box span.paypal_box_container {
    display: block;
    margin: 0;
    position: relative;
    margin-top: 20px;
}

div#paypal_box span.paypal_box_container p {
    margin: 0;
    padding: 0;
    color: #dedede;
    font-size: 14px;
}

div.billing_box {
    padding: 0 7px;
    position: relative;
}

p.privacy_policy {
    color: white;
    font-size: 13px;
    margin: 26px 0;
}

p.privacy_policy a {
    color: #00ceec;
    font-weight: 500;
    text-transform: capitalize;
}

div#paypal-button-container, div#paypal-overlay {
    width: 100%;
    background: #f4f4f4;
    padding: 28px 58px 3px;
    border-radius: 3px;
}

.checkout_container.billing label span.required {
    color: rgb(254, 16, 16);
}

div#paypal-overlay img {
    width: 38%;
    padding: 21px 0;
}

div#paypal-overlay {
    text-align: center;
    background: #00000075;
}

button#save_details {
    background: green;
    box-shadow: none;
    border: none;
    border-radius: 13px;
    font-weight: 600;
    font-size: 14px;
    padding: 7px 21px;
}

div#shipping_overlay {
    width: 100%;
    height: 100%;
    background: #000000cc;
    position: absolute;
    top: 0;
    left: 0;
    z-index: 9999;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 43px;
    color: #b7b7b7ab;
}

.order_details {
    background: #ffffff0a;
    box-shadow: 0px 0px 2px #00000038;
    padding: 32px 25px;
    position: relative;
}

.total .label {
    display: block;
    font-weight: 600;
    text-transform: uppercase;
    color: #cecccc;
    text-align: center;
    font-size: 14px;
}

.total .value {
    font-size: 22px;
    font-weight: 800;
    color: #59ff00;
    text-align: center;
    display: block;
}

.orderBig h1 {
    font-size: 29px!important;
    font-weight: 800;
    text-transform: uppercase;
}

.orderBig th {
    font-weight: 800;
    font-size: 17px;
}

.total {
    padding: 23px 0;
    background: #ffffff14;
}

.orderBig div#paypal_box {
    margin-bottom: 5px;
    margin-top: 27px;
}

.orderBig th.prod_title {
    color: white;
    font-size: 14px;
    padding-bottom: 17px;
    font-weight: 500;
}

td.right {
    text-align: right;
}

.checkout_container.billing th.title.right {
    text-align: right;
}

@media (max-width: 992px) {
    div#check_out {
        padding: 0
    }
    .container {
        max-width: 98%;
    }
    .checkout_container.billing {
        padding: 30px 0;
    }
}

@media (max-width: 768px) {

    .checkout_container.billing h1 {
        margin-top: 28px;
    }
    
    th[scope="row"] {
        width: 60%;
    }

    span.divider {
        width: 20px;
    }

    .gray_elements span.element {
        font-size: 13px;
    }

    div#paypal-button-container, div#paypal-overlay {
        padding: 15px 4px!important;
    }

    .order_details {
        background: none;
        box-shadow: none;
        padding: 0px 15px;
    }

    p.sub_title {
        font-size: 25px;
    }

}

</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/buygympack.com/resources/views/checkout_iptv.blade.php ENDPATH**/ ?>