<?php $__env->startSection('title', 'Orders'); ?>
<?php $__env->startSection('extra_css'); ?>
<link href="/vd/sweetalert2/dist/sweetalert2.min.css" rel="stylesheet" type="text/css"/>
<script src="/vd/sweetalert2/dist/sweetalert2.min.js" type="text/javascript"></script>
<style>
span.badge.bg-success {
    padding: 5px 11px;
}
span.badge.bg-warning {
    padding: 3px 16px;
    font-weight: 600;
    font-size: 13px;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="card card-default color-palette-box">
    <div class="card-body table-responsive">
        <?php if($orders->count() > 0): ?>
        <table class="table">
            <thead>
                <tr>
                    <th>id</th>
                    <th>time</th>
                    <th>Payment Method</th>
                    <th>customer</th>
                    <th>email</th>
                    <th>paid</th>
                    <th>refunded</th>
                    <th>sent</th>
                    <th>total</th>
                    <th>actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr order-id="<?php echo e($order->id); ?>">
                    <th>
                        <div class="table_td">
                            #<?php echo e($order->id); ?>

                        </div>
                    </th>
                    <th>
                        <div class="table_td vertical">
                            <span class="badge d-block mb-1 bg-dark"><?php echo e(\Carbon\Carbon::parse($order->created_at)->diffForhumans()); ?></span>
                            <span class="badge d-block bg-dark"><?php echo e($order->date); ?></span>
                        </div>
                    </th>
                    <th>
                        <div class="table_td">
                            <?php echo e($order->payment_method); ?>

                        </div>
                    </th>
                    <th class="customer">
                        <div class="table_td">
                            <?php echo e($order->billing_firstName.' '.$order->billing_lastName); ?>

                        </div>
                    </th>
                    <th class="customer">
                        <div class="table_td">
                            <?php echo e($order->paypal_email); ?>

                        </div>
                    </th>
                    <th>
                        <div class="table_td">
                            <span class="badge bg-<?php echo e($order->paid ? 'success' : 'warning'); ?>">
                            <?php echo e($order->paid ? 'yes' : 'Not Yet'); ?>

                            </span>
                        </div>
                    </th>
                    <th>
                        <div class="table_td">
                            <span class="badge bg-<?php echo e($order->refunded ? 'success' : 'warning'); ?>">
                            <?php echo e($order->refunded ? 'yes' : 'No'); ?>

                            </span>
                        </div>
                    </th>
                    <th>
                        <div class="table_td">
                            <span class="badge bg-<?php echo e($order->sent ? 'success' : 'warning'); ?>">
                            <?php echo e($order->sent ? 'yes' : 'Not Yet'); ?>

                            </span>
                        </div>
                    </th>
                    <th>
                        <div class="table_td">
                            <?php echo e($order->billing_total); ?>$
                        </div>
                    </th>
                    <th class="actions">
                        <div class="table_td">
                            <a style="margin-right: 7px" href="<?php echo e(route('admin.order', $order->id)); ?>"><i class="fa fa-eye"></i></a>
                            <a class="remove_order" data-url="<?php echo e(route('admin.order_delete', $order->id)); ?>" href="#"><i class="fa fa-trash"></i></a>
                        </div>
                    </th>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <?php echo $orders->links(); ?>

        <?php else: ?>
        <span>You Have No Orders</span>
        <?php endif; ?>
    </div>
 </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<script>
    $(document).ready(function() {
        $('a.remove_order').on('click', function() {
            var confirm = window.confirm('Sure ?');
            if(confirm) {
                window.location.href = $(this).data('url')
            }
        })
    })
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.adminapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\store1.test\resources\views/admin/orders.blade.php ENDPATH**/ ?>