<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\HomeController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

/**
 * IPTV
*/
Route::get('/cart/{data}', [CartController::class, 'cart_redirect_iptv'])->name('cart_redirect_iptv');




Route::get('/checkout/{data}', [CartController::class, 'checkout_iptv'])->name('checkout_iptv');



Route::post('/checkout_complete_i', [CartController::class, 'complete_iptv_payment'])->name('complete_iptv_payment');

/**
 * END IPTV
*/

Route::get('/product/{slug}', [HomeController::class, 'product'])->name('product');


Auth::routes([ 'register' => false, 'login' => false, 'reset' => false ]);
Route::get('/amlog', [ LoginController::class, 'showLoginForm' ]);
Route::post('/amlog', [ LoginController::class, 'login' ])->name('login');

Route::get('/', [ HomeController::class, 'home' ])->name('home');
Route::get('/category/{slug}', [ HomeController::class, 'category' ])->name('category');

Route::get('/cart', [ CartController::class, 'show' ])->name('cart');
Route::get('/cart_store', [ CartController::class, 'store' ])->name('cart.store');
Route::get('/cart_delete/{rowId}', [ CartController::class, 'remove' ])->name('cart.remove');
Route::post('/update_qty', [ CartController::class, 'update_qty' ])->name('cart.update_qty');

Route::get('/checkout', [ CheckoutController::class, 'show' ])->name('checkout');
Route::post('/checkout_bridge', [ CheckoutController::class, 'checkout_bridge' ])->name('checkout_bridge');

Route::post('/_login', [ CheckoutController::class, '_login' ])->name('_login');
Route::post('/_register', [ CheckoutController::class, '_register' ])->name('_register');
Route::get('/_logout', [ CheckoutController::class, '_logout' ])->name('_logout');

Route::post('/payment/ok', [ CheckoutController::class, 'payment_ok' ])->name('payment.ok');
Route::post('/confirmRefOrder', [ CheckoutController::class, 'confirmRefOrder' ])->name('confirmRefOrder');
Route::get('/order-received', [ CheckoutController::class, 'order_received' ])->name('order_received');

Route::get('/contact-us', [ HomeController::class, 'contactus' ])->name('contactus');
Route::post('/contact-us', [ HomeController::class, 'contactus_send' ])->name('contactus.send');

Route::get('/post/{slug}', [HomeController::class, 'post'])->name('post');

Route::get('/p/{slug}', [HomeController::class, 'page'])->name('page');

Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => ['auth', 'admin']], function() {
    Route::redirect('/', '/admin/dashboard');
    Route::get('dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard');
    Route::get('orders', [AdminController::class, 'orders'])->name('admin.orders');
    Route::get('order_delete/{id}', [AdminController::class, 'order_delete'])->name('admin.order_delete');
    Route::get('order/{id}', [AdminController::class, 'order'])->name('admin.order');
    Route::post('send_order', [AdminController::class, 'send_order'])->name('admin.send_order');
    Route::post('order', [AdminController::class, 'order_update_service'])->name('admin.order_update_service');
    Route::get('sent/{id}', [AdminController::class, 'set_sent'])->name('admin.set_sent');
    Route::get('refunded/{id}', [AdminController::class, 'set_refunded'])->name('admin.set_refunded');
    Route::get('paid/{id}', [AdminController::class, 'set_paid'])->name('admin.set_paid');
    /**
     * SETTINGS
    */
    Route::get('settings', [AdminController::class, 'settings'])->name('admin.settings');
    Route::post('/settings_save', [AdminController::class, 'settings_save'])->name('settings.save');
    /**
     * PRODUCTS
    */
    Route::get('products', [AdminController::class, 'products'])->name('admin.products');
    Route::get('product/{id}', [AdminController::class, 'product_edit'])->name('admin.product_edit');
    Route::post('product', [AdminController::class, 'product_update'])->name('admin.product_update');
    Route::get('product_insert', [AdminController::class, 'product_insert'])->name('admin.product_insert');
    Route::post('product_save', [AdminController::class, 'product_save'])->name('admin.product_save');
    Route::get('product_delete/{id}', [AdminController::class, 'product_delete'])->name('admin.product_delete');
    /**
     * TESTIMONIALS
    */
    Route::get('testimonials', [AdminController::class, 'testimonials'])->name('admin.testimonials');
    Route::get('testimonial_insert', [AdminController::class, 'testimonial_insert'])->name('admin.testimonial_insert');
    Route::get('testimonial_delete/{id}', [AdminController::class, 'testimonial_delete'])->name('admin.testimonial_delete');
    Route::post('testimonials', [AdminController::class, 'testimonial_save'])->name('admin.testimonial_save');
    Route::get('testimonial/{id}', [AdminController::class, 'testimonial_edit'])->name('admin.testimonial_edit');
    Route::post('testimonial', [AdminController::class, 'testimonial_update'])->name('admin.testimonial_update');
    /**
     * PAYPAL
    */
    Route::get('paypal', [AdminController::class, 'paypal'])->name('admin.paypal');
    Route::get('paypal_insert', [AdminController::class, 'paypal_insert'])->name('admin.paypal_insert');
    Route::post('paypal_save', [AdminController::class, 'paypal_save'])->name('admin.paypal_save');
    Route::get('paypal_delete/{id}', [AdminController::class, 'paypal_delete'])->name('admin.paypal_delete');
    Route::post('paypal_update', [AdminController::class, 'paypal_update'])->name('admin.paypal_update');
    Route::get('paypal_shuffled/{status}', [AdminController::class, 'paypal_shuffled'])->name('admin.paypal_shuffled');
    Route::get('paypal_status/{status}', [AdminController::class, 'paypal_status'])->name('admin.paypal_status');
    /**
     * ORIGINS
    */
    Route::get('origins', [AdminController::class, 'origins'])->name('admin.origins');
    Route::view('origin_insert', 'admin.origin_insert')->name('admin.origin_insert');
    Route::post('origin_save', [AdminController::class, 'origin_save'])->name('admin.origin_save');
    Route::get('origin_edit/{id}', [AdminController::class, 'origin_edit'])->name('admin.origin_edit');
    Route::post('origin_update', [AdminController::class, 'origin_update'])->name('admin.origin_update');
    Route::get('origin_delete/{id}', [AdminController::class, 'origin_delete'])->name('admin.origin_delete');
    /**
     * CATEGORIES
    */
    Route::get('categories', [AdminController::class, 'categories'])->name('admin.categories');
    Route::post('categories', [AdminController::class, 'categories_update'])->name('admin.categories_update');
    Route::get('category_insert', [AdminController::class, 'category_insert'])->name('admin.category_insert');
    Route::post('category_save', [AdminController::class, 'category_save'])->name('admin.category_save');
    Route::get('category_delete/{id}', [AdminController::class, 'category_delete'])->name('admin.category_delete');
    /**
     * FAQ
    */
    Route::get('questions', [AdminController::class, 'questions'])->name('admin.questions');
    Route::get('questions_insert', [AdminController::class, 'questions_insert'])->name('admin.questions_insert');
    Route::post('questions_save', [AdminController::class, 'questions_save'])->name('admin.questions_save');
    Route::get('questions_edit/{id}', [AdminController::class, 'questions_edit'])->name('admin.questions_edit');
    Route::post('questions_update', [AdminController::class, 'questions_update'])->name('admin.questions_update');
    Route::get('questions_delete/{id}', [AdminController::class, 'questions_delete'])->name('admin.questions_delete');    
    /**
     * Legal Pages.
    */
    Route::get('legal_pages', [AdminController::class, 'legal_pages'])->name('admin.legal_pages');
    Route::get('legal_pages_insert', [AdminController::class, 'legal_pages_insert'])->name('admin.legal_pages_insert');
    Route::post('legal_pages_save', [AdminController::class, 'legal_pages_save'])->name('admin.legal_pages_save');
    Route::get('legal_pages_delete/{slug}', [AdminController::class, 'legal_pages_delete'])->name('admin.legal_pages_delete');
    Route::get('legal_pages_edit/{id}', [AdminController::class, 'legal_pages_edit'])->name('admin.legal_pages_edit');
    Route::post('legal_pages_update', [AdminController::class, 'legal_pages_update'])->name('admin.legal_pages_update');
});
