@extends('layouts.app')
@section('title', 'My Orders')
@section('content')
<div class="container">
    <div id="client_area" class="orders">
        <h1>My Orders</h1>
        <div id="content">
            @if ( $orders->count() > 0)
            <table class="table">
                <thead>
                    <tr>
                       <th scope="col"></th>
                       <th scope="col">Service</th>
                       <th scope="col">Total Paid</th>
                       <th scope="col">Status</th>
                       <th scope="col">Order Date</th>
                       <th scope="col">Actions</th>
                    </tr>
                 </thead>
                 <tbody>
                    @foreach ($orders as $order)
                    <tr>
                        <th scope="row">#{{$order->id}}</th>
                        <td>{{$order->service->title}}</td>
                        <td>{{$order->billing_total}} $</td>
                        <td class="status">
                            @if ($order->service->processing)
                            <span class="badge bg-dark processing">Processing</span>
                            @elseif(!$order->service->processing && $order->service->expired)
                            <span class="badge bg-danger expired">Expired</span>
                            @elseif(!$order->service->processing && !$order->service->expired)
                            <span class="badge bg-success active">Active</span>
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-primary">{{$order->created_at->format('d-m-Y')}}</span>
                        </td>
                        <td><a class="show_service" href="{{route('order', $order->id)}}"><i class="fa fa-eye"></i> Show Details</a></td>
                    </tr>
                    @endforeach

                 </tbody>
            </table>               
            @else
            <span>No Orders Yet</span>
            @endif
        </div>
    </div>
</div>
@endsection