@extends('layouts.app')
@section('title', 'Order N°'.$order->id)
@section('content')
<div class="container">
    <div id="client_area" class="order">
        <h1>Order N° {{$order->id}}</h1>
        <div class="order_content">
            <div class="row">
                <div class="col-md-6">
                    <div class="left_side">
                        <i class="fa fa-gratipay"></i>
                        <p>{{$order->service->title}}</p>
                        @if ($order->service->processing)
                        <span class="badge bg-dark processing">Processing</span>
                        @elseif(!$order->service->processing && $order->service->expired)
                        <span class="badge bg-danger expired">Expired</span>
                        @elseif(!$order->service->processing && !$order->service->expired)
                        <span class="badge bg-success active">Active</span>
                        @endif
                     </div>
                </div>
                <div class="col-md-6">
                    <div class="right_side">
                        <ul>
                           <li>
                                <span class="label">Ordering Date</span>
                                @if ($order->service->created_at)
                                <span class="value">{{$order->service->created_at->format('l, F jS, Y')}}</span>
                                @else
                                <span class="value">-</span>
                                @endif
                           </li>
                           <li>
                                <span class="label">Activation Date</span>
                                @if ($order->service->activation_date)
                                <span class="value">{{$order->service->activation_date->format('l, F jS, Y')}}</span>
                                @else
                                <span class="value">-</span>
                                @endif
                           </li>
                           <li>
                                <span class="label">Expiration Date</span>
                                @if ($order->service->expiration_date)
                                <span class="value">{{$order->service->expiration_date->format('l, F jS, Y')}}</span>
                                @else
                                <span class="value">-</span>
                                @endif
                           </li>
                           <li>
                              <span class="label">Recurring Amount</span>
                              <span class="value">{{$order->billing_total}} $</span>
                           </li>
                           <li>
                              <span class="label">Payment Method</span>
                              <span class="value payment">{{$order->payment_method == "cc" ? "Credit / Debit Cards" : "PayPal"}}</span>
                           </li>
                        </ul>
                     </div>
                </div>
            </div>
            <div class="row">
                <div class="subcription_details">
                    <div class="col-md-12">
                        @php
                            $application = \App\Models\Application::whereId($order->service->application_id)->first()->name;
                            $device = \App\Models\Device::whereId($order->service->device_id)->first()->name;
                        @endphp
                        <ul>
                            @if( str_contains($device, 'enigma') )
                            <li>
                                <div class="mb-3">
                                    <label for="enigma_16" class="form-label">Enigma 1.6</label>
                                    <textarea id="enigma_16" class="form-control" cols="30" rows="3" disabled>{{$order->service->enigma_16}}</textarea>
                                </div>
                            </li>
                            <li>
                                <div class="mb-3">
                                    <label for="enigma_2" class="form-label">Enigma 2</label>
                                    <textarea id="enigma_2" class="form-control" cols="30" rows="3" disabled>{{$order->service->enigma_2}}</textarea>
                                </div>
                            </li>
                            
                            @elseif ( str_contains($device, 'mag')
                                || str_contains($device, 'formuler')
                                || str_contains($application, 'stb') 
                                || str_contains($application, 'mytvonline') 
                            )
                            <li>
                                <div class="mb-3">
                                    <label for="mac_address" class="form-label">Mac Address</label>
                                    <input type="text" class="form-control" id="mac_address" value="{{$order->service->mac_address}}" disabled>
                                </div>
                            </li>
                            <li>
                                <div class="mb-3">
                                    <label for="portal" class="form-label">Portal</label>
                                    <input type="text" class="form-control" id="portal" value="{{$order->service->host}}" disabled>
                                </div>
                            </li>
                            @else
                            <li>
                                <div class="mb-3">
                                    <label for="host" class="form-label">Host</label>
                                    <input type="text" class="form-control" id="host" value="{{$order->service->host}}" disabled>
                                </div>
                            </li>
                            <li>
                                <div class="mb-3">
                                    <label for="username" class="form-label">Username</label>
                                    <input type="text" class="form-control" id="username" value="{{$order->service->username}}" disabled>
                                </div>
                            </li>
                            <li>
                                <div class="mb-3">
                                    <label for="password" class="form-label">Password</label>
                                    <input type="text" class="form-control" id="password" value="{{$order->service->password}}" disabled>
                                </div>
                            </li>
                            @endif
                        </ul>
                    </div>
                 </div>
            </div>
        </div>
    </div>
</div>
@endsection