@extends('layouts.app')
@section('title', $category->name)
@section('content')
<div class="jkh_products">
    <div class="container">
        <h1>{{$category->name}}</h1>
        <div class="row">
            @foreach ($category->products as $product)
            <div class="col-md-3">
                <div class="product">
                    <a href="{{route('product', $product->slug)}}">
                        @if ($product->hot == 1) <span class="hot">Hot</span>@endif
                        <img class="poster img-fluid" src="{{asset('storage/'.$product->poster)}}" />
                        <div class="info">
                            <h2 class="title">{{$product->title}}</h2>
                            <div class="more">
                                <span class="price">{{$product->price}}$</span>
                                <span class="old_price">{{$product->old_price}}$</span>
                            </div>
                            <div class="buttons">
                                <a href="{{route('cart.store', [ 'id' => $product->id ])}}" class="btn btn-danger buy_now">Buy Now</a>
                            </div>
                        </div>
                    </a>
                </div>
            </div> 
            @endforeach
        </div>
    </div>
</div>
@endsection
@section('extra_css')
<style>

</style>
@endsection