@extends('layouts.app')
@section('extra_css')
<style>
.auth-form {
   background: #030e2e;
   border-radius: 14px;
   padding: 49px 53px;
   margin: 70px 0;
   color: white;
}
h1.login_text {
    font-size: 28px;
    font-weight: 500;
    margin-bottom: 40px;
}
.form-control {
    background: #121d3d;
    color: white;
    height: 43px;
    border-color: #121d3d;
    border-radius: 12px;
}
.form-control:focus {
   background: #121d3d;
   color: white;
   border-color: #14224c;
}
.custom-control {
    padding: 7px 0;
}
.auth-form a {
    color: #e6ff00!important;
}
.auth-form p {
   margin: 0;
}
button.reset {
    display: block;
    width: 100%;
    background: #05247e;
    border: none;
    border-radius: 9px;
    padding: 10px 0;
}
button.reset:hover {
    background: #031c68;
    transition: 0.3s
}
</style>
@endsection
@section('content')
<div class="authincation">
   <div class="container">
      <div class="row justify-content-center align-items-center">
         <div class="col-md-6">
            <div class="authincation-content">
               <div class="row no-gutters">
                  <div class="col-xl-12">
                     <div class="auth-form">
                        <h4 class="text-center mb-4">Reset Password</h4>
                        <form method="POST" action="{{ route('password.update') }}">
                          @csrf
                            <input type="hidden" name="token" value="{{ $token }}">
                           <div class="form-group mb-4">
                              <label class="mb-2"><strong>Email</strong></label>
                              <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ $email ?? old('email') }}" required autocomplete="email" autofocus>

                              @error('email')
                                  <span class="invalid-feedback" role="alert">
                                      <strong>{{ $message }}</strong>
                                  </span>
                              @enderror
                           </div>
                           <div class="form-group mb-4">
                                <label class="mb-2"><strong>New Password</strong></label>
                                <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password">
                                @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                           </div>
                           <div class="form-group">
                              <label class="mb-2"><strong>Confirm New Password</strong></label>
                              <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">
                            </div>
                           <div class="text-center mt-4">
                              <button type="submit" class="btn btn-primary reset">Reset Password</button>
                           </div>
                        </form>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
@endsection





{{-- @section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('Reset Password') }}</div>

                <div class="card-body">
                    <form method="POST" action="{{  }}">
                        @csrf



                        <div class="form-group row">
                            <label for="password" class="col-md-4 col-form-label text-md-right">{{ __('Password') }}</label>

                            <div class="col-md-6">
                                
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="password-confirm" class="col-md-4 col-form-label text-md-right">{{ __('Confirm Password') }}</label>

                            <div class="col-md-6">
                            </div>
                        </div>

                        <div class="form-group row mb-0">
                            <div class="col-md-6 offset-md-4">
                                <button type="submit" class="btn btn-primary">
                                    {{ __('Reset Password') }}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection --}}
