@extends('layouts.adminapp')
@section('title', 'Edit Question')
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
    <a href="{{route('admin.questions')}}" class="goback btn btn-danger"><i class="fa fa-arrow-left"></i>Go Back</a>
 </div>
<div class="card card-default color-palette-box admin_product">
    <div class="card-body">
        <form action="{{route('admin.questions_update')}}" method="POST">
            @csrf
            <input type="hidden" name="id" value="{{$question->id}}" />
            <div class="row">
                <div class="mb-3 col-md-9">
                    <label for="question" class="form-label">Question</label>
                    <input type="text" name="question" class="form-control" placeholder="Question" id="question" value="{{$question->question}}">
                </div>
                <div class="mb-3 col-md-9">
                    <label for="answer" class="form-label">Answer</label>
                    <textarea class="ckeditor form-control" name="answer" id="answer" rows="4" cols="10">{{$question->answer}}</textarea>
                </div>
                <div class="mb-3 col-md-9">
                    <label for="visibility" class="form-label">Visibility</label>
                    <select class="form-control" id="visibility" name="visibility">
                        <option value="1" {{$question->visibility == 1 ? 'selected' : ''}}>YES</option>
                        <option value="0" {{$question->visibility == 0 ? 'selected' : ''}}>NO</option>
                    </select>
                </div>
            </div>
            <div class="mb-3">
                <button class="btn btn-primary" type="submit">UPDATE</button>
            </div>
        </form>
    </div>
</div>
@endsection
@section('extra_js')
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script type="text/javascript">
    $(document).ready(function () {
        $('.ckeditor').ckeditor();
    });
</script>
@endsection