@extends('layouts.adminapp')
@section('title', 'Origins')
@section('content')
<div class="form-head">
   <a href="{{route('admin.origin_insert')}}" class="goback btn btn-danger"><i class="fa fa-plus"></i>New Origin</a>
</div>
<div class="card card-default color-palette-box">
   <div class="card-body">
      <div class="table-responsive">
         @if (count($origins) > 0)
         <table class="table" width="100%">
            <thead>
               <tr>
                  <th scope="col"></th>
                  <th scope="col">name</th>
                  <th scope="col">url</th>
                  <th scope="col">status</th>
                  <th scope="col">creation date</th>
                  <th scope="col">actions</th>
               </tr>
            </thead>
            <tbody>
               @foreach($origins as $origin)
               <tr class="product-table">
                  <td>{{$origin->id}}</td>
                  <td>{{ $origin->name }}</td>
                  <td>{{$origin->url}}</td>
                  <td>
                     <span class="badge bg-{{$origin->active == '1' ? 'success' : 'warning'}}">
                        {{$origin->active == '1' ? 'Active' : 'Not Active'}}
                     </span>
                  </td>
                  <td>{{$origin->created_at}}</td>
                  <td class="actions">
                     <a href="{{route('admin.origin_edit', $origin->id)}}"><i class="edit fa fa-pencil"></i></a>
                     <a href="{{route('admin.origin_delete', $origin->id)}}"><i class="edit fa fa-trash"></i></a>
                  </td>
               </tr>
               @endforeach
            </tbody>
         </table>
         @else
         <p>No Origins</p>
         @endif
      </div>
   </div>
</div>
@endsection
@section('extra_css')
    <style>
      tr.product-table td {
         color: black;
         text-transform: none!important;
      }
      span.badge.bg-success {
         padding: 4px 5px;
         border-radius: 6px!important;
      }
    </style>
@endsection
@section('extra_body')
<script>
   // $(document).ready(() => {
   //   $('.remove_product').on('click', function(e) {
   //     e.preventDefault()
   //     var confirmA = confirm('Delete The Origin ?')
   //     var product_id = $(this).attr('data-id')
   //     var link = "{{}}"
   //     if(confirmA) {
   //       window.location.href = link.replace('/0', '/'+product_id)
   //     }
   //   });
   // })
</script>
@endsection