@extends('layouts.adminapp')
@section('title', 'Edit Origin N°'.$origin->id)
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
    <a href="{{route('admin.origins')}}" class="goback btn btn-danger"><i class="fa fa-arrow-left"></i>Go Back</a>
</div>
<div>
    <div class="table-responsive pb-4">
        <form class="" action="{{route('admin.origin_update')}}" method="POST" enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="id" value="{{$origin->id}}">
            <div class="row">
                <div class="mb-3 col-md-9">
                    <label for="name" class="form-label">Name</label>
                    <input type="text" name="name" class="form-control" placeholder="Name" id="name" value="{{$origin->name}}">
                </div>
                <div class="mb-3 col-md-9">
                    <label for="url" class="form-label">Url</label>
                    <input type="text" name="url" class="form-control" placeholder="url" id="url" value="{{$origin->url}}">
                </div>
                <div class="col-md-9 mb-3">
                    <label for="logo" class="form-label">Logo</label>
                    <input type="file" class="form-control" name="logo" id="logo">
                </div>
            </div>
            <div class="row">
                <div class="col-md-3 my-3 form-group">
                    <label for="active">Active</label>
                    <select class="form-select" name="active">
                        <option value='1' {{$origin->active == 1 ? 'selected' : ''}}>YES</option>
                        <option value='0' {{$origin->active == 0 ? 'selected' : ''}}>NO</option>
                    </select>
                </div>
            </div>
            <div class="mb-3">
                <button class="btn btn-primary" type="submit">Update</button>
            </div>
        </form>
    </div>
</div>
@endsection
@section('extra_body')

@endsection