<?php

namespace Database\Seeders;

use App\Models\Product;
use Illuminate\Support\Facades\File;
use Illuminate\Database\Seeder;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * MEN;
        */
        File::copy(public_path('images/products/1.png'), 'storage/app/public/prod1.png');
        Product::create([
            'category_id' => 1,
            'title' => '20-Minute Miracles: Fast Workouts for Big Results',
            'short_title' => '#',
            'slug' => '20-Minute-Miracles-Fast-Workouts-for-Big-Results',
            'poster' => 'prod1.png',
            'description' => '<p>Pressed for time but still want to stay fit, tone up, and feel amazing?<em>20 for 20</em>is the perfect workout guide for busy individuals like you. Whether you&rsquo;re balancing a demanding job, managing a household, commuting, or simply struggling to squeeze in exercise, this e-book makes fitness simple and accessible.</p><p>With 20 efficient workouts designed to be completed in just 20 minutes, you&rsquo;ll see how easy it is to prioritize your health. These workouts require little to no equipment, so you can do them anywhere&mdash;at home, in the park, or even on your lunch break.</p><h3>Inside, you&rsquo;ll find:</h3><p>✔️ Effective bodyweight exercises for full-body strength and toning.<br>✔️ Workouts suited for all fitness levels, from beginners to advanced.<br>✔️ Fast-paced routines to burn fat, build muscle, and boost energy.</p><p><em>20 for 20</em>is your ultimate solution for staying in shape, no matter how packed your schedule is. Ready to transform your fitness in just 20 minutes a day? Grab your copy now!</p>',
            'price' => 28.99,
            'old_price' => 40.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);


        File::copy(public_path('images/products/4.png'), 'storage/app/public/prod4.png');
        Product::create([
            'category_id' => 1,
            'title' => '12-Week Body-Shaping Workout Plan for Men',
            'short_title' => '#',
            'slug' => '12-week-body-shaping-workout-plan-for-men',
            'poster' => 'prod4.png',
            'description' => '<p><strong>Transform Your Body in Just 12 Weeks!</strong></p><p>This<strong>step-by-step weight training plan</strong>is designed to help you<strong>burn fat, build muscle, and sculpt a stronger physique</strong>.</p><p>If you&rsquo;re ready to<strong>get in the best shape of your life</strong>, this program is for you! Designed for<strong>beginners and beyond</strong>, this<strong>strength and conditioning plan</strong>combines<strong>compound movements</strong>that engage multiple muscle groups with<strong>targeted exercises</strong>for maximum results. Follow this<strong>12-week program</strong>, and you&rsquo;ll be a<strong>new man&mdash;stronger, leaner, and more confident</strong>!</p><h3><strong>What&rsquo;s Inside?</strong></h3><p>✔<strong>A structured 12-week plan</strong>&ndash; A day-by-day workout guide<br>✔<strong>Three progressive phases</strong>&ndash; Each lasting four weeks to ensure continuous growth<br>✔<strong>Detailed workouts</strong>&ndash; 75 movements with step-by-step instructions and video demonstrations<br>✔<strong>Weekly progress tracking sheets</strong>&ndash; Stay motivated and monitor your results</p><p>With<strong>39 pages packed with expert-designed workouts</strong>, this plan will help you<strong>build strength, endurance, and definition</strong>&mdash;all while creating lasting fitness habits.</p><p>Ready to take your transformation to the next level?<strong>Start today!</strong>🚀</p>',
            'price' => 37.99,
            'old_price' => 47.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);

        File::copy(public_path('images/products/5.png'), 'storage/app/public/prod5.png');
        Product::create([
            'category_id' => 1,
            'title' => '8 Weeks Men\'s Gym Program',
            'short_title' => '#',
            'slug' => '8-weeks-mens-gym-program',
            'poster' => 'prod5.png',
            'description' => '<h3><strong>8-Week Body Recomposition Program</strong></h3><p><strong>Burn Fat, Build Muscle &amp; Transform Your Physique</strong></p><p>This&nbsp;<strong>gym-based program</strong>&nbsp;is designed for lifters who know their way around the weights but want to&nbsp;<strong>level up</strong>&mdash;shedding stubborn fat while maintaining (or even gaining) muscle for a leaner, stronger physique.</p><p>Perfect for&nbsp;<strong>intermediate to advanced lifters</strong>, this plan pushes you beyond plateaus with&nbsp;<strong>structured, science-backed training</strong>&nbsp;that delivers real results.</p><h3><strong>What&rsquo;s Inside?</strong></h3><p>✔&nbsp;<strong>8 weeks of progressive workouts</strong>&nbsp;&ndash; No guesswork, just gains.<br>✔&nbsp;<strong>6 intense sessions per week</strong>&nbsp;&ndash; Lower Body, Upper Body &amp; Steady State Cardio.<br>✔&nbsp;<strong>Resistance training focus</strong>&nbsp;&ndash; Maximize fat loss without sacrificing muscle.<br>✔&nbsp;<strong>Bonus: Dietitian-approved nutrition &amp; cutting tips</strong>&nbsp;&ndash; Fuel your recomposition right.<br>✔&nbsp;<strong>Video demos for every exercise</strong>&nbsp;&ndash; Perfect your form, avoid injury.<br>✔&nbsp;<strong>Built-in progress trackers</strong>&nbsp;&ndash; Log weights, reps, and measurements.<br>✔&nbsp;<strong>Follow-along warm-ups, cool-downs &amp; stretches</strong>&nbsp;&ndash; Optimize recovery.</p><h3><strong>Who&rsquo;s It For?</strong></h3><p>🔥&nbsp;<strong>You&rsquo;re not new to the gym</strong>&nbsp;&ndash; You know your way around weights but need structure.<br>🔥&nbsp;<strong>You want a challenge</strong>&nbsp;&ndash; Tired of spinning your wheels? This plan pushes you.<br>🔥&nbsp;<strong>You&rsquo;re serious about recomposition</strong>&nbsp;&ndash; Lose fat, keep muscle, and look&nbsp;<em>defined</em>.</p><p><strong>Ready to transform in 8 weeks?</strong>&nbsp;Let&rsquo;s get after it.</p>',
            'price' => 26.99,
            'old_price' => 37.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);

        File::copy(public_path('images/products/7.png'), 'storage/app/public/prod7.png');
        Product::create([
            'category_id' => 1,
            'title' => 'Get 6-Pack Abs Fast With US',
            'short_title' => '#',
            'slug' => 'get-6-pack-abs-quick',
            'poster' => 'prod7.png',
            'description' => '<p><strong>6-Pack Abs Blueprint: Your Guide to a Shredded Core</strong><br><em>Science-Backed Training + Nutrition to Finally Reveal Your Abs</em><p>This <strong>abs-focused program</strong> cuts through the myths and delivers <strong>real results</strong> with just <strong>15-20 minutes of targeted training per day</strong> - no endless crunches required.<p>Using <strong>proven core activation techniques and smart nutrition strategies</strong>, you\'ll systematically strip away fat while building those coveted abdominal muscles.<h3><strong>Here\'s What You Get:</strong></h3><p>🔥 <strong>Progressive ab workouts</strong> (no-equipment & gym options)<br>🔥 <strong>Targeted core training</strong> - hit all abdominal muscles effectively<br>🔥 <strong>Fat-loss nutrition guide</strong> - exactly what to eat to reveal your abs<br>🔥 <strong>60+ page eBook with exercise library</strong> - train anywhere, anytime<br>🔥 <strong>Progress trackers</strong> - monitor your measurements and strength gains<br>🔥 <strong>Video demonstrations</strong> - perfect form for maximum results<br>🔥 <strong>Bonus:</strong> <em>"7-Day Abs Meal Plan"</em> with simple, effective recipes<h3><strong>This Program Works If:</strong></h3><p>✔ You\'re tired of doing hundreds of crunches with no results<br>✔ You want visible abs but don\'t know the right approach<br>✔ You\'re ready to combine smart training with proper nutrition<br>✔ You have 15-20 minutes/day to dedicate to your core goals<p><strong>Stop wasting time on ineffective ab workouts.</strong> This is your shortcut to a defined midsection.',
            'price' => 112.99,
            'old_price' => 129.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => false,
        ]);

        /**
         * WOMEN;
        */

        File::copy(public_path('images/products/2.png'), 'storage/app/public/prod2.png');
        Product::create([
            'category_id' => 2,
            'title' => 'The 12-Week Shred Plan for Women',
            'short_title' => '#',
            'slug' => 'the-12-week-shred-plan-for-women',
            'description' => '<p><strong>Get Beach Body Ready: The Ultimate 12-Week Fitness Plan for Women</strong></p><p>If you&rsquo;re ready to get in the best shape of your life and feel confident just in time for summer, this plan is for you!</p><p>This<strong>comprehensive 60-page total body program</strong>is packed with expert advice, structured workout guidance, and essential support&mdash;all in one convenient guide. With a strong focus on<strong>strength and conditioning resistance training</strong>(the best method for toning and sculpting), plus a<strong>3-phase workout plan and complete nutrition guide</strong>, you&#39;ll achieve your ultimate fitness goals in just 12 weeks.</p><h3>Your Personal Trainer in a Book</h3><p>This program offers a<strong>full-body weight training plan</strong>broken into three progressive phases, along with a detailed<strong>nutrition guide</strong>that covers everything from macro calculations to delicious meal ideas. It&#39;s designed to help you<strong>burn fat, build muscle, and boost confidence</strong>&mdash;all while following a structured, easy-to-follow plan.</p><h3>What&rsquo;s Inside:</h3><p>📖<strong>Welcome &amp; Complete Overview</strong><br>🥗<strong>Nutrition Essentials</strong>&ndash; Energy balance, fat loss, calorie calculations, macronutrient breakdowns, and personalized meal planning.<br>🍽<strong>Delicious Recipes</strong>&ndash; Tasty and easy meal ideas for breakfast, lunch, dinner, and snacks.<br>💪<strong>Workout Phases 1-3</strong>&ndash; A structured strength training plan to shape and tone your entire body.<br>⚡<strong>Recovery &amp; Supplements</strong>&ndash; Sleep, recovery tips, and recommended supplements to maximize results.</p><p>Created by<strong>fitness experts</strong>, this plan is perfect for women who want a<strong>dedicated, results-driven approach</strong>to transforming their bodies in just 12 weeks. Whether you&#39;re a beginner or experienced, this guide gives you everything you need to<strong>stay on track and achieve your dream summer body!</strong></p><p>Are you ready to<strong>take control and sculpt your best self</strong>? Start your transformation today!</p>',
            'poster' => 'prod2.png',
            'price' => 29.99,
            'old_price' => 39.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => true,
        ]);


        File::copy(public_path('images/products/3.png'), 'storage/app/public/prod3.png');
        Product::create([
            'category_id' => 2,
            'title' => '12-Week Body Sculpting Workout Plan for Women',
            'short_title' => '#',
            'slug' => '12-week-body-sculpting-workout-plan-for-women',
            'description' => '<p><strong>Get the Body You Want in Just 12 Weeks!</strong></p><p>This<strong>step-by-step weight training plan</strong>is designed to help women<strong>lose fat, tone up, and build lean muscle</strong>effectively.</p><p>Worried about getting bulky? Don&rsquo;t be! Unless you&rsquo;re following an extreme bodybuilding regimen with thousands of extra calories, that won&rsquo;t happen. In fact,<strong>weight training is one of the best forms of exercise for women</strong>&mdash;it strengthens muscles, supports hormonal and bone health, improves body composition, and boosts overall well-being. The outdated belief that lifting weights isn&rsquo;t for women is a myth&mdash;science proves it&rsquo;s one of the most powerful ways to achieve your fitness goals!</p><p>This<strong>comprehensive 39-page guide</strong>walks you through<strong>full-body strength and conditioning workouts</strong>designed to help you<strong>lose weight, build endurance, and sculpt your body</strong>.</p><h3><strong>What&rsquo;s Inside?</strong></h3><p>✔<strong>A complete 12-week plan</strong>&ndash; A structured, day-by-day program<br>✔<strong>Three progressive phases</strong>&ndash; Each lasting four weeks to ensure continuous progress<br>✔<strong>Detailed workouts</strong>&ndash; 75 movements with step-by-step instructions and video demonstrations<br>✔<strong>Weekly progress tracking sheets</strong>&ndash; Stay motivated and measure your success</p><p>💥<strong>Bonus:</strong>We&rsquo;re including a<strong>FREE meal prep guide</strong>! Get essential tips on nutrition, portion sizes, macro cheat sheets, and everything you need to<strong>fuel your workouts and maximize results</strong>.</p><p>Take the guesswork out of your fitness journey&mdash;follow this proven plan and<strong>achieve the toned, strong body you&rsquo;ve always wanted in just 12 weeks!</strong>🚀</p>',
            'poster' => 'prod3.png',
            'price' => 59.99,
            'old_price' => 79.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => true,
        ]);

        File::copy(public_path('images/products/6.png'), 'storage/app/public/prod6.png');
        Product::create([
            'category_id' => 2,
            'title' => 'Women\'s 8 Week Gym Program',
            'short_title' => '#',
            'slug' => 'womens-8-week-gym-program',
            'description' => '<h3><strong>8-Week Body Transformation Program</strong></h3><p><em>Burn Fat, Build Strength & Sculpt Your Best Body Yet</em><p>This <strong>gym-based training system</strong> delivers serious results with just <strong>4 focused workouts + 1 cardio session per week</strong> - perfect for busy lifters who want maximum efficiency.<p>Using <strong>progressive dumbbell and barbell training</strong>, you\'ll <strong>torch fat while building lean muscle</strong> for that strong, toned physique you\'ve been working toward.<h3><strong>Here\'s What You Get:</strong></h3><p>🔥 <strong>8 weeks of expertly-designed workouts</strong> (Upper, Lower & Full Body splits)<br>🔥 <strong>Smart resistance training</strong> - no fluff, just science-backed strength building<br>🔥 <strong>+1 weekly cardio session</strong> (choose your favorite style)<br>🔥 <strong>95+ page eBook & online course</strong> - train with confidence anywhere<br>🔥 <strong>Built-in progress trackers</strong> - watch your weights and reps climb<br>🔥 <strong>Exercise video library</strong> - perfect your form, prevent injuries<br>🔥 <strong>Follow-along mobility routines</strong> - warm up, cool down and recover right<br>🔥 <strong>BONUS:</strong> <em>"3 Habits to 10X Your Results"</em> mini-guide<h3><strong>This Program Is Perfect For You If:</strong></h3><p>✔ You`\'re ready to move beyond random workouts<br>✔ You want clear structure without living in the gym<br>✔ You\'re tired of programs that don\'t deliver visible results<br>✔ You know your way around weights but need better programming<p><strong>Stop spinning your wheels.</strong> This is your roadmap to a leaner, stronger body in just 8 weeks.',
            'poster' => 'prod6.png',
            'price' => 79.99,
            'old_price' => 89.99,
            'visibility' => true,
            'in_stock' => true,
            'hot' => true,
        ]);

    }
}
